/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.ui.javafx;

import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.animation.TranslateTransition;
import javafx.beans.value.ObservableValue;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import net.time4j.engine.CalendarDate;
import net.time4j.ui.javafx.CalendarControl;
import net.time4j.ui.javafx.FXCalendarSystem;
import net.time4j.ui.javafx.MonthView;
import net.time4j.ui.javafx.SlidingStackPane;
import net.time4j.ui.javafx.YearView;

class CalendarView<T extends CalendarDate>
extends StackPane {
    private SlidingStackPane<T> monthView;
    private SlidingStackPane<T> yearView;
    private SlidingStackPane<T> birdView;

    CalendarView(CalendarControl<T> calendarControl, FXCalendarSystem<T> fXCalendarSystem, Button button) {
        this.monthView = new SlidingStackPane<T>(new MonthView<T>(calendarControl, fXCalendarSystem, true), new MonthView<T>(calendarControl, fXCalendarSystem, false));
        this.yearView = new SlidingStackPane<T>(new YearView<T>(calendarControl, fXCalendarSystem, true), new YearView<T>(calendarControl, fXCalendarSystem, false));
        this.getChildren().addAll((Object[])new Node[]{this.monthView, this.yearView});
        this.monthView.updateVisibility(true);
        this.yearView.updateVisibility(false);
        if (fXCalendarSystem.getMaxView() >= 2) {
            this.birdView = new SlidingStackPane<T>(fXCalendarSystem.getBirdView(calendarControl, true), fXCalendarSystem.getBirdView(calendarControl, false));
            this.getChildren().add(this.birdView);
            this.birdView.updateVisibility(false);
        } else {
            this.birdView = null;
        }
        calendarControl.viewIndexProperty().set(0);
        calendarControl.navigationTitleProperty().bind((ObservableValue)this.monthView.getCurrentTitle());
        calendarControl.navigationInfoProperty().bind((ObservableValue)this.monthView.getCurrentInfo());
        calendarControl.selectedDateProperty().addListener(observable -> calendarControl.viewIndexProperty().set(0));
        calendarControl.viewIndexProperty().addListener((observableValue, number, number2) -> {
            calendarControl.navigationTitleProperty().unbind();
            calendarControl.navigationInfoProperty().unbind();
            block0 : switch (number.intValue()) {
                case 0: {
                    this.monthView.updateVisibility(false);
                    switch (number2.intValue()) {
                        case 1: {
                            calendarControl.navigationTitleProperty().bind((ObservableValue)this.yearView.getCurrentTitle());
                            calendarControl.navigationInfoProperty().bind((ObservableValue)this.yearView.getCurrentInfo());
                            this.show(calendarControl, button, this.yearView);
                            this.yearView.updateVisibility(true);
                        }
                    }
                    break;
                }
                case 1: {
                    this.yearView.updateVisibility(false);
                    switch (number2.intValue()) {
                        case 0: {
                            this.hide(calendarControl, button, this.yearView);
                            calendarControl.navigationTitleProperty().bind((ObservableValue)this.monthView.getCurrentTitle());
                            calendarControl.navigationInfoProperty().bind((ObservableValue)this.monthView.getCurrentInfo());
                            this.monthView.updateVisibility(true);
                            break;
                        }
                        case 2: {
                            calendarControl.navigationTitleProperty().bind((ObservableValue)this.birdView.getCurrentTitle());
                            calendarControl.navigationInfoProperty().bind((ObservableValue)this.birdView.getCurrentInfo());
                            this.show(calendarControl, button, this.birdView);
                            this.birdView.updateVisibility(true);
                        }
                    }
                    break;
                }
                case 2: {
                    this.birdView.updateVisibility(false);
                    switch (number2.intValue()) {
                        case 0: {
                            this.yearView.updateVisibility(false);
                            this.hide(calendarControl, button, this.birdView);
                            calendarControl.navigationTitleProperty().bind((ObservableValue)this.monthView.getCurrentTitle());
                            calendarControl.navigationInfoProperty().bind((ObservableValue)this.monthView.getCurrentInfo());
                            this.monthView.updateVisibility(true);
                            break block0;
                        }
                        case 1: {
                            this.hide(calendarControl, button, this.birdView);
                            calendarControl.navigationTitleProperty().bind((ObservableValue)this.yearView.getCurrentTitle());
                            calendarControl.navigationInfoProperty().bind((ObservableValue)this.yearView.getCurrentInfo());
                            this.yearView.updateVisibility(true);
                        }
                    }
                }
            }
            button.requestFocus();
        });
    }

    private void show(CalendarControl<T> calendarControl, Button button, SlidingStackPane slidingStackPane) {
        this.showOrHide(calendarControl, button, slidingStackPane, true);
    }

    private void hide(CalendarControl<T> calendarControl, Button button, SlidingStackPane slidingStackPane) {
        this.showOrHide(calendarControl, button, slidingStackPane, false);
    }

    private void showOrHide(CalendarControl<T> calendarControl, Button button, SlidingStackPane slidingStackPane, boolean bl) {
        Duration duration = (Duration)calendarControl.lengthOfAnimationsProperty().get();
        if (duration.lessThanOrEqualTo(Duration.ZERO)) {
            if (!bl) {
                button.requestFocus();
            }
            slidingStackPane.updateVisibility(bl);
            return;
        }
        slidingStackPane.updateVisibility(true);
        calendarControl.ongoingTransitionsProperty().set(calendarControl.ongoingTransitionsProperty().get() + 1);
        TranslateTransition translateTransition = new TranslateTransition(duration, (Node)slidingStackPane);
        FadeTransition fadeTransition = new FadeTransition(duration, (Node)slidingStackPane);
        translateTransition.setInterpolator(Interpolator.EASE_OUT);
        fadeTransition.setInterpolator(Interpolator.EASE_OUT);
        slidingStackPane.setCache(true);
        slidingStackPane.setCacheHint(CacheHint.SPEED);
        if (bl) {
            translateTransition.setFromY(-slidingStackPane.getBoundsInLocal().getHeight());
            translateTransition.setToY(0.0);
            fadeTransition.setToValue(1.0);
            fadeTransition.setFromValue(0.0);
        } else {
            translateTransition.setToY(-slidingStackPane.getBoundsInLocal().getHeight());
            translateTransition.setFromY(0.0);
            fadeTransition.setToValue(0.0);
            fadeTransition.setFromValue(1.0);
        }
        this.setClip((Node)new Rectangle(slidingStackPane.getBoundsInLocal().getWidth(), slidingStackPane.getBoundsInLocal().getHeight()));
        ParallelTransition parallelTransition = new ParallelTransition();
        parallelTransition.getChildren().add((Object)translateTransition);
        parallelTransition.getChildren().add((Object)fadeTransition);
        parallelTransition.playFromStart();
        parallelTransition.setOnFinished(actionEvent -> {
            if (!bl) {
                button.requestFocus();
                slidingStackPane.updateVisibility(false);
            }
            slidingStackPane.setCache(false);
            calendarControl.ongoingTransitionsProperty().set(calendarControl.ongoingTransitionsProperty().get() - 1);
        });
    }
}

