/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.ui.javafx;

import java.time.format.FormatStyle;
import java.util.Locale;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import net.time4j.PlainDate;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.EpochDays;
import net.time4j.format.CalendarText;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.PatternType;
import net.time4j.range.CalendarYear;
import net.time4j.range.DateInterval;
import net.time4j.ui.javafx.CalendarControl;
import net.time4j.ui.javafx.FXCalendarSystem;
import net.time4j.ui.javafx.TableView;

class DecadeView<T extends CalendarDate>
extends TableView<T> {
    private static final String CSS_CALENDAR_DECADE_VIEW = "calendar-decade-view";
    private static final String CSS_CALENDAR_CELL_INSIDE_RANGE = "calendar-cell-inside-range";
    private static final String CSS_CALENDAR_CELL_OUT_OF_RANGE = "calendar-cell-out-of-range";

    protected DecadeView(CalendarControl<T> calendarControl, FXCalendarSystem<T> fXCalendarSystem, boolean bl) {
        super(calendarControl, fXCalendarSystem, bl);
        this.getStyleClass().add((Object)CSS_CALENDAR_DECADE_VIEW);
        if (!this.isAnimationMode()) {
            this.setEventHandler(KeyEvent.KEY_PRESSED, keyEvent -> {
                KeyCode keyCode = keyEvent.getCode();
                if (keyCode.isArrowKey()) {
                    int n;
                    int n2 = -1;
                    for (n = 0; n < 12; ++n) {
                        Node node = (Node)this.getChildren().get(n);
                        if (!node.isFocused()) continue;
                        n2 = n;
                        break;
                    }
                    if (n2 != -1) {
                        n = n2 / 4;
                        int n3 = n2 % 4;
                        switch (keyCode) {
                            case UP: {
                                n = Math.max(0, n - 1);
                                break;
                            }
                            case RIGHT: {
                                n3 = Math.min(3, n3 + 1);
                                break;
                            }
                            case DOWN: {
                                n = Math.min(2, n + 1);
                                break;
                            }
                            case LEFT: {
                                n3 = Math.max(0, n3 - 1);
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        int n4 = n * 4 + n3;
                        Node node = (Node)this.getChildren().get(n4);
                        if (!node.isDisabled()) {
                            node.requestFocus();
                        }
                    }
                    keyEvent.consume();
                }
            });
        }
    }

    @Override
    protected void buildContent() {
        for (int i = 0; i < 12; ++i) {
            Button button = new Button();
            if (i == 0 || i == 11) {
                button.getStyleClass().add((Object)CSS_CALENDAR_CELL_OUT_OF_RANGE);
            } else {
                button.getStyleClass().add((Object)CSS_CALENDAR_CELL_INSIDE_RANGE);
            }
            button.setMaxWidth(Double.MAX_VALUE);
            button.setMaxHeight(Double.MAX_VALUE);
            GridPane.setVgrow((Node)button, (Priority)Priority.ALWAYS);
            GridPane.setHgrow((Node)button, (Priority)Priority.ALWAYS);
            button.setOnAction(actionEvent -> {
                if (this.getControl().viewIndexProperty().get() == 2) {
                    CalendarDate calendarDate = (CalendarDate)this.getControl().chronology().getChronoType().cast(button.getUserData());
                    this.getControl().pageDateProperty().setValue((Object)calendarDate);
                    this.getControl().viewIndexProperty().set(1);
                }
            });
            int n = i % 4;
            int n2 = i / 4;
            this.add((Node)button, n, n2);
        }
    }

    @Override
    protected void updateContent(T t) {
        Locale locale = (Locale)this.getControl().localeProperty().get();
        if (locale == null) {
            locale = Locale.ROOT;
        }
        FXCalendarSystem fXCalendarSystem = this.getCalendarSystem();
        t = fXCalendarSystem.withFirstDayOfYear(t);
        int n = Math.floorMod(fXCalendarSystem.getProlepticYear(t), 10);
        CalendarDate calendarDate = (CalendarDate)this.getControl().minDateProperty().get();
        CalendarDate calendarDate2 = (CalendarDate)this.getControl().maxDateProperty().get();
        String string = CalendarYear.chronology().getFormatPattern(FormatStyle.FULL, locale);
        if (!(t instanceof PlainDate)) {
            string = this.getControl().chronology().getFormatPattern(FormatStyle.MEDIUM, locale).endsWith("G") ? string + " G" : "G " + string;
        }
        ChronoFormatter chronoFormatter = ChronoFormatter.ofPattern((String)string, (PatternType)PatternType.CLDR, (Locale)locale, this.getControl().chronology());
        T t2 = null;
        T t3 = null;
        for (int i = 0; i < 12; ++i) {
            Button button = (Button)this.getChildren().get(i);
            try {
                Object t4 = fXCalendarSystem.addYears(t, i - 1 - n);
                if (fXCalendarSystem.withLastDayOfYear(t4).isBefore((Object)calendarDate) || fXCalendarSystem.withFirstDayOfYear(t4).isAfter((Object)calendarDate2)) {
                    button.setDisable(true);
                    button.setText(" ");
                    button.setUserData(null);
                    continue;
                }
                if (t2 == null && i >= 1) {
                    t2 = t4;
                }
                if (i <= 10) {
                    t3 = t4;
                }
                button.setDisable(false);
                button.setText(chronoFormatter.format(t4));
                button.setUserData(t4);
                continue;
            }
            catch (ArithmeticException | IllegalArgumentException runtimeException) {
                button.setDisable(true);
                button.setText(" ");
                button.setUserData(null);
            }
        }
        if (!this.isAnimationMode()) {
            this.titleProperty().setValue(this.getNavigationTitle(t2, t3, chronoFormatter, locale));
        }
    }

    @Override
    protected int getViewIndex() {
        return 2;
    }

    private String getNavigationTitle(T t, T t2, ChronoFormatter<T> chronoFormatter, Locale locale) {
        Object t3;
        Object t4;
        try {
            t4 = this.getCalendarSystem().withFirstDayOfYear(t);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            t4 = this.getCalendarSystem().getChronologicalMinimum();
        }
        try {
            t3 = this.getCalendarSystem().withLastDayOfYear(t2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            t3 = this.getCalendarSystem().getChronologicalMaximum();
        }
        String string = CalendarText.patternForInterval((Locale)locale);
        StringBuilder stringBuilder = new StringBuilder(16);
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (c == '{' && n + 2 < n2 && string.charAt(n + 2) == '}') {
                char c2 = string.charAt(n + 1);
                if (c2 == '0') {
                    chronoFormatter.print(t4, stringBuilder);
                    n += 3;
                    continue;
                }
                if (c2 == '1') {
                    chronoFormatter.print(t3, stringBuilder);
                    n += 3;
                    continue;
                }
            }
            stringBuilder.append(c);
            ++n;
        }
        DateInterval dateInterval = DateInterval.between((PlainDate)PlainDate.of((long)t4.getDaysSinceEpochUTC(), (EpochDays)EpochDays.UTC), (PlainDate)PlainDate.of((long)t3.getDaysSinceEpochUTC(), (EpochDays)EpochDays.UTC));
        String string2 = t4 instanceof CalendarVariant ? ((CalendarVariant)CalendarVariant.class.cast(t4)).getVariant() : this.getCalendarSystem().getCalendarType();
        this.infoProperty().setValue(string2 + ": " + dateInterval.toString());
        return stringBuilder.toString();
    }
}

