/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.ui.javafx;

import java.util.Locale;
import java.util.Optional;
import net.time4j.Weekmodel;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.VariantSource;
import net.time4j.format.CalendarType;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.ui.javafx.CalendarControl;
import net.time4j.ui.javafx.DecadeView;
import net.time4j.ui.javafx.TableView;

interface FXCalendarSystem<T extends CalendarDate> {
    default public TableView<T> getBirdView(CalendarControl<T> calendarControl, boolean bl) {
        return new DecadeView<T>(calendarControl, this, bl);
    }

    default public int getDirection(int n, T t, T t2) {
        int n2 = this.getProlepticYear(t);
        int n3 = this.getProlepticYear(t2);
        if (n >= 1) {
            return n2 == n3 ? 0 : (n2 > n3 ? 1 : -1);
        }
        int n4 = this.getMonth(t);
        int n5 = this.getMonth(t2);
        if (n3 > n2 || n3 == n2 && n5 > n4) {
            return -1;
        }
        if (n3 < n2 || n3 == n2 && n5 < n4) {
            return 1;
        }
        return 0;
    }

    public T getChronologicalMinimum();

    public T getChronologicalMaximum();

    default public String getCalendarType() {
        CalendarType calendarType = this.getChronologicalMinimum().getClass().getAnnotation(CalendarType.class);
        return calendarType == null ? "iso8601" : calendarType.value();
    }

    default public Optional<VariantSource> getVariantSource() {
        return Optional.empty();
    }

    public T move(CalendarControl<T> var1, int var2);

    default public int getMaxView() {
        return 2;
    }

    public T navigateByDays(T var1, int var2);

    public Weekmodel getDefaultWeekmodel();

    public ChronoFormatter<T> createTooltipFormat(Locale var1);

    public int getMaxCountOfMonths();

    public String formatMonth(int var1, Locale var2, T var3);

    public T withMonth(T var1, int var2);

    public int getMonth(T var1);

    public int getProlepticYear(T var1);

    public T withFirstDayOfYear(T var1);

    public T withLastDayOfYear(T var1);

    public T withFirstDayOfMonth(T var1);

    public T withLastDayOfMonth(T var1);

    public T addYears(T var1, int var2);
}

