/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.ui.javafx;

import java.time.format.FormatStyle;
import java.util.Locale;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.Calendrical;
import net.time4j.engine.TimeAxis;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.ui.javafx.CalendarControl;
import net.time4j.ui.javafx.FXCalendarSystem;

abstract class FXCalendarSystemBase<U, D extends Calendrical<U, D>>
implements FXCalendarSystem<D> {
    FXCalendarSystemBase() {
    }

    @Override
    public D move(CalendarControl<D> calendarControl, int n) {
        Calendrical calendrical;
        Calendrical calendrical2 = (Calendrical)calendarControl.pageDateProperty().getValue();
        switch (calendarControl.viewIndexProperty().get()) {
            case 0: {
                calendrical = (Calendrical)calendrical2.plus((long)n, this.getMonthsUnit());
                break;
            }
            case 1: {
                calendrical = (Calendrical)calendrical2.plus((long)n, this.getYearsUnit());
                break;
            }
            case 2: {
                calendrical = (Calendrical)calendrical2.plus((long)Math.multiplyExact(n, 10), this.getYearsUnit());
                break;
            }
            default: {
                throw new IllegalStateException("Invalid view: " + calendarControl.viewIndexProperty().getValue());
            }
        }
        return (D)calendrical;
    }

    @Override
    public D navigateByDays(D d, int n) {
        return (D)d.plus(CalendarDays.of((long)n));
    }

    @Override
    public D getChronologicalMinimum() {
        return (D)((Calendrical)this.getChronology().getMinimum());
    }

    @Override
    public D getChronologicalMaximum() {
        return (D)((Calendrical)this.getChronology().getMaximum());
    }

    @Override
    public ChronoFormatter<D> createTooltipFormat(Locale locale) {
        return ChronoFormatter.ofStyle((FormatStyle)FormatStyle.LONG, (Locale)locale, this.getChronology());
    }

    @Override
    public D addYears(D d, int n) {
        return (D)((Calendrical)d.plus((long)n, this.getYearsUnit()));
    }

    protected abstract U getMonthsUnit();

    protected abstract U getYearsUnit();

    protected abstract TimeAxis<U, D> getChronology();
}

