/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.ui.javafx;

import java.util.Locale;
import net.time4j.Weekmodel;
import net.time4j.calendar.EthiopianCalendar;
import net.time4j.calendar.EthiopianEra;
import net.time4j.calendar.EthiopianMonth;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.TimeAxis;
import net.time4j.format.OutputContext;
import net.time4j.format.TextWidth;
import net.time4j.ui.javafx.FXCalendarSystemBase;

class FXCalendarSystemEthiopian
extends FXCalendarSystemBase<EthiopianCalendar.Unit, EthiopianCalendar> {
    FXCalendarSystemEthiopian() {
    }

    @Override
    public Weekmodel getDefaultWeekmodel() {
        return EthiopianCalendar.getDefaultWeekmodel();
    }

    @Override
    protected EthiopianCalendar.Unit getMonthsUnit() {
        return EthiopianCalendar.Unit.MONTHS;
    }

    @Override
    protected EthiopianCalendar.Unit getYearsUnit() {
        return EthiopianCalendar.Unit.YEARS;
    }

    @Override
    protected TimeAxis<EthiopianCalendar.Unit, EthiopianCalendar> getChronology() {
        return EthiopianCalendar.axis();
    }

    @Override
    public int getMonth(EthiopianCalendar ethiopianCalendar) {
        return ethiopianCalendar.getMonth().getValue();
    }

    @Override
    public int getProlepticYear(EthiopianCalendar ethiopianCalendar) {
        return ethiopianCalendar.getYear() + (ethiopianCalendar.getEra() == EthiopianEra.AMETE_MIHRET ? 5500 : 0);
    }

    @Override
    public int getMaxCountOfMonths() {
        return 13;
    }

    @Override
    public String formatMonth(int n, Locale locale, EthiopianCalendar ethiopianCalendar) {
        return EthiopianMonth.valueOf((int)n).getDisplayName(locale, TextWidth.SHORT, OutputContext.STANDALONE);
    }

    @Override
    public EthiopianCalendar withMonth(EthiopianCalendar ethiopianCalendar, int n) {
        return (EthiopianCalendar)ethiopianCalendar.with((ChronoElement)EthiopianCalendar.MONTH_OF_YEAR, (Object)EthiopianMonth.valueOf((int)n));
    }

    @Override
    public EthiopianCalendar withFirstDayOfMonth(EthiopianCalendar ethiopianCalendar) {
        return (EthiopianCalendar)ethiopianCalendar.with((ChronoElement)EthiopianCalendar.DAY_OF_MONTH, 1);
    }

    @Override
    public EthiopianCalendar withLastDayOfMonth(EthiopianCalendar ethiopianCalendar) {
        return (EthiopianCalendar)ethiopianCalendar.with(EthiopianCalendar.DAY_OF_MONTH.maximized());
    }

    @Override
    public EthiopianCalendar withFirstDayOfYear(EthiopianCalendar ethiopianCalendar) {
        return (EthiopianCalendar)ethiopianCalendar.with((ChronoElement)EthiopianCalendar.DAY_OF_YEAR, 1);
    }

    @Override
    public EthiopianCalendar withLastDayOfYear(EthiopianCalendar ethiopianCalendar) {
        return (EthiopianCalendar)ethiopianCalendar.with(EthiopianCalendar.DAY_OF_YEAR.maximized());
    }
}

