/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.ui.javafx;

import java.util.Locale;
import net.time4j.Weekmodel;
import net.time4j.calendar.HebrewCalendar;
import net.time4j.calendar.HebrewMonth;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.TimeAxis;
import net.time4j.format.OutputContext;
import net.time4j.format.TextWidth;
import net.time4j.ui.javafx.FXCalendarSystemBase;

class FXCalendarSystemHebrew
extends FXCalendarSystemBase<HebrewCalendar.Unit, HebrewCalendar> {
    FXCalendarSystemHebrew() {
    }

    @Override
    public Weekmodel getDefaultWeekmodel() {
        return HebrewCalendar.getDefaultWeekmodel();
    }

    @Override
    protected HebrewCalendar.Unit getMonthsUnit() {
        return HebrewCalendar.Unit.MONTHS;
    }

    @Override
    protected HebrewCalendar.Unit getYearsUnit() {
        return HebrewCalendar.Unit.YEARS;
    }

    @Override
    protected TimeAxis<HebrewCalendar.Unit, HebrewCalendar> getChronology() {
        return HebrewCalendar.axis();
    }

    @Override
    public int getMonth(HebrewCalendar hebrewCalendar) {
        return hebrewCalendar.getMonth().getCivilValue(hebrewCalendar.isLeapYear());
    }

    @Override
    public int getProlepticYear(HebrewCalendar hebrewCalendar) {
        return hebrewCalendar.getYear();
    }

    @Override
    public int getMaxCountOfMonths() {
        return 13;
    }

    @Override
    public String formatMonth(int n, Locale locale, HebrewCalendar hebrewCalendar) {
        boolean bl = hebrewCalendar.isLeapYear();
        return HebrewMonth.valueOfCivil((int)n, (boolean)bl).getDisplayName(locale, TextWidth.SHORT, OutputContext.STANDALONE, bl);
    }

    @Override
    public HebrewCalendar withMonth(HebrewCalendar hebrewCalendar, int n) {
        return (HebrewCalendar)hebrewCalendar.with((ChronoElement)HebrewCalendar.MONTH_OF_YEAR, (Object)HebrewMonth.valueOfCivil((int)n, (boolean)hebrewCalendar.isLeapYear()));
    }

    @Override
    public HebrewCalendar withFirstDayOfMonth(HebrewCalendar hebrewCalendar) {
        return (HebrewCalendar)hebrewCalendar.with((ChronoElement)HebrewCalendar.DAY_OF_MONTH, 1);
    }

    @Override
    public HebrewCalendar withLastDayOfMonth(HebrewCalendar hebrewCalendar) {
        return (HebrewCalendar)hebrewCalendar.with(HebrewCalendar.DAY_OF_MONTH.maximized());
    }

    @Override
    public HebrewCalendar withFirstDayOfYear(HebrewCalendar hebrewCalendar) {
        return (HebrewCalendar)hebrewCalendar.with((ChronoElement)HebrewCalendar.DAY_OF_YEAR, 1);
    }

    @Override
    public HebrewCalendar withLastDayOfYear(HebrewCalendar hebrewCalendar) {
        return (HebrewCalendar)hebrewCalendar.with(HebrewCalendar.DAY_OF_YEAR.maximized());
    }
}

