/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.ui.javafx;

import java.time.format.FormatStyle;
import java.util.Locale;
import java.util.Optional;
import net.time4j.Weekmodel;
import net.time4j.calendar.HijriCalendar;
import net.time4j.calendar.HijriMonth;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.Chronology;
import net.time4j.engine.VariantSource;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.ui.javafx.CalendarControl;
import net.time4j.ui.javafx.FXCalendarSystem;

class FXCalendarSystemHijri
implements FXCalendarSystem<HijriCalendar> {
    private CalendarSystem<HijriCalendar> calsys;

    FXCalendarSystemHijri(String string) {
        this.calsys = HijriCalendar.family().getCalendarSystem(string);
    }

    @Override
    public HijriCalendar getChronologicalMinimum() {
        long l = this.calsys.getMinimumSinceUTC();
        return (HijriCalendar)this.calsys.transform(l);
    }

    @Override
    public HijriCalendar getChronologicalMaximum() {
        long l = this.calsys.getMaximumSinceUTC();
        return (HijriCalendar)this.calsys.transform(l);
    }

    @Override
    public Optional<VariantSource> getVariantSource() {
        return Optional.of(() -> this.getChronologicalMinimum().getVariant());
    }

    @Override
    public HijriCalendar move(CalendarControl<HijriCalendar> calendarControl, int n) {
        HijriCalendar hijriCalendar;
        HijriCalendar hijriCalendar2 = (HijriCalendar)calendarControl.pageDateProperty().getValue();
        switch (calendarControl.viewIndexProperty().get()) {
            case 0: {
                hijriCalendar = hijriCalendar2.plus(n, HijriCalendar.Unit.MONTHS);
                break;
            }
            case 1: {
                hijriCalendar = hijriCalendar2.plus(n, HijriCalendar.Unit.YEARS);
                break;
            }
            case 2: {
                hijriCalendar = hijriCalendar2.plus(Math.multiplyExact(n, 10), HijriCalendar.Unit.YEARS);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid view: " + calendarControl.viewIndexProperty().getValue());
            }
        }
        return hijriCalendar;
    }

    @Override
    public HijriCalendar navigateByDays(HijriCalendar hijriCalendar, int n) {
        return (HijriCalendar)hijriCalendar.plus(CalendarDays.of((long)n));
    }

    @Override
    public Weekmodel getDefaultWeekmodel() {
        return HijriCalendar.getDefaultWeekmodel();
    }

    @Override
    public ChronoFormatter<HijriCalendar> createTooltipFormat(Locale locale) {
        return ChronoFormatter.ofStyle((FormatStyle)FormatStyle.LONG, (Locale)locale, (Chronology)HijriCalendar.family());
    }

    @Override
    public int getMaxCountOfMonths() {
        return 12;
    }

    @Override
    public String formatMonth(int n, Locale locale, HijriCalendar hijriCalendar) {
        return HijriMonth.valueOf((int)n).getDisplayName(locale);
    }

    @Override
    public HijriCalendar withMonth(HijriCalendar hijriCalendar, int n) {
        return (HijriCalendar)hijriCalendar.with((ChronoElement)HijriCalendar.MONTH_OF_YEAR, (Object)HijriMonth.valueOf((int)n));
    }

    @Override
    public int getMonth(HijriCalendar hijriCalendar) {
        return hijriCalendar.getMonth().getValue();
    }

    @Override
    public int getProlepticYear(HijriCalendar hijriCalendar) {
        return hijriCalendar.getYear();
    }

    @Override
    public HijriCalendar withFirstDayOfYear(HijriCalendar hijriCalendar) {
        return (HijriCalendar)hijriCalendar.with((ChronoElement)HijriCalendar.DAY_OF_YEAR, 1);
    }

    @Override
    public HijriCalendar withLastDayOfYear(HijriCalendar hijriCalendar) {
        return (HijriCalendar)hijriCalendar.with(HijriCalendar.DAY_OF_YEAR.maximized());
    }

    @Override
    public HijriCalendar withFirstDayOfMonth(HijriCalendar hijriCalendar) {
        return (HijriCalendar)hijriCalendar.with((ChronoElement)HijriCalendar.DAY_OF_MONTH, 1);
    }

    @Override
    public HijriCalendar withLastDayOfMonth(HijriCalendar hijriCalendar) {
        return (HijriCalendar)hijriCalendar.with(HijriCalendar.DAY_OF_MONTH.maximized());
    }

    @Override
    public HijriCalendar addYears(HijriCalendar hijriCalendar, int n) {
        return hijriCalendar.plus(n, HijriCalendar.Unit.YEARS);
    }
}

