/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.ui.javafx;

import java.util.Locale;
import net.time4j.CalendarUnit;
import net.time4j.IsoDateUnit;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.Weekmodel;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.TimeAxis;
import net.time4j.format.OutputContext;
import net.time4j.format.TextWidth;
import net.time4j.ui.javafx.FXCalendarSystemBase;

class FXCalendarSystemIso8601
extends FXCalendarSystemBase<IsoDateUnit, PlainDate> {
    FXCalendarSystemIso8601() {
    }

    @Override
    public Weekmodel getDefaultWeekmodel() {
        return Weekmodel.ISO;
    }

    @Override
    protected IsoDateUnit getMonthsUnit() {
        return CalendarUnit.MONTHS;
    }

    @Override
    protected IsoDateUnit getYearsUnit() {
        return CalendarUnit.YEARS;
    }

    @Override
    protected TimeAxis<IsoDateUnit, PlainDate> getChronology() {
        return PlainDate.axis();
    }

    @Override
    public int getMonth(PlainDate plainDate) {
        return plainDate.getMonth();
    }

    @Override
    public int getProlepticYear(PlainDate plainDate) {
        return plainDate.getYear();
    }

    @Override
    public int getMaxCountOfMonths() {
        return 12;
    }

    @Override
    public String formatMonth(int n, Locale locale, PlainDate plainDate) {
        return Month.valueOf((int)n).getDisplayName(locale, TextWidth.SHORT, OutputContext.STANDALONE);
    }

    @Override
    public PlainDate withMonth(PlainDate plainDate, int n) {
        return (PlainDate)plainDate.with((ChronoElement)PlainDate.MONTH_AS_NUMBER, n);
    }

    @Override
    public PlainDate withFirstDayOfMonth(PlainDate plainDate) {
        return (PlainDate)plainDate.with((ChronoElement)PlainDate.DAY_OF_MONTH, 1);
    }

    @Override
    public PlainDate withLastDayOfMonth(PlainDate plainDate) {
        return (PlainDate)plainDate.with((ChronoOperator)PlainDate.DAY_OF_MONTH.maximized());
    }

    @Override
    public PlainDate withFirstDayOfYear(PlainDate plainDate) {
        return PlainDate.of((int)plainDate.getYear(), (int)1, (int)1);
    }

    @Override
    public PlainDate withLastDayOfYear(PlainDate plainDate) {
        return (PlainDate)plainDate.with((ChronoOperator)PlainDate.DAY_OF_YEAR.maximized());
    }
}

