/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.ui.javafx;

import java.util.Locale;
import net.time4j.Month;
import net.time4j.Weekmodel;
import net.time4j.calendar.JulianCalendar;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.TimeAxis;
import net.time4j.format.OutputContext;
import net.time4j.format.TextWidth;
import net.time4j.history.HistoricEra;
import net.time4j.ui.javafx.FXCalendarSystemBase;

class FXCalendarSystemJulian
extends FXCalendarSystemBase<JulianCalendar.Unit, JulianCalendar> {
    FXCalendarSystemJulian() {
    }

    @Override
    public Weekmodel getDefaultWeekmodel() {
        return JulianCalendar.getDefaultWeekmodel();
    }

    @Override
    protected JulianCalendar.Unit getMonthsUnit() {
        return JulianCalendar.Unit.MONTHS;
    }

    @Override
    protected JulianCalendar.Unit getYearsUnit() {
        return JulianCalendar.Unit.YEARS;
    }

    @Override
    protected TimeAxis<JulianCalendar.Unit, JulianCalendar> getChronology() {
        return JulianCalendar.axis();
    }

    @Override
    public int getMonth(JulianCalendar julianCalendar) {
        return julianCalendar.getMonth().getValue();
    }

    @Override
    public int getProlepticYear(JulianCalendar julianCalendar) {
        int n = julianCalendar.getYear();
        if (julianCalendar.getEra() == HistoricEra.BC) {
            n = 1 - n;
        }
        return n;
    }

    @Override
    public int getMaxCountOfMonths() {
        return 12;
    }

    @Override
    public String formatMonth(int n, Locale locale, JulianCalendar julianCalendar) {
        return Month.valueOf((int)n).getDisplayName(locale, TextWidth.SHORT, OutputContext.STANDALONE);
    }

    @Override
    public JulianCalendar withMonth(JulianCalendar julianCalendar, int n) {
        return (JulianCalendar)julianCalendar.with((ChronoElement)JulianCalendar.MONTH_OF_YEAR, n);
    }

    @Override
    public JulianCalendar withFirstDayOfMonth(JulianCalendar julianCalendar) {
        return (JulianCalendar)julianCalendar.with(JulianCalendar.DAY_OF_MONTH, 1);
    }

    @Override
    public JulianCalendar withLastDayOfMonth(JulianCalendar julianCalendar) {
        int n = (Integer)julianCalendar.getMaximum(JulianCalendar.DAY_OF_MONTH);
        return (JulianCalendar)julianCalendar.with(JulianCalendar.DAY_OF_MONTH, n);
    }

    @Override
    public JulianCalendar withFirstDayOfYear(JulianCalendar julianCalendar) {
        return (JulianCalendar)julianCalendar.with(JulianCalendar.DAY_OF_YEAR, 1);
    }

    @Override
    public JulianCalendar withLastDayOfYear(JulianCalendar julianCalendar) {
        int n = (Integer)julianCalendar.getMaximum(JulianCalendar.DAY_OF_YEAR);
        return (JulianCalendar)julianCalendar.with(JulianCalendar.DAY_OF_YEAR, n);
    }
}

