/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.ui.javafx;

import java.util.Locale;
import net.time4j.CalendarUnit;
import net.time4j.Month;
import net.time4j.Weekmodel;
import net.time4j.calendar.MinguoCalendar;
import net.time4j.calendar.MinguoEra;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.TimeAxis;
import net.time4j.format.OutputContext;
import net.time4j.format.TextWidth;
import net.time4j.ui.javafx.FXCalendarSystemBase;

class FXCalendarSystemMinguo
extends FXCalendarSystemBase<CalendarUnit, MinguoCalendar> {
    FXCalendarSystemMinguo() {
    }

    @Override
    public Weekmodel getDefaultWeekmodel() {
        return MinguoCalendar.getDefaultWeekmodel();
    }

    @Override
    protected CalendarUnit getMonthsUnit() {
        return CalendarUnit.MONTHS;
    }

    @Override
    protected CalendarUnit getYearsUnit() {
        return CalendarUnit.YEARS;
    }

    @Override
    protected TimeAxis<CalendarUnit, MinguoCalendar> getChronology() {
        return MinguoCalendar.axis();
    }

    @Override
    public int getMonth(MinguoCalendar minguoCalendar) {
        return minguoCalendar.getMonth().getValue();
    }

    @Override
    public int getProlepticYear(MinguoCalendar minguoCalendar) {
        int n = minguoCalendar.getYear();
        if (minguoCalendar.getEra() == MinguoEra.BEFORE_ROC) {
            n = 1 - n;
        }
        return n;
    }

    @Override
    public int getMaxCountOfMonths() {
        return 12;
    }

    @Override
    public String formatMonth(int n, Locale locale, MinguoCalendar minguoCalendar) {
        return Month.valueOf((int)n).getDisplayName(locale, TextWidth.SHORT, OutputContext.STANDALONE);
    }

    @Override
    public MinguoCalendar withMonth(MinguoCalendar minguoCalendar, int n) {
        return (MinguoCalendar)minguoCalendar.with((ChronoElement)MinguoCalendar.MONTH_OF_YEAR, (Object)Month.valueOf((int)n));
    }

    @Override
    public MinguoCalendar withFirstDayOfMonth(MinguoCalendar minguoCalendar) {
        return (MinguoCalendar)minguoCalendar.with((ChronoElement)MinguoCalendar.DAY_OF_MONTH, 1);
    }

    @Override
    public MinguoCalendar withLastDayOfMonth(MinguoCalendar minguoCalendar) {
        return (MinguoCalendar)minguoCalendar.with(MinguoCalendar.DAY_OF_MONTH.maximized());
    }

    @Override
    public MinguoCalendar withFirstDayOfYear(MinguoCalendar minguoCalendar) {
        return (MinguoCalendar)minguoCalendar.with((ChronoElement)MinguoCalendar.DAY_OF_YEAR, 1);
    }

    @Override
    public MinguoCalendar withLastDayOfYear(MinguoCalendar minguoCalendar) {
        return (MinguoCalendar)minguoCalendar.with(MinguoCalendar.DAY_OF_YEAR.maximized());
    }
}

