/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.ui.javafx;

import java.util.Locale;
import net.time4j.CalendarUnit;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.Weekmodel;
import net.time4j.calendar.ThaiSolarCalendar;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.TimeAxis;
import net.time4j.format.OutputContext;
import net.time4j.format.TextWidth;
import net.time4j.ui.javafx.CalendarControl;
import net.time4j.ui.javafx.FXCalendarSystemBase;

class FXCalendarSystemThai
extends FXCalendarSystemBase<CalendarUnit, ThaiSolarCalendar> {
    FXCalendarSystemThai() {
    }

    @Override
    public ThaiSolarCalendar move(CalendarControl<ThaiSolarCalendar> calendarControl, int n) {
        ThaiSolarCalendar thaiSolarCalendar;
        ThaiSolarCalendar thaiSolarCalendar2 = (ThaiSolarCalendar)calendarControl.pageDateProperty().getValue();
        switch (calendarControl.viewIndexProperty().get()) {
            case 0: {
                thaiSolarCalendar = (ThaiSolarCalendar)thaiSolarCalendar2.plus((long)n, (Object)CalendarUnit.MONTHS);
                break;
            }
            case 1: {
                if (thaiSolarCalendar2.getMonth().getValue() <= 3) {
                    if (thaiSolarCalendar2.getYear() == 2482 && n > 0) {
                        thaiSolarCalendar2 = (ThaiSolarCalendar)thaiSolarCalendar2.with((ChronoElement)ThaiSolarCalendar.DAY_OF_YEAR, 1);
                    } else if (thaiSolarCalendar2.getYear() == 2484 && n < 0) {
                        thaiSolarCalendar2 = (ThaiSolarCalendar)thaiSolarCalendar2.with(ThaiSolarCalendar.DAY_OF_YEAR.maximized());
                    }
                }
                thaiSolarCalendar = (ThaiSolarCalendar)thaiSolarCalendar2.plus((long)n, (Object)CalendarUnit.YEARS);
                break;
            }
            case 2: {
                thaiSolarCalendar = (ThaiSolarCalendar)thaiSolarCalendar2.plus((long)Math.multiplyExact(n, 10), (Object)CalendarUnit.YEARS);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid view: " + calendarControl.viewIndexProperty().getValue());
            }
        }
        return thaiSolarCalendar;
    }

    @Override
    public Weekmodel getDefaultWeekmodel() {
        return ThaiSolarCalendar.getDefaultWeekmodel();
    }

    @Override
    public int getMonth(ThaiSolarCalendar thaiSolarCalendar) {
        return thaiSolarCalendar.getMonth().getValue();
    }

    @Override
    public int getProlepticYear(ThaiSolarCalendar thaiSolarCalendar) {
        return thaiSolarCalendar.getYear();
    }

    @Override
    protected CalendarUnit getMonthsUnit() {
        return CalendarUnit.MONTHS;
    }

    @Override
    protected CalendarUnit getYearsUnit() {
        return CalendarUnit.YEARS;
    }

    @Override
    protected TimeAxis<CalendarUnit, ThaiSolarCalendar> getChronology() {
        return ThaiSolarCalendar.axis();
    }

    @Override
    public int getMaxCountOfMonths() {
        return 12;
    }

    @Override
    public String formatMonth(int n, Locale locale, ThaiSolarCalendar thaiSolarCalendar) {
        return Month.valueOf((int)n).getDisplayName(locale, TextWidth.SHORT, OutputContext.STANDALONE);
    }

    @Override
    public ThaiSolarCalendar withMonth(ThaiSolarCalendar thaiSolarCalendar, int n) {
        if (((PlainDate)thaiSolarCalendar.transform(PlainDate.class)).getYear() <= 1940 && (n += 3) > 12) {
            n -= 12;
        }
        return (ThaiSolarCalendar)thaiSolarCalendar.with((ChronoElement)ThaiSolarCalendar.MONTH_OF_YEAR, (Object)Month.valueOf((int)n));
    }

    @Override
    public ThaiSolarCalendar withFirstDayOfMonth(ThaiSolarCalendar thaiSolarCalendar) {
        return (ThaiSolarCalendar)thaiSolarCalendar.with((ChronoElement)ThaiSolarCalendar.DAY_OF_MONTH, 1);
    }

    @Override
    public ThaiSolarCalendar withLastDayOfMonth(ThaiSolarCalendar thaiSolarCalendar) {
        return (ThaiSolarCalendar)thaiSolarCalendar.with(ThaiSolarCalendar.DAY_OF_MONTH.maximized());
    }

    @Override
    public ThaiSolarCalendar withFirstDayOfYear(ThaiSolarCalendar thaiSolarCalendar) {
        return (ThaiSolarCalendar)thaiSolarCalendar.with((ChronoElement)ThaiSolarCalendar.DAY_OF_YEAR, 1);
    }

    @Override
    public ThaiSolarCalendar withLastDayOfYear(ThaiSolarCalendar thaiSolarCalendar) {
        return (ThaiSolarCalendar)thaiSolarCalendar.with(ThaiSolarCalendar.DAY_OF_YEAR.maximized());
    }

    @Override
    public ThaiSolarCalendar addYears(ThaiSolarCalendar thaiSolarCalendar, int n) {
        int n2 = thaiSolarCalendar.getYear() + n;
        if (n2 <= 2483) {
            thaiSolarCalendar = (ThaiSolarCalendar)thaiSolarCalendar.with((ChronoElement)ThaiSolarCalendar.MONTH_OF_YEAR, (Object)Month.APRIL);
        }
        return (ThaiSolarCalendar)thaiSolarCalendar.with((ChronoElement)ThaiSolarCalendar.YEAR_OF_ERA, n2);
    }
}

