/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.ui.javafx;

import java.time.format.FormatStyle;
import java.util.Locale;
import java.util.Optional;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import net.time4j.PlainDate;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.Chronology;
import net.time4j.engine.EpochDays;
import net.time4j.format.OutputContext;
import net.time4j.format.TextWidth;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.PatternType;
import net.time4j.format.internal.FormatUtils;
import net.time4j.range.CalendarMonth;
import net.time4j.range.DateInterval;
import net.time4j.ui.javafx.CalendarControl;
import net.time4j.ui.javafx.CellCustomizer;
import net.time4j.ui.javafx.FXCalendarSystem;
import net.time4j.ui.javafx.TableView;

class MonthView<T extends CalendarDate>
extends TableView<T> {
    private static final String CSS_CALENDAR_MONTH_VIEW = "calendar-month-view";
    private static final String CSS_CALENDAR_CELL_INSIDE_RANGE = "calendar-cell-inside-range";
    private static final String CSS_CALENDAR_CELL_OUT_OF_RANGE = "calendar-cell-out-of-range";
    private static final String CSS_CALENDAR_TODAY = "calendar-cell-today";
    private static final String CSS_CALENDAR_SELECTED = "calendar-cell-selected";
    private static final String CSS_CALENDAR_WEEKDAY_HEADER = "calendar-weekday-header";
    private static final String CSS_CALENDAR_WEEK_OF_YEAR = "calendar-week-of-year";

    protected MonthView(CalendarControl<T> calendarControl, FXCalendarSystem<T> fXCalendarSystem, boolean bl) {
        super(calendarControl, fXCalendarSystem, bl);
        this.getStyleClass().add((Object)CSS_CALENDAR_MONTH_VIEW);
        calendarControl.showWeeksProperty().addListener(observable -> this.rebuild());
        if (!this.isAnimationMode()) {
            calendarControl.selectedDateProperty().addListener((observableValue, calendarDate, calendarDate2) -> {
                if (calendarDate2 == null || calendarDate2.equals(calendarControl.today())) {
                    this.updateContent((CalendarDate)calendarControl.pageDateProperty().getValue());
                }
            });
            this.setEventHandler(KeyEvent.KEY_PRESSED, keyEvent -> {
                KeyCode keyCode = keyEvent.getCode();
                if (keyCode.isArrowKey()) {
                    int n;
                    switch (keyCode) {
                        case UP: {
                            n = -7;
                            break;
                        }
                        case RIGHT: {
                            n = 1;
                            break;
                        }
                        case DOWN: {
                            n = 7;
                            break;
                        }
                        case LEFT: {
                            n = -1;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    keyEvent.consume();
                    this.setFocusedDate(n);
                }
            });
        }
    }

    @Override
    protected void buildContent() {
        int n;
        boolean bl = this.getControl().showWeeksProperty().get();
        int n2 = bl ? 1 : 0;
        for (n = 0; n < 7 + n2; ++n) {
            Label label = new Label();
            label.setMaxWidth(Double.MAX_VALUE);
            label.setAlignment(Pos.CENTER);
            if (bl && n == 0) {
                label.getStyleClass().add((Object)CSS_CALENDAR_WEEK_OF_YEAR);
                this.add((Node)label, 0, 0);
                continue;
            }
            label.getStyleClass().add((Object)CSS_CALENDAR_WEEKDAY_HEADER);
            this.add((Node)label, n, 0);
        }
        for (n = 0; n < 6; ++n) {
            if (bl) {
                Label label = new Label();
                label.setMaxWidth(Double.NEGATIVE_INFINITY);
                label.setMaxHeight(Double.MAX_VALUE);
                GridPane.setVgrow((Node)label, (Priority)Priority.ALWAYS);
                GridPane.setHgrow((Node)label, (Priority)Priority.NEVER);
                GridPane.setHalignment((Node)label, (HPos)HPos.RIGHT);
                label.getStyleClass().add((Object)CSS_CALENDAR_WEEK_OF_YEAR);
                this.add((Node)label, 0, n + 1);
            }
            for (int i = 0; i < 7; ++i) {
                Button button = new Button();
                button.setMaxWidth(Double.MAX_VALUE);
                button.setMaxHeight(Double.MAX_VALUE);
                GridPane.setVgrow((Node)button, (Priority)Priority.ALWAYS);
                GridPane.setHgrow((Node)button, (Priority)Priority.ALWAYS);
                button.setOnAction(actionEvent -> {
                    CalendarDate calendarDate = (CalendarDate)this.getControl().chronology().getChronoType().cast(button.getUserData());
                    CalendarDate calendarDate2 = (CalendarDate)this.getControl().selectedDateProperty().get();
                    if (calendarDate2 == null || !calendarDate2.equals(calendarDate)) {
                        this.getControl().selectedDateProperty().setValue((Object)calendarDate);
                    }
                });
                this.add((Node)button, i + n2, n + 1);
            }
        }
    }

    @Override
    protected void updateContent(T t) {
        Locale locale = (Locale)this.getControl().localeProperty().get();
        if (locale == null) {
            locale = Locale.ROOT;
        }
        this.updateCells(locale, t);
        this.updateColumnHeaders(locale);
        if (!this.isAnimationMode()) {
            this.updateNavigationTitle(locale, t);
        }
    }

    @Override
    protected int getViewIndex() {
        return 0;
    }

    private void setFocusedDate(int n) {
        Button button;
        int n2;
        int n3;
        int n4;
        CalendarDate calendarDate = null;
        int n5 = this.getControl().showWeeksProperty().get() ? 1 : 0;
        for (n4 = 0; n4 < 6; ++n4) {
            n3 = (n4 + 1) * (7 + n5);
            for (n2 = 0; n2 < 7; ++n2) {
                button = (Button)this.getChildren().get(n3 + n2 + n5);
                if (!button.isFocused()) continue;
                calendarDate = (CalendarDate)this.getControl().chronology().getChronoType().cast(button.getUserData());
                break;
            }
            if (calendarDate != null) break;
        }
        if (calendarDate == null) {
            return;
        }
        calendarDate = this.getCalendarSystem().navigateByDays(calendarDate, n);
        for (n4 = 0; n4 < 6; ++n4) {
            n3 = (n4 + 1) * (7 + n5);
            for (n2 = 0; n2 < 7; ++n2) {
                button = (Button)this.getChildren().get(n3 + n2 + n5);
                CalendarDate calendarDate2 = (CalendarDate)this.getControl().chronology().getChronoType().cast(button.getUserData());
                if (!calendarDate.equals(calendarDate2)) continue;
                if (!button.isDisabled()) {
                    button.requestFocus();
                }
                return;
            }
        }
    }

    private void updateCells(Locale locale, T t) {
        Weekday weekday;
        int n;
        Object object;
        boolean bl = this.getControl().showWeeksProperty().get();
        int n2 = bl ? 1 : 0;
        CalendarDate calendarDate = (CalendarDate)this.getControl().selectedDateProperty().getValue();
        Object t2 = this.getControl().today();
        Weekmodel weekmodel = this.getWeekmodel(locale);
        int n3 = 0;
        try {
            object = this.getCalendarSystem().withFirstDayOfMonth(t);
            int n4 = this.getDayOfWeek(object).getValue(weekmodel);
            object = n4 == 1 ? this.getCalendarSystem().navigateByDays(object, -7) : this.getCalendarSystem().navigateByDays(object, 1 - n4);
            n = 1;
        }
        catch (ArithmeticException | IllegalArgumentException runtimeException) {
            object = null;
            weekday = this.getDayOfWeek(this.getCalendarSystem().getChronologicalMinimum());
            n = weekday.getValue(weekmodel);
        }
        Chronology chronology = this.getControl().chronology();
        weekday = ChronoFormatter.ofPattern((String)"w", (PatternType)PatternType.CLDR, (Locale)locale, chronology);
        ChronoFormatter chronoFormatter = ChronoFormatter.ofPattern((String)"d", (PatternType)PatternType.CLDR, (Locale)locale, chronology);
        ChronoFormatter chronoFormatter2 = this.getCalendarSystem().createTooltipFormat(locale);
        CellCustomizer cellCustomizer = (CellCustomizer)this.getControl().cellCustomizerProperty().get();
        for (int i = 0; i < 6; ++i) {
            Object object2;
            int n5 = (i + 1) * (7 + n2);
            Object object3 = null;
            for (int j = 0; j < 7; ++j) {
                Object object4;
                object2 = (Button)this.getChildren().get(n5 + j + n2);
                object2.getStyleClass().remove((Object)CSS_CALENDAR_CELL_INSIDE_RANGE);
                object2.getStyleClass().remove((Object)CSS_CALENDAR_CELL_OUT_OF_RANGE);
                object2.getStyleClass().remove((Object)CSS_CALENDAR_TODAY);
                object2.getStyleClass().remove((Object)CSS_CALENDAR_SELECTED);
                if (object == null && ++n3 == n) {
                    object = this.getCalendarSystem().getChronologicalMinimum();
                }
                boolean bl2 = object == null || object.isBefore(this.getControl().minDateProperty().get()) || object.isAfter(this.getControl().maxDateProperty().get());
                object2.setDisable(bl2);
                if (bl2) {
                    object2.setOpacity(0.0);
                    object2.setText(" ");
                    object2.setTooltip(null);
                } else {
                    if (this.getCalendarSystem().getMonth(object) == this.getCalendarSystem().getMonth(t)) {
                        object2.getStyleClass().add((Object)CSS_CALENDAR_CELL_INSIDE_RANGE);
                    } else {
                        object2.getStyleClass().add((Object)CSS_CALENDAR_CELL_OUT_OF_RANGE);
                    }
                    if (object.equals(t2)) {
                        object2.getStyleClass().add((Object)CSS_CALENDAR_TODAY);
                    }
                    if (object.equals(calendarDate)) {
                        object2.getStyleClass().add((Object)CSS_CALENDAR_SELECTED);
                    }
                    object3 = object;
                    object2.setText(chronoFormatter.format(object));
                    object4 = chronoFormatter2.format(object);
                    if (!(object instanceof PlainDate)) {
                        object4 = (String)object4 + " (\u200e" + PlainDate.of((long)object.getDaysSinceEpochUTC(), (EpochDays)EpochDays.UTC) + ")";
                    }
                    object2.setTooltip(new Tooltip((String)object4));
                }
                if (cellCustomizer != null) {
                    object4 = bl2 ? Optional.empty() : Optional.of(object);
                    cellCustomizer.customize((Node)object2, j, i, weekmodel, object4);
                    if (bl2 && !object2.isDisabled()) {
                        object2.setDisable(true);
                    }
                }
                object2.setUserData(bl2 ? null : object);
                try {
                    if (object == null) continue;
                    object = this.getCalendarSystem().navigateByDays(object, 1);
                    continue;
                }
                catch (ArithmeticException arithmeticException) {
                    object = null;
                }
            }
            if (!bl) continue;
            Label label = (Label)this.getChildren().get(n5);
            if (object3 == null) {
                label.setText("  ");
                continue;
            }
            object2 = weekday.format(object3);
            if (((String)object2).length() == 1) {
                object2 = " " + (String)object2;
            }
            label.setText((String)object2);
        }
    }

    private void updateColumnHeaders(Locale locale) {
        Weekday weekday = this.getWeekmodel(locale).getFirstDayOfWeek();
        boolean bl = this.getControl().showWeeksProperty().get();
        int n = bl ? 1 : 0;
        for (int i = 0; i < 7; ++i) {
            Label label = (Label)this.getChildren().get(i + n);
            label.setText(weekday.getDisplayName(locale, TextWidth.SHORT, OutputContext.STANDALONE));
            weekday = weekday.next();
        }
    }

    private void updateNavigationTitle(Locale locale, T t) {
        String string = CalendarMonth.chronology().getFormatPattern(FormatStyle.FULL, locale);
        if (!(t instanceof PlainDate)) {
            string = this.getControl().chronology().getFormatPattern(FormatStyle.MEDIUM, locale).endsWith("G") ? string + " G" : "G " + string;
        }
        this.titleProperty().setValue(ChronoFormatter.ofPattern((String)string, (PatternType)PatternType.CLDR, (Locale)locale, this.getControl().chronology()).format(t));
        Object t2 = this.getCalendarSystem().withFirstDayOfMonth(t);
        Object t3 = this.getCalendarSystem().withLastDayOfMonth(t2);
        DateInterval dateInterval = DateInterval.between((PlainDate)PlainDate.of((long)t2.getDaysSinceEpochUTC(), (EpochDays)EpochDays.UTC), (PlainDate)PlainDate.of((long)t3.getDaysSinceEpochUTC(), (EpochDays)EpochDays.UTC));
        String string2 = t2 instanceof CalendarVariant ? ((CalendarVariant)CalendarVariant.class.cast(t2)).getVariant() : this.getCalendarSystem().getCalendarType();
        this.infoProperty().setValue(string2 + ": " + dateInterval.toString());
    }

    private Weekmodel getWeekmodel(Locale locale) {
        if (FormatUtils.useDefaultWeekmodel((Locale)locale)) {
            return this.getCalendarSystem().getDefaultWeekmodel();
        }
        return Weekmodel.of((Locale)locale);
    }

    private Weekday getDayOfWeek(T t) {
        return Weekday.valueOf((int)((int)(Math.floorMod(t.getDaysSinceEpochUTC() + 5L, 7L) + 1L)));
    }
}

