/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.ui.javafx;

import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import net.time4j.engine.CalendarDate;
import net.time4j.ui.javafx.CalendarControl;
import net.time4j.ui.javafx.FXCalendarSystem;

class NavigationBar<T extends CalendarDate>
extends HBox {
    private static final String CSS_CALENDAR_NAVIGATION_ARROW = "calendar-navigation-arrow";
    private static final String CSS_CALENDAR_NAVIGATION_TITLE = "calendar-navigation-title";
    private static final int LEFT = -1;
    private static final int RIGHT = 1;
    static final int MONTH_VIEW = 0;
    static final int YEAR_VIEW = 1;
    static final int BIRD_VIEW = 2;
    protected CalendarControl<T> control;
    private FXCalendarSystem<T> calsys;
    private Button titleButton;

    NavigationBar(CalendarControl<T> calendarControl, FXCalendarSystem<T> fXCalendarSystem) {
        this.control = calendarControl;
        this.calsys = fXCalendarSystem;
        this.titleButton = this.createTitleButton();
        this.setFocusTraversable(true);
        HBox hBox = new HBox();
        hBox.getChildren().add((Object)this.titleButton);
        hBox.setAlignment(Pos.CENTER);
        HBox.setHgrow((Node)hBox, (Priority)Priority.ALWAYS);
        Button button = this.createNavigationButton(-10);
        Button button2 = this.createNavigationButton(10);
        button.setVisible(false);
        button2.setVisible(false);
        this.getChildren().add((Object)button);
        this.getChildren().add((Object)this.createNavigationButton(-1));
        this.getChildren().add((Object)hBox);
        this.getChildren().add((Object)this.createNavigationButton(1));
        this.getChildren().add((Object)button2);
        calendarControl.viewIndexProperty().addListener((observableValue, number, number2) -> {
            boolean bl = number2.intValue() == 2;
            button.setVisible(bl);
            button2.setVisible(bl);
        });
        this.setEventHandler(KeyEvent.KEY_PRESSED, keyEvent -> {
            KeyCode keyCode = keyEvent.getCode();
            if (keyCode.isArrowKey()) {
                keyEvent.consume();
            }
        });
    }

    Button getTitleButton() {
        return this.titleButton;
    }

    private T move(int n) {
        return this.calsys.move(this.control, n);
    }

    private int getMaxView() {
        return this.calsys.getMaxView();
    }

    private Button createTitleButton() {
        Button button = new Button();
        button.getStyleClass().add((Object)CSS_CALENDAR_NAVIGATION_TITLE);
        button.textProperty().bind((ObservableValue)this.control.navigationTitleProperty());
        button.setOnAction(actionEvent -> {
            switch (this.control.viewIndexProperty().get()) {
                case 0: {
                    this.control.viewIndexProperty().set(1);
                    break;
                }
                case 1: {
                    this.control.viewIndexProperty().set(2);
                    break;
                }
            }
        });
        button.disableProperty().bind((ObservableValue)new DisabledTitleBinding());
        return button;
    }

    private Button createNavigationButton(int n) {
        Button button = new Button();
        button.setOnAction(actionEvent -> {
            T t = this.move(n);
            this.control.pageDateProperty().setValue(t);
        });
        switch (n) {
            case -10: {
                button.setText("<<");
                break;
            }
            case -1: {
                button.setText("<");
                break;
            }
            case 1: {
                button.setText(">");
                break;
            }
            case 10: {
                button.setText(">>");
                break;
            }
            default: {
                button.setText("");
            }
        }
        button.getStyleClass().add((Object)CSS_CALENDAR_NAVIGATION_ARROW);
        button.disableProperty().bind((ObservableValue)new DisabledArrowBinding(n));
        return button;
    }

    private class DisabledArrowBinding
    extends BooleanBinding {
        private final int direction;

        DisabledArrowBinding(int n) {
            this.direction = n;
            this.bind(new Observable[]{NavigationBar.this.control.minDateProperty(), NavigationBar.this.control.maxDateProperty(), NavigationBar.this.control.viewIndexProperty(), NavigationBar.this.control.pageDateProperty()});
        }

        protected boolean computeValue() {
            try {
                CalendarDate calendarDate = NavigationBar.this.move(this.direction);
                return calendarDate.isBefore(NavigationBar.this.control.minDateProperty().get()) || calendarDate.isAfter(NavigationBar.this.control.maxDateProperty().get());
            }
            catch (ArithmeticException arithmeticException) {
                return true;
            }
        }
    }

    private class DisabledTitleBinding
    extends BooleanBinding {
        DisabledTitleBinding() {
            this.bind(new Observable[]{NavigationBar.this.control.ongoingTransitionsProperty(), NavigationBar.this.control.viewIndexProperty()});
        }

        protected boolean computeValue() {
            return NavigationBar.this.control.viewIndexProperty().get() >= NavigationBar.this.getMaxView() || NavigationBar.this.control.ongoingTransitionsProperty().get() > 0;
        }
    }
}

