/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.ui.javafx;

import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.animation.TranslateTransition;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import net.time4j.engine.CalendarDate;
import net.time4j.ui.javafx.CalendarControl;
import net.time4j.ui.javafx.TableView;

class SlidingStackPane<T extends CalendarDate>
extends StackPane {
    private TableView<T> animatedPane;
    private TableView<T> currentPane;
    private ParallelTransition slideTransition;

    SlidingStackPane(TableView<T> tableView, TableView<T> tableView2) {
        this.animatedPane = tableView;
        this.currentPane = tableView2;
        tableView.setVisible(false);
        tableView.setFocusTraversable(false);
        this.getChildren().add(tableView);
        this.getChildren().add(tableView2);
        CalendarControl<T> calendarControl = tableView2.getControl();
        calendarControl.pageDateProperty().addListener((observableValue, calendarDate, calendarDate2) -> {
            int n;
            if (this.getWidth() > 0.0 && calendarControl.ongoingTransitionsProperty().get() == 0 && calendarControl.viewIndexProperty().get() == tableView2.getViewIndex() && (n = tableView2.getCalendarSystem().getDirection(tableView2.getViewIndex(), (CalendarDate)calendarDate, (CalendarDate)calendarDate2)) != 0) {
                this.slide(n, calendarDate, (Duration)calendarControl.lengthOfAnimationsProperty().get());
            }
        });
        this.layoutBoundsProperty().addListener((observableValue, bounds, bounds2) -> this.setClip((Node)new Rectangle(bounds2.getWidth(), bounds2.getHeight())));
    }

    void updateVisibility(boolean bl) {
        this.setVisible(bl);
        this.currentPane.setVisible(bl);
    }

    StringProperty getCurrentTitle() {
        return this.currentPane.titleProperty();
    }

    StringProperty getCurrentInfo() {
        return this.currentPane.infoProperty();
    }

    private void slide(int n, T t, Duration duration) {
        if (this.slideTransition != null) {
            this.slideTransition.stop();
        }
        if (duration.lessThanOrEqualTo(Duration.ZERO)) {
            return;
        }
        TranslateTransition translateTransition = new TranslateTransition(duration, this.animatedPane);
        TranslateTransition translateTransition2 = new TranslateTransition(duration, this.currentPane);
        translateTransition.setInterpolator(Interpolator.EASE_OUT);
        translateTransition2.setInterpolator(Interpolator.EASE_OUT);
        this.animatedPane.setVisible(true);
        this.animatedPane.updateContent(t);
        this.animatedPane.setCache(true);
        this.currentPane.setCache(true);
        double d = this.getLayoutBounds().getWidth();
        translateTransition.setFromX(0.0);
        translateTransition.setToX(d * (double)n);
        translateTransition2.setFromX(-1.0 * d * (double)n);
        translateTransition2.setToX(0.0);
        this.slideTransition = new ParallelTransition();
        this.slideTransition.getChildren().addAll((Object[])new Animation[]{translateTransition, translateTransition2});
        this.slideTransition.playFromStart();
        this.slideTransition.setOnFinished(actionEvent -> {
            this.animatedPane.setVisible(false);
            this.animatedPane.setCache(false);
            this.currentPane.setCache(false);
        });
    }
}

