/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.ui.javafx;

import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.layout.GridPane;
import net.time4j.engine.CalendarDate;
import net.time4j.ui.javafx.CalendarControl;
import net.time4j.ui.javafx.FXCalendarSystem;

abstract class TableView<T extends CalendarDate>
extends GridPane {
    private CalendarControl<T> control;
    private FXCalendarSystem<T> calsys;
    private StringProperty title;
    private StringProperty info;
    private final boolean animationMode;

    protected TableView(CalendarControl<T> calendarControl, FXCalendarSystem<T> fXCalendarSystem, boolean bl) {
        this.setVgap(0.0);
        this.setFocusTraversable(true);
        this.control = calendarControl;
        this.calsys = fXCalendarSystem;
        this.title = new SimpleStringProperty();
        this.info = new SimpleStringProperty();
        this.animationMode = bl;
        this.rebuild();
        if (!bl) {
            calendarControl.localeProperty().addListener(observable -> this.updateContent((CalendarDate)calendarControl.pageDateProperty().getValue()));
            calendarControl.pageDateProperty().addListener((observableValue, calendarDate, calendarDate2) -> this.updateContent(calendarDate2));
        }
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public StringProperty infoProperty() {
        return this.info;
    }

    protected abstract void buildContent();

    protected abstract void updateContent(T var1);

    protected abstract int getViewIndex();

    protected final void rebuild() {
        this.getChildren().clear();
        this.buildContent();
        this.updateContent((CalendarDate)this.control.pageDateProperty().getValue());
    }

    final CalendarControl<T> getControl() {
        return this.control;
    }

    final FXCalendarSystem<T> getCalendarSystem() {
        return this.calsys;
    }

    final boolean isAnimationMode() {
        return this.animationMode;
    }
}

