/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.ui.javafx;

import java.time.format.FormatStyle;
import java.util.Locale;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import net.time4j.PlainDate;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.EpochDays;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.PatternType;
import net.time4j.range.CalendarYear;
import net.time4j.range.DateInterval;
import net.time4j.ui.javafx.CalendarControl;
import net.time4j.ui.javafx.FXCalendarSystem;
import net.time4j.ui.javafx.TableView;

class YearView<T extends CalendarDate>
extends TableView<T> {
    private static final String CSS_CALENDAR_YEAR_VIEW = "calendar-year-view";
    private static final String CSS_CALENDAR_CELL_INSIDE_RANGE = "calendar-cell-inside-range";
    private static final int NUM_OF_COLUMNS = 3;

    protected YearView(CalendarControl<T> calendarControl, FXCalendarSystem<T> fXCalendarSystem, boolean bl) {
        super(calendarControl, fXCalendarSystem, bl);
        this.getStyleClass().add((Object)CSS_CALENDAR_YEAR_VIEW);
        if (!this.isAnimationMode()) {
            this.setEventHandler(KeyEvent.KEY_PRESSED, keyEvent -> {
                KeyCode keyCode = keyEvent.getCode();
                if (keyCode.isArrowKey()) {
                    int n;
                    int n2 = -1;
                    int n3 = this.getChildren().size();
                    for (n = 0; n < n3; ++n) {
                        Node node = (Node)this.getChildren().get(n);
                        if (!node.isFocused()) continue;
                        n2 = n;
                        break;
                    }
                    if (n2 != -1) {
                        n = n2 / 3;
                        n3 = n2 % 3;
                        switch (keyCode) {
                            case UP: {
                                n = Math.max(0, n - 1);
                                break;
                            }
                            case RIGHT: {
                                n3 = Math.min(2, n3 + 1);
                                break;
                            }
                            case DOWN: {
                                n = Math.min((this.getChildren().size() - 1) / 3, n + 1);
                                break;
                            }
                            case LEFT: {
                                n3 = Math.max(0, n3 - 1);
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        int n4 = Math.min(this.getChildren().size() - 1, n * 3 + n3);
                        Node node = (Node)this.getChildren().get(n4);
                        if (!node.isDisabled()) {
                            node.requestFocus();
                        }
                    }
                    keyEvent.consume();
                }
            });
        }
    }

    @Override
    protected void buildContent() {
        int n = this.getCalendarSystem().getMaxCountOfMonths();
        for (int i = 0; i < n; ++i) {
            Button button = new Button();
            button.getStyleClass().add((Object)CSS_CALENDAR_CELL_INSIDE_RANGE);
            button.setMaxWidth(Double.MAX_VALUE);
            button.setMaxHeight(Double.MAX_VALUE);
            GridPane.setVgrow((Node)button, (Priority)Priority.ALWAYS);
            GridPane.setHgrow((Node)button, (Priority)Priority.ALWAYS);
            button.setOnAction(actionEvent -> {
                if (this.getControl().viewIndexProperty().get() == 1) {
                    CalendarDate calendarDate = (CalendarDate)this.getControl().chronology().getChronoType().cast(button.getUserData());
                    this.getControl().pageDateProperty().setValue((Object)calendarDate);
                    this.getControl().viewIndexProperty().set(0);
                }
            });
            int n2 = i % 3;
            int n3 = i / 3;
            this.add((Node)button, n2, n3);
        }
    }

    @Override
    protected void updateContent(T t) {
        Object object;
        Locale locale = (Locale)this.getControl().localeProperty().get();
        if (locale == null) {
            locale = Locale.ROOT;
        }
        Object var3_3 = null;
        Object var4_4 = null;
        int n = this.getCalendarSystem().getMaxCountOfMonths();
        for (int i = 0; i < n; ++i) {
            object = (Button)this.getChildren().get(i);
            try {
                Object t2 = this.getCalendarSystem().withMonth(t, i + 1);
                if (var3_3 == null) {
                    var3_3 = t2;
                } else {
                    var4_4 = t2;
                }
                if (this.getCalendarSystem().withLastDayOfMonth(t2).isBefore(this.getControl().minDateProperty().get()) || this.getCalendarSystem().withFirstDayOfMonth(t2).isAfter(this.getControl().maxDateProperty().get())) {
                    object.setDisable(true);
                    object.setText(" ");
                    object.setUserData(null);
                    continue;
                }
                object.setDisable(false);
                int n2 = this.getCalendarSystem().getMonth(t2);
                object.setText(this.getCalendarSystem().formatMonth(n2, locale, t2));
                object.setUserData(t2);
                continue;
            }
            catch (ArithmeticException | IllegalArgumentException runtimeException) {
                object.setDisable(true);
                object.setText(" ");
                object.setUserData(null);
            }
        }
        if (!this.isAnimationMode()) {
            String string = CalendarYear.chronology().getFormatPattern(FormatStyle.FULL, locale);
            if (!(t instanceof PlainDate)) {
                string = this.getControl().chronology().getFormatPattern(FormatStyle.MEDIUM, locale).endsWith("G") ? string + " G" : "G " + string;
            }
            this.titleProperty().setValue(ChronoFormatter.ofPattern((String)string, (PatternType)PatternType.CLDR, (Locale)locale, this.getControl().chronology()).format(t));
            var3_3 = this.getCalendarSystem().withFirstDayOfMonth(var3_3);
            var4_4 = this.getCalendarSystem().withLastDayOfMonth(var4_4);
            DateInterval dateInterval = DateInterval.between((PlainDate)PlainDate.of((long)var3_3.getDaysSinceEpochUTC(), (EpochDays)EpochDays.UTC), (PlainDate)PlainDate.of((long)var4_4.getDaysSinceEpochUTC(), (EpochDays)EpochDays.UTC));
            object = var3_3 instanceof CalendarVariant ? ((CalendarVariant)CalendarVariant.class.cast(var3_3)).getVariant() : this.getCalendarSystem().getCalendarType();
            this.infoProperty().setValue((String)object + ": " + dateInterval.toString());
        }
    }

    @Override
    protected int getViewIndex() {
        return 1;
    }
}

