/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.adsddl.ntsd;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.tirasa.adsddl.ntsd.SID;
import net.tirasa.adsddl.ntsd.data.AceFlag;
import net.tirasa.adsddl.ntsd.data.AceObjectFlags;
import net.tirasa.adsddl.ntsd.data.AceRights;
import net.tirasa.adsddl.ntsd.data.AceType;
import net.tirasa.adsddl.ntsd.utils.GUID;
import net.tirasa.adsddl.ntsd.utils.Hex;
import net.tirasa.adsddl.ntsd.utils.NumberFacility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACE {
    protected static final Logger LOG = LoggerFactory.getLogger(ACE.class);
    private AceType type;
    private List<AceFlag> flags;
    private AceRights rights;
    private AceObjectFlags objectFlags;
    private byte[] objectType;
    private byte[] inheritedObjectType;
    private byte[] applicationData;
    private SID sid;

    ACE() {
    }

    public static ACE newInstance(AceType type) {
        ACE ace = new ACE();
        ace.setType(type);
        return ace;
    }

    int parse(IntBuffer buff, int start) {
        int pos = start;
        byte[] bytes = NumberFacility.getBytes(buff.get(pos));
        this.type = AceType.parseValue(bytes[0]);
        this.flags = AceFlag.parseValue(bytes[1]);
        int size = NumberFacility.getInt(bytes[3], bytes[2]);
        this.rights = AceRights.parseValue(NumberFacility.getReverseInt(buff.get(++pos)));
        if (this.type == AceType.ACCESS_ALLOWED_OBJECT_ACE_TYPE || this.type == AceType.ACCESS_DENIED_OBJECT_ACE_TYPE) {
            int j;
            this.objectFlags = AceObjectFlags.parseValue(NumberFacility.getReverseInt(buff.get(++pos)));
            if (this.objectFlags.getFlags().contains((Object)AceObjectFlags.Flag.ACE_OBJECT_TYPE_PRESENT)) {
                this.objectType = new byte[16];
                for (j = 0; j < 4; ++j) {
                    System.arraycopy(NumberFacility.getBytes(buff.get(++pos)), 0, this.objectType, j * 4, 4);
                }
            }
            if (this.objectFlags.getFlags().contains((Object)AceObjectFlags.Flag.ACE_INHERITED_OBJECT_TYPE_PRESENT)) {
                this.inheritedObjectType = new byte[16];
                for (j = 0; j < 4; ++j) {
                    System.arraycopy(NumberFacility.getBytes(buff.get(++pos)), 0, this.inheritedObjectType, j * 4, 4);
                }
            }
        }
        ++pos;
        this.sid = new SID();
        pos = this.sid.parse(buff, pos);
        int lastPos = start + size / 4 - 1;
        this.applicationData = new byte[4 * (lastPos - pos)];
        int index = 0;
        while (pos < lastPos) {
            System.arraycopy(NumberFacility.getBytes(buff.get(++pos)), 0, this.applicationData, index, 4);
            index += 4;
        }
        return pos;
    }

    public AceType getType() {
        return this.type;
    }

    public List<AceFlag> getFlags() {
        return this.flags == null ? new ArrayList() : this.flags;
    }

    public byte[] getApplicationData() {
        return this.applicationData == null || this.applicationData.length == 0 ? null : Arrays.copyOf(this.applicationData, this.applicationData.length);
    }

    public void setApplicationData(byte[] applicationData) {
        this.applicationData = applicationData == null || applicationData.length == 0 ? null : Arrays.copyOf(applicationData, applicationData.length);
    }

    public AceRights getRights() {
        return this.rights;
    }

    public AceObjectFlags getObjectFlags() {
        return this.objectFlags;
    }

    public byte[] getObjectType() {
        return this.objectType == null || this.objectType.length == 0 ? null : Arrays.copyOf(this.objectType, this.objectType.length);
    }

    public byte[] getInheritedObjectType() {
        return this.inheritedObjectType == null || this.inheritedObjectType.length == 0 ? null : Arrays.copyOf(this.inheritedObjectType, this.inheritedObjectType.length);
    }

    public SID getSid() {
        return this.sid;
    }

    public int getSize() {
        return 8 + (this.objectFlags == null ? 0 : 4) + (this.objectType == null ? 0 : 16) + (this.inheritedObjectType == null ? 0 : 16) + (this.sid == null ? 0 : this.sid.getSize()) + (this.applicationData == null ? 0 : this.applicationData.length);
    }

    public void setType(AceType type) {
        this.type = type;
    }

    public void addFlag(AceFlag flag) {
        this.flags.add(flag);
    }

    public void setRights(AceRights rights) {
        this.rights = rights;
    }

    public void setObjectFlags(AceObjectFlags objectFlags) {
        this.objectFlags = objectFlags;
    }

    public void setObjectType(byte[] objectType) {
        this.objectType = objectType == null || objectType.length == 0 ? null : Arrays.copyOf(objectType, objectType.length);
    }

    public void setInheritedObjectType(byte[] inheritedObjectType) {
        this.inheritedObjectType = inheritedObjectType == null || inheritedObjectType.length == 0 ? null : Arrays.copyOf(inheritedObjectType, inheritedObjectType.length);
    }

    public void setSid(SID sid) {
        this.sid = sid;
    }

    public byte[] toByteArray() {
        int size = this.getSize();
        ByteBuffer buff = ByteBuffer.allocate(size);
        buff.put(this.type.getValue());
        byte flagSRC = 0;
        for (AceFlag flag : this.getFlags()) {
            flagSRC = (byte)(flagSRC | flag.getValue());
        }
        buff.put(flagSRC);
        byte[] sizeSRC = NumberFacility.getBytes(size);
        buff.put(sizeSRC[3]);
        buff.put(sizeSRC[2]);
        buff.put(Hex.reverse(NumberFacility.getUIntBytes(this.rights.asUInt())));
        if (this.objectFlags != null) {
            buff.put(Hex.reverse(NumberFacility.getUIntBytes(this.objectFlags.asUInt())));
        }
        if (this.objectType != null) {
            buff.put(this.objectType);
        }
        if (this.inheritedObjectType != null) {
            buff.put(this.inheritedObjectType);
        }
        buff.put(this.sid.toByteArray());
        if (this.applicationData != null) {
            buff.put(this.applicationData);
        }
        return buff.array();
    }

    public boolean equals(Object ace) {
        if (!(ace instanceof ACE)) {
            return false;
        }
        ACE ext = (ACE)ACE.class.cast(ace);
        if (this.getSize() != ext.getSize()) {
            LOG.debug("Different size");
            return false;
        }
        if (this.getType() != ext.getType()) {
            LOG.debug("Different type");
            return false;
        }
        if (!Arrays.equals(this.getApplicationData(), ext.getApplicationData())) {
            LOG.debug("Different application data");
            return false;
        }
        if (!this.getSid().equals(ext.getSid())) {
            LOG.debug("Different SID");
            return false;
        }
        if (this.getObjectFlags() == null && ext.getObjectFlags() != null || this.getObjectFlags() != null && ext.getObjectFlags() == null || this.getObjectFlags() != null && ext.getObjectFlags() != null && this.getObjectFlags().asUInt() != ext.getObjectFlags().asUInt()) {
            LOG.debug("Different object flags");
            return false;
        }
        if (this.getObjectType() != null && ext.getObjectType() == null || this.getObjectType() == null && ext.getObjectType() != null || this.getObjectType() != null && ext.getObjectType() != null && !Arrays.equals(this.getObjectType(), ext.getObjectType())) {
            LOG.debug("Different object type");
            return false;
        }
        if (this.getInheritedObjectType() != null && ext.getInheritedObjectType() == null || this.getInheritedObjectType() == null && ext.getInheritedObjectType() != null || this.getInheritedObjectType() != null && ext.getInheritedObjectType() != null && !Arrays.equals(this.getInheritedObjectType(), ext.getInheritedObjectType())) {
            LOG.debug("Different inherited object type");
            return false;
        }
        if (this.getRights().asUInt() != ext.getRights().asUInt()) {
            LOG.debug("Different rights");
            return false;
        }
        return new HashSet<AceFlag>(this.getFlags()).equals(new HashSet<AceFlag>(ext.getFlags()));
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append('(');
        bld.append(this.type.toString());
        bld.append(';');
        for (AceFlag flag : this.flags) {
            bld.append((Object)flag);
        }
        bld.append(';');
        for (AceRights.ObjectRight right : this.rights.getObjectRights()) {
            bld.append(right.name());
        }
        if (this.rights.getOthers() != 0L) {
            bld.append('[');
            bld.append(this.rights.getOthers());
            bld.append(']');
        }
        bld.append(';');
        if (this.objectType != null) {
            bld.append(GUID.getGuidAsString(this.objectType));
        }
        bld.append(';');
        if (this.inheritedObjectType != null) {
            bld.append(GUID.getGuidAsString(this.inheritedObjectType));
        }
        bld.append(';');
        bld.append(this.sid.toString());
        bld.append(')');
        return bld.toString();
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + Objects.hashCode((Object)this.type);
        hash = 53 * hash + Objects.hashCode(this.flags);
        hash = 53 * hash + Objects.hashCode(this.rights);
        hash = 53 * hash + Objects.hashCode(this.objectFlags);
        hash = 53 * hash + Arrays.hashCode(this.objectType);
        hash = 53 * hash + Arrays.hashCode(this.inheritedObjectType);
        hash = 53 * hash + Arrays.hashCode(this.applicationData);
        hash = 53 * hash + Objects.hashCode(this.sid);
        return hash;
    }
}

