/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.adsddl.ntsd;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.tirasa.adsddl.ntsd.ACE;
import net.tirasa.adsddl.ntsd.data.AclRevision;
import net.tirasa.adsddl.ntsd.utils.NumberFacility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACL {
    protected static final Logger LOG = LoggerFactory.getLogger(ACL.class);
    private AclRevision revision;
    private final List<ACE> aces = new ArrayList<ACE>();

    ACL() {
    }

    int parse(IntBuffer buff, int start) {
        int pos = start;
        byte[] bytes = NumberFacility.getBytes(buff.get(pos));
        this.revision = AclRevision.parseValue(bytes[0]);
        bytes = NumberFacility.getBytes(buff.get(++pos));
        int aceCount = NumberFacility.getInt(bytes[1], bytes[0]);
        for (int i = 0; i < aceCount; ++i) {
            ++pos;
            ACE ace = new ACE();
            this.aces.add(ace);
            pos = ace.parse(buff, pos);
        }
        return pos;
    }

    public AclRevision getRevision() {
        return this.revision;
    }

    public int getSize() {
        int size = 8;
        for (ACE ace : this.aces) {
            size += ace.getSize();
        }
        return size;
    }

    public int getAceCount() {
        return this.aces.size();
    }

    public List<ACE> getAces() {
        return this.aces;
    }

    public ACE getAce(int i) {
        return this.aces.get(i);
    }

    public byte[] toByteArray() {
        int size = this.getSize();
        ByteBuffer buff = ByteBuffer.allocate(size);
        buff.put(this.revision.getValue());
        buff.put((byte)0);
        byte[] sizeSRC = NumberFacility.getBytes(size);
        buff.put(sizeSRC[3]);
        buff.put(sizeSRC[2]);
        byte[] aceCountSRC = NumberFacility.getBytes(this.getAceCount());
        buff.put(aceCountSRC[3]);
        buff.put(aceCountSRC[2]);
        buff.put((byte)0);
        buff.put((byte)0);
        for (ACE ace : this.aces) {
            buff.put(ace.toByteArray());
        }
        return buff.array();
    }

    public boolean equals(Object acl) {
        if (!(acl instanceof ACL)) {
            return false;
        }
        ACL ext = (ACL)ACL.class.cast(acl);
        if (this.getSize() != ext.getSize()) {
            LOG.debug("Different size");
            return false;
        }
        if (this.getAceCount() != ext.getAceCount()) {
            LOG.debug("Different ace count");
            return false;
        }
        for (int i = 0; i < this.aces.size(); ++i) {
            if (this.getAce(i).equals(ext.getAce(i))) continue;
            LOG.debug("Different ace: {}-{}", (Object)this.getAce(i), (Object)ext.getAce(i));
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append('P');
        for (ACE ace : this.aces) {
            bld.append(ace.toString());
        }
        return bld.toString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + Objects.hashCode(this.aces);
        return hash;
    }
}

