/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.adsddl.ntsd;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Objects;
import net.tirasa.adsddl.ntsd.ACL;
import net.tirasa.adsddl.ntsd.SID;
import net.tirasa.adsddl.ntsd.utils.Hex;
import net.tirasa.adsddl.ntsd.utils.NumberFacility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDDL {
    protected static final Logger LOG = LoggerFactory.getLogger(SDDL.class);
    private byte revision;
    private byte[] controlFlags;
    private long offsetOwner;
    private long offsetGroup;
    private long offsetSACL;
    private long offsetDACL;
    private SID owner;
    private SID group;
    private ACL dacl;
    private ACL sacl;

    public SDDL(byte[] src) {
        ByteBuffer sddlBuffer = ByteBuffer.wrap(src);
        this.parse(sddlBuffer.asIntBuffer(), 0);
    }

    private int parse(IntBuffer buff, int start) {
        int pos = start;
        byte[] header = NumberFacility.getBytes(buff.get(pos));
        this.revision = header[0];
        this.controlFlags = new byte[]{header[3], header[2]};
        boolean[] controlFlag = NumberFacility.getBits(this.controlFlags);
        this.offsetOwner = !controlFlag[15] ? NumberFacility.getReverseUInt(buff.get(++pos)) : 0L;
        this.offsetGroup = !controlFlag[14] ? NumberFacility.getReverseUInt(buff.get(++pos)) : 0L;
        this.offsetSACL = controlFlag[11] ? NumberFacility.getReverseUInt(buff.get(++pos)) : 0L;
        this.offsetDACL = controlFlag[13] ? NumberFacility.getReverseUInt(buff.get(++pos)) : 0L;
        if (this.offsetOwner > 0L) {
            pos = (int)(this.offsetOwner / 4L);
            this.owner = new SID();
            pos = this.owner.parse(buff, pos);
        }
        if (this.offsetGroup > 0L) {
            pos = (int)(this.offsetGroup / 4L);
            this.group = new SID();
            pos = this.group.parse(buff, pos);
        }
        if (this.offsetSACL > 0L) {
            pos = (int)(this.offsetSACL / 4L);
            this.sacl = new ACL();
            pos = this.sacl.parse(buff, pos);
        }
        if (this.offsetDACL > 0L) {
            pos = (int)(this.offsetDACL / 4L);
            this.dacl = new ACL();
            pos = this.dacl.parse(buff, pos);
        }
        return pos;
    }

    public int getSize() {
        return 20 + (this.sacl == null ? 0 : this.sacl.getSize()) + (this.dacl == null ? 0 : this.dacl.getSize()) + (this.owner == null ? 0 : this.owner.getSize()) + (this.group == null ? 0 : this.group.getSize());
    }

    public byte getRevision() {
        return this.revision;
    }

    public byte[] getControlFlags() {
        return this.controlFlags;
    }

    public SID getOwner() {
        return this.owner;
    }

    public SID getGroup() {
        return this.group;
    }

    public ACL getDacl() {
        return this.dacl;
    }

    public ACL getSacl() {
        return this.sacl;
    }

    public byte[] toByteArray() {
        ByteBuffer buff = ByteBuffer.allocate(this.getSize());
        buff.put(this.revision);
        buff.put((byte)0);
        buff.put(this.controlFlags[1]);
        buff.put(this.controlFlags[0]);
        buff.position(4);
        int nextAvailablePosition = 20;
        if (this.owner == null) {
            buff.putInt(0);
        } else {
            buff.put(Hex.reverse(NumberFacility.getBytes(nextAvailablePosition)));
            buff.position(nextAvailablePosition);
            buff.put(this.owner.toByteArray());
            nextAvailablePosition += this.owner.getSize();
        }
        buff.position(8);
        if (this.group == null) {
            buff.putInt(0);
        } else {
            buff.put(Hex.reverse(NumberFacility.getBytes(nextAvailablePosition)));
            buff.position(nextAvailablePosition);
            buff.put(this.group.toByteArray());
            nextAvailablePosition += this.group.getSize();
        }
        buff.position(12);
        if (this.sacl == null) {
            buff.putInt(0);
        } else {
            buff.put(Hex.reverse(NumberFacility.getBytes(nextAvailablePosition)));
            buff.position(nextAvailablePosition);
            buff.put(this.sacl.toByteArray());
            nextAvailablePosition += this.sacl.getSize();
        }
        buff.position(16);
        if (this.dacl == null) {
            buff.putInt(0);
        } else {
            buff.put(Hex.reverse(NumberFacility.getBytes(nextAvailablePosition)));
            buff.position(nextAvailablePosition);
            buff.put(this.dacl.toByteArray());
        }
        return buff.array();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SDDL)) {
            return false;
        }
        SDDL ext = (SDDL)SDDL.class.cast(o);
        if (this.getSize() != ext.getSize()) {
            LOG.debug("Different size");
            return false;
        }
        if (!Arrays.equals(this.getControlFlags(), ext.getControlFlags())) {
            LOG.debug("Different control flags");
            return false;
        }
        if (!this.getOwner().equals(ext.getOwner())) {
            LOG.debug("Different owner ....\nEspected; {}\nActual: {}", (Object)this.getOwner().toString(), (Object)ext.getOwner().toString());
            return false;
        }
        if (!this.getGroup().equals(ext.getGroup())) {
            LOG.debug("Different group ....\nEspected; {}\nActual: {}", (Object)this.getGroup().toString(), (Object)ext.getGroup().toString());
            return false;
        }
        if (!this.getDacl().equals(ext.getDacl())) {
            LOG.debug("Different dacl");
            return false;
        }
        if (!this.getSacl().equals(ext.getSacl())) {
            LOG.debug("Different sacl");
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        if (this.owner != null) {
            bld.append("O:");
            bld.append(this.owner.toString());
        }
        if (this.group != null) {
            bld.append("G:");
            bld.append(this.group.toString());
        }
        if (this.dacl != null) {
            bld.append("D:");
            bld.append(this.dacl.toString());
        }
        if (this.sacl != null) {
            bld.append("S:");
            bld.append(this.sacl.toString());
        }
        return bld.toString();
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + Arrays.hashCode(this.controlFlags);
        hash = 71 * hash + Objects.hashCode(this.owner);
        hash = 71 * hash + Objects.hashCode(this.group);
        hash = 71 * hash + Objects.hashCode(this.dacl);
        hash = 71 * hash + Objects.hashCode(this.sacl);
        return hash;
    }
}

