/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.adsddl.ntsd;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.tirasa.adsddl.ntsd.utils.Hex;
import net.tirasa.adsddl.ntsd.utils.NumberFacility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SID {
    protected static final Logger LOG = LoggerFactory.getLogger(SID.class);
    private byte revision;
    private byte[] identifierAuthority;
    private final List<byte[]> subAuthorities = new ArrayList<byte[]>();

    SID() {
    }

    public static SID newInstance(byte[] identifier) {
        SID sid = new SID();
        sid.setRevision((byte)1);
        sid.setIdentifierAuthority(identifier);
        return sid;
    }

    public static SID parse(byte[] src) {
        ByteBuffer sddlBuffer = ByteBuffer.wrap(src);
        SID sid = new SID();
        sid.parse(sddlBuffer.asIntBuffer(), 0);
        return sid;
    }

    int parse(IntBuffer buff, int start) {
        int pos = start;
        byte[] sidHeader = NumberFacility.getBytes(buff.get(pos));
        this.revision = sidHeader[0];
        int subAuthorityCount = NumberFacility.getInt(sidHeader[1]);
        this.identifierAuthority = new byte[6];
        System.arraycopy(sidHeader, 2, this.identifierAuthority, 0, 2);
        System.arraycopy(NumberFacility.getBytes(buff.get(++pos)), 0, this.identifierAuthority, 2, 4);
        for (int j = 0; j < subAuthorityCount; ++j) {
            this.subAuthorities.add(Hex.reverse(NumberFacility.getBytes(buff.get(++pos))));
        }
        return pos;
    }

    public byte getRevision() {
        return this.revision;
    }

    public int getSubAuthorityCount() {
        return this.subAuthorities == null ? 0 : (this.subAuthorities.size() > 15 ? 15 : this.subAuthorities.size());
    }

    public byte[] getIdentifierAuthority() {
        return this.identifierAuthority == null ? null : Arrays.copyOf(this.identifierAuthority, this.identifierAuthority.length);
    }

    public List<byte[]> getSubAuthorities() {
        ArrayList<byte[]> res = new ArrayList<byte[]>(this.getSubAuthorityCount());
        for (byte[] sub : this.subAuthorities) {
            if (sub == null) continue;
            res.add(Arrays.copyOf(sub, sub.length));
        }
        return Collections.unmodifiableList(res);
    }

    public int getSize() {
        return 8 + this.subAuthorities.size() * 4;
    }

    public SID setRevision(byte revision) {
        this.revision = revision;
        return this;
    }

    public SID setIdentifierAuthority(byte[] identifierAuthority) {
        if (identifierAuthority == null || identifierAuthority.length != 6) {
            throw new IllegalArgumentException("Invalid identifier authority");
        }
        this.identifierAuthority = Arrays.copyOf(identifierAuthority, identifierAuthority.length);
        return this;
    }

    public SID addSubAuthority(byte[] sub) {
        if (sub == null || sub.length != 4) {
            throw new IllegalArgumentException("Invalid sub-authority to be added");
        }
        this.subAuthorities.add(Arrays.copyOf(sub, sub.length));
        return this;
    }

    public byte[] toByteArray() {
        ByteBuffer buff = ByteBuffer.allocate(this.getSize());
        buff.put(this.revision);
        buff.put(NumberFacility.getBytes(this.subAuthorities.size())[3]);
        buff.put(this.identifierAuthority);
        for (byte[] sub : this.subAuthorities) {
            buff.put(Hex.reverse(sub));
        }
        return buff.array();
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("S-1-");
        if (this.identifierAuthority[0] == 0 && this.identifierAuthority[1] == 0) {
            bld.append(NumberFacility.getUInt(this.identifierAuthority[2], this.identifierAuthority[3], this.identifierAuthority[4], this.identifierAuthority[5]));
        } else {
            bld.append(Hex.get(this.identifierAuthority));
        }
        if (this.subAuthorities.isEmpty()) {
            bld.append("-0");
        } else {
            for (byte[] sub : this.subAuthorities) {
                bld.append("-");
                bld.append(NumberFacility.getUInt(sub));
            }
        }
        return bld.toString();
    }

    public boolean equals(Object sid) {
        if (!(sid instanceof SID)) {
            return false;
        }
        SID ext = (SID)SID.class.cast(sid);
        if (this.getSize() != ext.getSize()) {
            LOG.debug("Different size");
            return false;
        }
        if (this.getSubAuthorityCount() != ext.getSubAuthorityCount()) {
            LOG.debug("Different sub authorities");
            return false;
        }
        if (!Arrays.equals(this.getIdentifierAuthority(), ext.getIdentifierAuthority())) {
            LOG.debug("Different identifier authority: {}-{}", (Object)Hex.get(this.identifierAuthority), (Object)Hex.get(ext.getIdentifierAuthority()));
            return false;
        }
        for (int i = 0; i < this.subAuthorities.size(); ++i) {
            if (Arrays.equals(this.subAuthorities.get(i), ext.getSubAuthorities().get(i))) continue;
            LOG.debug("Different sub authority: {}-{}", (Object)Hex.get(this.subAuthorities.get(i)), (Object)Hex.get(ext.getSubAuthorities().get(i)));
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Arrays.hashCode(this.identifierAuthority);
        hash = 97 * hash + Objects.hashCode(this.subAuthorities);
        return hash;
    }
}

