/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.adsddl.ntsd.controls;

import java.nio.ByteBuffer;
import javax.naming.ldap.BasicControl;
import net.tirasa.adsddl.ntsd.utils.NumberFacility;

public class DirSyncControl
extends BasicControl {
    private static final long serialVersionUID = -930993758829518418L;
    public static final String OID = "1.2.840.113556.1.4.841";
    private static final byte[] EMPTY_COOKIE = new byte[0];
    private int flags = -2147481599;
    private final byte[] cookie;

    public DirSyncControl() {
        super(OID, true, null);
        this.cookie = EMPTY_COOKIE;
        this.value = this.berEncodedValue();
    }

    public DirSyncControl(byte[] cookie) {
        super(OID, true, cookie);
        this.cookie = cookie;
        this.value = this.berEncodedValue();
    }

    private byte[] berEncodedValue() {
        byte[] cookieSize = NumberFacility.leftTrim(NumberFacility.getBytes(this.cookie.length));
        byte[] size = NumberFacility.leftTrim(NumberFacility.getBytes(14 + cookieSize.length + this.cookie.length));
        ByteBuffer buff = ByteBuffer.allocate(2 + size.length + 14 + cookieSize.length + this.cookie.length);
        buff.put((byte)48);
        buff.put((byte)(size.length == 1 ? 129 : (size.length == 2 ? 130 : 131)));
        buff.put(size);
        buff.put((byte)2);
        buff.put((byte)4);
        buff.putInt(this.flags);
        buff.put((byte)2);
        buff.put((byte)4);
        buff.putInt(Integer.MAX_VALUE);
        buff.put((byte)4);
        buff.put((byte)(cookieSize.length == 1 ? 129 : (cookieSize.length == 2 ? 130 : 131)));
        buff.put(cookieSize);
        if (this.cookie.length > 0) {
            buff.put(this.cookie);
        }
        return buff.array();
    }

    public DirSyncControl setFlags(int flags) {
        this.flags = flags;
        this.value = this.berEncodedValue();
        return this;
    }
}

