/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.adsddl.ntsd.controls;

import java.nio.ByteBuffer;
import javax.naming.ldap.BasicControl;
import net.tirasa.adsddl.ntsd.utils.NumberFacility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDFlagsControl
extends BasicControl {
    private static final long serialVersionUID = -930993758829518419L;
    private static final Logger LOG = LoggerFactory.getLogger(SDFlagsControl.class);
    public static final String OID = "1.2.840.113556.1.4.801";
    private final int flags;

    public SDFlagsControl() {
        this(true, null);
    }

    public SDFlagsControl(int flags) {
        this(true, flags);
    }

    public SDFlagsControl(boolean criticality) {
        this(criticality, null);
    }

    public SDFlagsControl(boolean criticality, Integer flags) {
        super(OID, criticality, null);
        this.flags = flags == null ? 15 : flags;
        try {
            this.value = this.berEncodedValue();
        }
        catch (Exception e) {
            LOG.error("Error setting SD control flags", (Throwable)e);
            this.value = new byte[0];
        }
    }

    private byte[] berEncodedValue() {
        ByteBuffer buff = ByteBuffer.allocate(5);
        buff.put((byte)48);
        buff.put((byte)3);
        buff.put((byte)2);
        buff.put((byte)1);
        buff.put(NumberFacility.leftTrim(NumberFacility.getBytes(this.flags)));
        return buff.array();
    }
}

