/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.adsddl.ntsd.dacl;

import net.tirasa.adsddl.ntsd.data.AceFlag;
import net.tirasa.adsddl.ntsd.data.AceObjectFlags;
import net.tirasa.adsddl.ntsd.data.AceRights;

public class AceAssertion {
    private final AceRights aceRight;
    private final AceObjectFlags aceObjectFlags;
    private final String objectType;
    private final String inheritedObjectType;
    private final AceFlag requiredFlag;
    private final AceFlag excludedFlag;

    public AceAssertion(AceRights aceRight, AceObjectFlags aceObjFlags, String objectType, String inheritedObjectType, AceFlag requiredFlag, AceFlag excludedFlag) {
        this.aceRight = aceRight;
        this.aceObjectFlags = aceObjFlags;
        this.objectType = objectType;
        this.inheritedObjectType = inheritedObjectType;
        this.requiredFlag = requiredFlag;
        this.excludedFlag = excludedFlag;
    }

    public AceRights getAceRight() {
        return this.aceRight;
    }

    public AceObjectFlags getObjectFlags() {
        return this.aceObjectFlags;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getInheritedObjectType() {
        return this.inheritedObjectType;
    }

    public AceFlag getRequiredFlag() {
        return this.requiredFlag;
    }

    public AceFlag getExcludedFlag() {
        return this.excludedFlag;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = (int)((long)(31 * result) + (this.aceObjectFlags == null ? 0L : this.aceObjectFlags.asUInt()));
        result = (int)((long)(31 * result) + (this.aceRight == null ? 0L : this.aceRight.asUInt()));
        result = 31 * result + (this.inheritedObjectType == null ? 0 : this.inheritedObjectType.hashCode());
        result = 31 * result + (this.objectType == null ? 0 : this.objectType.hashCode());
        result = 31 * result + (this.requiredFlag == null ? 0 : this.requiredFlag.hashCode());
        result = 31 * result + (this.excludedFlag == null ? 0 : this.excludedFlag.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AceAssertion other = (AceAssertion)obj;
        if (this.aceObjectFlags == null) {
            if (other.aceObjectFlags != null) {
                return false;
            }
        } else {
            if (other.aceObjectFlags == null) {
                return false;
            }
            if (!(this.aceObjectFlags == null || other.aceObjectFlags == null || this.aceObjectFlags.getFlags().containsAll(other.aceObjectFlags.getFlags()) && this.aceObjectFlags.getOthers() == other.aceObjectFlags.getOthers())) {
                return false;
            }
        }
        if (this.aceRight == null) {
            if (other.aceRight != null) {
                return false;
            }
        } else {
            if (other.aceRight == null) {
                return false;
            }
            if (!(this.aceRight == null || other.aceRight == null || this.aceRight.getObjectRights().containsAll(other.aceRight.getObjectRights()) && this.aceRight.getOthers() == other.aceRight.getOthers())) {
                return false;
            }
        }
        if (this.inheritedObjectType == null ? other.inheritedObjectType != null : !this.inheritedObjectType.equals(other.inheritedObjectType)) {
            return false;
        }
        if (this.objectType == null ? other.objectType != null : !this.objectType.equals(other.objectType)) {
            return false;
        }
        if (this.requiredFlag == null) {
            if (other.requiredFlag != null) {
                return false;
            }
        } else {
            if (other.requiredFlag == null) {
                return false;
            }
            if (this.requiredFlag.getValue() != other.requiredFlag.getValue()) {
                return false;
            }
        }
        if (this.excludedFlag == null) {
            if (other.excludedFlag != null) {
                return false;
            }
        } else {
            if (other.excludedFlag == null) {
                return false;
            }
            if (this.excludedFlag.getValue() != other.excludedFlag.getValue()) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        String right = this.aceRight == null ? "null" : String.valueOf(this.aceRight.asUInt());
        String objFlags = this.aceObjectFlags == null ? "null" : String.valueOf(this.aceObjectFlags.asUInt());
        String reqFlag = this.requiredFlag == null ? "null" : this.requiredFlag.name();
        String exFlag = this.excludedFlag == null ? "null" : this.excludedFlag.name();
        return "AceAssertion [aceRight=" + right + this.getRightsAbbrevStringForToString() + ", aceObjectFlags=" + objFlags + ", objectType=" + this.objectType + ", inheritedObjectType=" + this.inheritedObjectType + ", requiredFlag=" + reqFlag + ", excludedFlag=" + exFlag + "]";
    }

    public String getRightsAbbrevStringForToString() {
        return "(" + this.getRightsAbbrevString() + ")";
    }

    public String getRightsAbbrevString() {
        if (this.aceRight == null) {
            return "null";
        }
        String rightsCode = "?";
        for (AceRights.ObjectRight rightVal : AceRights.ObjectRight.values()) {
            if ((this.aceRight.asUInt() & (long)rightVal.getValue()) != (long)rightVal.getValue()) continue;
            rightsCode = rightVal.name();
            break;
        }
        if (rightsCode.equals("?")) {
            switch ((int)this.aceRight.asUInt()) {
                case 1: {
                    rightsCode = "CC";
                    break;
                }
                case 2: {
                    rightsCode = "DC";
                    break;
                }
                case 4: {
                    rightsCode = "LC";
                    break;
                }
                case 8: {
                    rightsCode = "VW";
                    break;
                }
                case 16: {
                    rightsCode = "RP";
                    break;
                }
                case 32: {
                    rightsCode = "WP";
                    break;
                }
                case 64: {
                    rightsCode = "DT";
                    break;
                }
                case 128: {
                    rightsCode = "LO";
                    break;
                }
            }
        }
        return rightsCode;
    }
}

