/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.adsddl.ntsd.dacl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import net.tirasa.adsddl.ntsd.ACE;
import net.tirasa.adsddl.ntsd.ACL;
import net.tirasa.adsddl.ntsd.SDDL;
import net.tirasa.adsddl.ntsd.SID;
import net.tirasa.adsddl.ntsd.controls.SDFlagsControl;
import net.tirasa.adsddl.ntsd.dacl.AceAssertion;
import net.tirasa.adsddl.ntsd.dacl.AdRoleAssertion;
import net.tirasa.adsddl.ntsd.data.AceFlag;
import net.tirasa.adsddl.ntsd.data.AceObjectFlags;
import net.tirasa.adsddl.ntsd.data.AceType;
import net.tirasa.adsddl.ntsd.utils.GUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DACLAssertor {
    private static final Logger LOG = LoggerFactory.getLogger(DACLAssertor.class);
    private String searchFilter;
    private LdapContext ldapContext;
    private final boolean searchGroups;
    private ACL dacl;
    private List<AceAssertion> unsatisfiedAssertions = new ArrayList<AceAssertion>();

    public DACLAssertor(String searchFilter, boolean searchGroups, LdapContext ldapContext) {
        this.searchFilter = searchFilter;
        this.searchGroups = searchGroups;
        this.ldapContext = ldapContext;
    }

    public DACLAssertor(ACL dacl, boolean searchGroups) {
        this.dacl = dacl;
        this.searchGroups = searchGroups;
    }

    public boolean doAssert(AdRoleAssertion roleAssertion) throws NamingException {
        boolean result = false;
        if (roleAssertion.getPrincipal() == null) {
            LOG.warn("DACLAssertor.run, unable to run against a NULL principal specified in AdRoleAssertion");
            return result;
        }
        if (this.dacl == null) {
            this.getDACL();
        }
        this.unsatisfiedAssertions = this.findUnsatisfiedAssertions(roleAssertion);
        result = this.unsatisfiedAssertions.isEmpty();
        LOG.info("doAssert, result: {}", (Object)result);
        return result;
    }

    public List<AceAssertion> getUnsatisfiedAssertions() {
        return this.unsatisfiedAssertions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDACL() throws NamingException {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        controls.setReturningAttributes(new String[]{"name", "nTSecurityDescriptor"});
        if (this.ldapContext == null) {
            LOG.warn("getDACL, cannot search for DACL with null ldapContext");
            throw new CommunicationException("NULL ldapContext");
        }
        this.ldapContext.setRequestControls(new Control[]{new SDFlagsControl(4)});
        LOG.debug("getDACL, attempting to fetch SD for searchFilter: {}, ldapContext: {}", (Object)this.searchFilter, (Object)this.ldapContext.getNameInNamespace());
        NamingEnumeration<SearchResult> results = null;
        try {
            results = this.ldapContext.search("", this.searchFilter, controls);
            if (!results.hasMoreElements()) {
                LOG.warn("getDACL, searchFilter '{}' found nothing in context '{}'", (Object)this.searchFilter, (Object)this.ldapContext.getNameInNamespace());
                throw new NameNotFoundException("No results found for: " + this.searchFilter);
            }
            SearchResult res = results.next();
            if (results.hasMoreElements()) {
                throw new SizeLimitExceededException("The search filter '{}' matched more than one AD object");
            }
            byte[] descbytes = (byte[])res.getAttributes().get("nTSecurityDescriptor").get();
            SDDL sddl = new SDDL(descbytes);
            this.dacl = sddl.getDacl();
            LOG.debug("getDACL, fetched SD & parsed DACL for searchFilter: {}, ldapContext: {}", (Object)this.searchFilter, (Object)this.ldapContext.getNameInNamespace());
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
            }
            catch (NamingException e) {
                LOG.debug("NamingException occurred while closing results: ", (Throwable)e);
            }
        }
    }

    private List<AceAssertion> findUnsatisfiedAssertions(AdRoleAssertion roleAssertion) {
        HashMap acesBySIDMap = new HashMap();
        for (int i = 0; i < this.dacl.getAceCount(); ++i) {
            ACE ace = this.dacl.getAce(i);
            LOG.trace("ACE {}: {}", (Object)i, (Object)ace);
            if (ace.getSid() == null) continue;
            if (!acesBySIDMap.containsKey(ace.getSid().toString())) {
                acesBySIDMap.put(ace.getSid().toString(), new ArrayList());
            }
            List aces = (List)acesBySIDMap.get(ace.getSid().toString());
            aces.add(ace);
        }
        ArrayList<AceAssertion> unsatisfiedAssertions = new ArrayList<AceAssertion>(roleAssertion.getAssertions());
        SID principal = roleAssertion.getPrincipal();
        List principalAces = (List)acesBySIDMap.get(principal.toString());
        if (principalAces == null) {
            LOG.debug("findUnsatisfiedAssertions, no ACEs matching principal {} in DACL, will attempt to search member groups", (Object)principal);
        } else {
            this.findUnmatchedAssertions(principalAces, unsatisfiedAssertions);
            LOG.debug("findUnsatisfiedAssertions, {} unsatisfied assertion(s) remain after checking the DACL against principal {}, searching member groups if > 0", (Object)unsatisfiedAssertions.size(), (Object)principal);
        }
        if (!unsatisfiedAssertions.isEmpty() && this.searchGroups) {
            if (roleAssertion.isGroup()) {
                LOG.warn("findUnsatisfiedAssertions, unresolved assertions exist and requested to search member groups, but the principal is a group - returning");
                return unsatisfiedAssertions;
            }
            List<SID> tokenGroupSIDs = roleAssertion.getTokenGroups();
            if (tokenGroupSIDs == null) {
                LOG.debug("findUnsatisfiedAssertions, unresolved assertions exist and no token groups found in AdRoleAssertion - returning");
                return unsatisfiedAssertions;
            }
            int groupCount = 1;
            for (SID grpSID : tokenGroupSIDs) {
                principalAces = (List)acesBySIDMap.get(grpSID.toString());
                if (principalAces == null) continue;
                LOG.debug("findUnsatisfiedAssertions, {} ACEs of group {}", (Object)principalAces.size(), (Object)grpSID);
                this.findUnmatchedAssertions(principalAces, unsatisfiedAssertions);
                if (unsatisfiedAssertions.isEmpty()) {
                    LOG.info("findUnsatisfiedAssertions, all role assertions found in the DACL after searching {} group(s)", (Object)groupCount);
                    break;
                }
                ++groupCount;
            }
        }
        return unsatisfiedAssertions;
    }

    private void findUnmatchedAssertions(List<ACE> aces, List<AceAssertion> unsatisfiedAssertions) {
        ArrayList<AceAssertion> unmatchedAssertions = null;
        if (aces == null || aces.isEmpty()) {
            return;
        }
        for (ACE ace : aces) {
            long rightsMask = ace.getRights().asUInt();
            unmatchedAssertions = new ArrayList<AceAssertion>(unsatisfiedAssertions);
            LOG.debug("findUnmatchedAssertions, processing ACE: {}", (Object)ace);
            if (ace.getType().getValue() != AceType.ACCESS_ALLOWED_ACE_TYPE.getValue() && ace.getType().getValue() != AceType.ACCESS_ALLOWED_OBJECT_ACE_TYPE.getValue()) {
                LOG.debug("findUnmatchedAssertions, skipping ACE with non allowed object type: {}", (Object)ace.getType().getValue());
                continue;
            }
            for (AceAssertion assertion : unmatchedAssertions) {
                long assertRight = assertion.getAceRight().asUInt();
                LOG.debug("findUnmatchedAssertions, assertRightMask: {}, aceRightsMask: {}", (Object)assertRight, (Object)rightsMask);
                if ((rightsMask & assertRight) != assertRight || !this.doObjectFlagsMatch(ace.getObjectFlags(), assertion.getObjectFlags()) || !this.doObjectTypesMatch(ace.getObjectType(), assertion.getObjectType(), assertion.getObjectFlags()) || !this.doInheritedObjectTypesMatch(ace.getInheritedObjectType(), assertion.getInheritedObjectType(), assertion.getObjectFlags()) || !this.doRequiredFlagsMatch(ace.getFlags(), assertion.getRequiredFlag()) || this.isAceExcluded(ace.getFlags(), assertion.getExcludedFlag())) continue;
                LOG.debug("findUnmatchedAssertions, found an assertion match for: {}", (Object)assertion);
                unsatisfiedAssertions.remove(assertion);
            }
        }
    }

    private boolean doObjectFlagsMatch(AceObjectFlags aceObjFlags, AceObjectFlags assertionObjFlags) {
        boolean res = true;
        if (assertionObjFlags != null) {
            res = aceObjFlags != null && (aceObjFlags.asUInt() & assertionObjFlags.asUInt()) == assertionObjFlags.asUInt();
        }
        LOG.debug("doObjectFlagsMatch, result: {}", (Object)res);
        return res;
    }

    private boolean doObjectTypesMatch(byte[] aceObjectType, String assertionObjectType, AceObjectFlags assertionObjFlags) {
        boolean res = true;
        if (assertionObjFlags == null) {
            return res;
        }
        if (!((assertionObjFlags.asUInt() & (long)AceObjectFlags.Flag.ACE_OBJECT_TYPE_PRESENT.getValue()) != (long)AceObjectFlags.Flag.ACE_OBJECT_TYPE_PRESENT.getValue() || aceObjectType != null && GUID.getGuidAsString(aceObjectType).equals(assertionObjectType))) {
            res = false;
        }
        LOG.debug("doObjectTypesMatch, result: {}", (Object)res);
        return res;
    }

    private boolean doInheritedObjectTypesMatch(byte[] aceInhObjectType, String assertionInhObjectType, AceObjectFlags assertionObjFlags) {
        boolean res = true;
        if (assertionObjFlags == null) {
            return res;
        }
        if (!((assertionObjFlags.asUInt() & (long)AceObjectFlags.Flag.ACE_INHERITED_OBJECT_TYPE_PRESENT.getValue()) != (long)AceObjectFlags.Flag.ACE_INHERITED_OBJECT_TYPE_PRESENT.getValue() || aceInhObjectType != null && GUID.getGuidAsString(aceInhObjectType).equals(assertionInhObjectType))) {
            res = false;
        }
        LOG.debug("doInheritedObjectTypesMatch, result: {}", (Object)res);
        return res;
    }

    private boolean doRequiredFlagsMatch(List<AceFlag> aceFlags, AceFlag requiredFlag) {
        boolean res = true;
        if (requiredFlag != null) {
            if (aceFlags == null || aceFlags.isEmpty() || !aceFlags.contains((Object)requiredFlag)) {
                res = false;
            }
        } else if (aceFlags != null && !aceFlags.isEmpty()) {
            res = false;
        }
        LOG.debug("doRequiredFlagsMatch, result: {}", (Object)res);
        return res;
    }

    private boolean isAceExcluded(List<AceFlag> aceFlags, AceFlag excludedFlag) {
        boolean res = false;
        if (excludedFlag != null && aceFlags != null && !aceFlags.isEmpty() && aceFlags.contains((Object)excludedFlag)) {
            res = true;
        }
        LOG.debug("isAceExcluded, result: {}", (Object)res);
        return res;
    }
}

