/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.adsddl.ntsd.data;

import java.util.ArrayList;
import java.util.List;

public enum AceFlag {
    CONTAINER_INHERIT_ACE(2, "CI"),
    FAILED_ACCESS_ACE_FLAG(-128, "FA"),
    INHERIT_ONLY_ACE(8, "IO"),
    INHERITED_ACE(16, "ID"),
    NO_PROPAGATE_INHERIT_ACE(4, "NP"),
    OBJECT_INHERIT_ACE(1, "OI"),
    SUCCESSFUL_ACCESS_ACE_FLAG(64, "SA");

    private final byte value;
    private final String str;

    private AceFlag(byte value, String str) {
        this.value = value;
        this.str = str;
    }

    public byte getValue() {
        return this.value;
    }

    public String toString() {
        return this.str;
    }

    public static List<AceFlag> parseValue(byte value) {
        ArrayList<AceFlag> res = new ArrayList<AceFlag>();
        for (AceFlag type : AceFlag.values()) {
            if ((value & type.getValue()) != type.getValue()) continue;
            res.add(type);
        }
        return res;
    }
}

