/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.adsddl.ntsd.data;

import java.util.ArrayList;
import java.util.List;

public class AceObjectFlags {
    private final List<Flag> flags = new ArrayList<Flag>();
    private int others = 0;

    public AceObjectFlags(Flag ... fls) {
        for (Flag flag : fls) {
            if (this.flags.contains((Object)flag)) continue;
            this.flags.add(flag);
        }
    }

    public static AceObjectFlags parseValue(int value) {
        AceObjectFlags res = new AceObjectFlags(new Flag[0]);
        res.others = value;
        for (Flag type : Flag.values()) {
            if ((value & type.getValue()) != type.getValue()) continue;
            res.flags.add(type);
            res.others ^= type.getValue();
        }
        return res;
    }

    public List<Flag> getFlags() {
        return this.flags;
    }

    public AceObjectFlags addFlag(Flag flag) {
        if (!this.flags.contains((Object)flag)) {
            this.flags.add(flag);
        }
        return this;
    }

    public long getOthers() {
        return this.others;
    }

    public AceObjectFlags setOthers(int others) {
        this.others = others;
        return this;
    }

    public long asUInt() {
        long res = this.others;
        for (Flag flag : this.flags) {
            res += (long)flag.getValue();
        }
        return res;
    }

    public static enum Flag {
        ACE_OBJECT_TYPE_PRESENT(1),
        ACE_INHERITED_OBJECT_TYPE_PRESENT(2);

        private final int value;

        private Flag(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

