/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.adsddl.ntsd.data;

import java.util.ArrayList;
import java.util.List;

public class AceRights {
    private long others = 0L;
    private final List<ObjectRight> rights = new ArrayList<ObjectRight>();

    public static AceRights parseValue(int value) {
        AceRights res = new AceRights();
        if (value == 0) {
            return res;
        }
        res.others = value;
        for (ObjectRight type : ObjectRight.values()) {
            if ((value & type.getValue()) != type.getValue()) continue;
            res.rights.add(type);
            res.others ^= (long)type.getValue();
        }
        return res;
    }

    public long getOthers() {
        return this.others;
    }

    public AceRights setOthers(long others) {
        this.others = others;
        return this;
    }

    public List<ObjectRight> getObjectRights() {
        return this.rights;
    }

    public AceRights addOjectRight(ObjectRight right) {
        this.rights.add(right);
        return this;
    }

    public long asUInt() {
        long res = this.others;
        for (ObjectRight right : this.rights) {
            res += (long)right.getValue();
        }
        return res;
    }

    public static enum ObjectRight {
        GR(Integer.MIN_VALUE),
        GW(0x40000000),
        GX(0x20000000),
        GA(0x10000000),
        MA(0x2000000),
        AS(0x1000000),
        SY(0x100000),
        WO(524288),
        WD(262144),
        RC(131072),
        SD(65536),
        CR(256),
        WP(32);

        private final int value;

        private ObjectRight(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

