/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.adsddl.ntsd.utils;

import java.nio.ByteBuffer;
import java.security.InvalidParameterException;
import java.util.Arrays;
import net.tirasa.adsddl.ntsd.utils.Hex;

public class NumberFacility {
    public static byte[] getUIntBytes(long value) {
        return Arrays.copyOfRange(ByteBuffer.allocate(8).putLong(value).array(), 4, 8);
    }

    public static byte[] getBytes(int value) {
        return ByteBuffer.allocate(4).putInt(value).array();
    }

    public static byte[] getBytes(int value, int length) {
        return ByteBuffer.allocate(length).putInt(value).array();
    }

    public static byte[] leftTrim(byte ... bytes) {
        int pos;
        for (pos = 0; pos < bytes.length && bytes[pos] == 0; ++pos) {
        }
        if (pos < bytes.length) {
            return Arrays.copyOfRange(bytes, pos, bytes.length);
        }
        return new byte[]{0};
    }

    public static byte[] rightTrim(byte ... bytes) {
        return Hex.reverse(NumberFacility.leftTrim(Hex.reverse(bytes)));
    }

    public static boolean[] getBits(byte ... bytes) {
        if (bytes.length > 4) {
            throw new InvalidParameterException("Invalid number of bytes");
        }
        boolean[] res = new boolean[bytes.length * 8];
        int pos = 0;
        for (byte b : bytes) {
            boolean[] blArray = NumberFacility.getBits(b);
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                boolean bool;
                res[pos] = bool = blArray[i];
                ++pos;
            }
        }
        return res;
    }

    public static boolean[] getBits(byte b) {
        boolean[] res = new boolean[8];
        for (int i = 0; i < 8; ++i) {
            res[7 - i] = (b & 1 << i) != 0;
        }
        return res;
    }

    public static int getReverseInt(byte ... bytes) {
        return (int)NumberFacility.getReverseUInt(bytes);
    }

    public static long getReverseUInt(byte ... bytes) {
        return NumberFacility.getUInt(Hex.reverse(bytes));
    }

    public static int getReverseInt(int value) {
        return (int)NumberFacility.getReverseUInt(value);
    }

    public static long getReverseUInt(int value) {
        return NumberFacility.getReverseUInt(NumberFacility.getBytes(value));
    }

    public static int getInt(byte ... bytes) {
        return (int)NumberFacility.getUInt(bytes);
    }

    public static long getUInt(byte ... bytes) {
        if (bytes.length > 4) {
            throw new InvalidParameterException("Invalid number of bytes");
        }
        long res = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            res |= (long)(bytes[i] & 0xFF);
            if (i >= bytes.length - 1) continue;
            res <<= 8;
        }
        return res;
    }
}

