/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.adsddl.ntsd.utils;

import java.util.Arrays;
import java.util.List;
import net.tirasa.adsddl.ntsd.ACE;
import net.tirasa.adsddl.ntsd.SDDL;
import net.tirasa.adsddl.ntsd.SID;
import net.tirasa.adsddl.ntsd.data.AceObjectFlags;
import net.tirasa.adsddl.ntsd.data.AceRights;
import net.tirasa.adsddl.ntsd.data.AceType;
import net.tirasa.adsddl.ntsd.utils.GUID;
import net.tirasa.adsddl.ntsd.utils.NumberFacility;

public class SDDLHelper {
    public static final String UCP_OBJECT_GUID = "ab721a53-1e2f-11d0-9819-00aa0040529b";

    public static boolean isUserCannotChangePassword(SDDL sddl) {
        boolean res = false;
        List<ACE> aces = sddl.getDacl().getAces();
        for (int i = 0; !res && i < aces.size(); ++i) {
            SID sid;
            ACE ace = aces.get(i);
            if (ace.getType() != AceType.ACCESS_DENIED_OBJECT_ACE_TYPE || !ace.getObjectFlags().getFlags().contains((Object)AceObjectFlags.Flag.ACE_OBJECT_TYPE_PRESENT) || !GUID.getGuidAsString(ace.getObjectType()).equals(UCP_OBJECT_GUID) || (sid = ace.getSid()).getSubAuthorities().size() != 1 || (!Arrays.equals(sid.getIdentifierAuthority(), new byte[]{0, 0, 0, 0, 0, 1}) || !Arrays.equals(sid.getSubAuthorities().get(0), new byte[]{0, 0, 0, 0})) && (!Arrays.equals(sid.getIdentifierAuthority(), new byte[]{0, 0, 0, 0, 0, 5}) || !Arrays.equals(sid.getSubAuthorities().get(0), new byte[]{0, 0, 0, 10}))) continue;
            res = true;
        }
        return res;
    }

    public static SDDL userCannotChangePassword(SDDL sddl, Boolean cannot) {
        AceType type = cannot != false ? AceType.ACCESS_DENIED_OBJECT_ACE_TYPE : AceType.ACCESS_ALLOWED_OBJECT_ACE_TYPE;
        ACE self = null;
        ACE all = null;
        List<ACE> aces = sddl.getDacl().getAces();
        for (int i = 0; (all == null || self == null) && i < aces.size(); ++i) {
            SID sid;
            ACE ace = aces.get(i);
            if (ace.getType() != AceType.ACCESS_ALLOWED_OBJECT_ACE_TYPE && ace.getType() != AceType.ACCESS_DENIED_OBJECT_ACE_TYPE || !ace.getObjectFlags().getFlags().contains((Object)AceObjectFlags.Flag.ACE_OBJECT_TYPE_PRESENT) || !GUID.getGuidAsString(ace.getObjectType()).equals(UCP_OBJECT_GUID) || (sid = ace.getSid()).getSubAuthorities().size() != 1) continue;
            if (self == null && Arrays.equals(sid.getIdentifierAuthority(), new byte[]{0, 0, 0, 0, 0, 1}) && Arrays.equals(sid.getSubAuthorities().get(0), new byte[]{0, 0, 0, 0})) {
                self = ace;
                self.setType(type);
                continue;
            }
            if (all != null || !Arrays.equals(sid.getIdentifierAuthority(), new byte[]{0, 0, 0, 0, 0, 5}) || !Arrays.equals(sid.getSubAuthorities().get(0), new byte[]{0, 0, 0, 10})) continue;
            all = ace;
            all.setType(type);
        }
        if (self == null) {
            self = ACE.newInstance(type);
            self.setObjectFlags(new AceObjectFlags(AceObjectFlags.Flag.ACE_OBJECT_TYPE_PRESENT));
            self.setObjectType(GUID.getGuidAsByteArray(UCP_OBJECT_GUID));
            self.setRights(new AceRights().addOjectRight(AceRights.ObjectRight.CR));
            SID sid = SID.newInstance(NumberFacility.getBytes(1, 6));
            sid.addSubAuthority(NumberFacility.getBytes(0));
            self.setSid(sid);
            sddl.getDacl().getAces().add(self);
        }
        if (all == null) {
            all = ACE.newInstance(type);
            all.setObjectFlags(new AceObjectFlags(AceObjectFlags.Flag.ACE_OBJECT_TYPE_PRESENT));
            all.setObjectType(GUID.getGuidAsByteArray(UCP_OBJECT_GUID));
            all.setRights(new AceRights().addOjectRight(AceRights.ObjectRight.CR));
            SID sid = SID.newInstance(NumberFacility.getBytes(5, 6));
            sid.addSubAuthority(NumberFacility.getBytes(10));
            all.setSid(sid);
            sddl.getDacl().getAces().add(all);
        }
        return sddl;
    }
}

