/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.commons.db;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.tirasa.connid.commons.db.DatabaseQueryBuilder;
import net.tirasa.connid.commons.db.SQLParam;
import net.tirasa.connid.commons.db.SQLUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;

public class DatabaseConnection {
    private static final Log LOG = Log.getLog(DatabaseConnection.class);
    private Connection nativeConn = null;

    DatabaseConnection() {
    }

    public DatabaseConnection(Connection conn) {
        this.nativeConn = conn;
    }

    public void dispose() {
        SQLUtil.closeQuietly(this.nativeConn);
    }

    public void test() {
        try {
            this.getConnection().setAutoCommit(!this.getConnection().getAutoCommit());
            this.getConnection().setAutoCommit(!this.getConnection().getAutoCommit());
            this.commit();
            LOG.ok("connection tested", new Object[0]);
        }
        catch (Exception e) {
            SQLUtil.rollbackQuietly(this.getConnection());
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public Connection getConnection() {
        return this.nativeConn;
    }

    public void setConnection(Connection connection) {
        this.nativeConn = connection;
    }

    public PreparedStatement prepareStatement(String sql, List<SQLParam> params) throws SQLException {
        LOG.ok("prepareStatement: statement {0}", new Object[]{sql});
        ArrayList<SQLParam> out = new ArrayList<SQLParam>();
        String nomalized = SQLUtil.normalizeNullValues(sql, params, out);
        PreparedStatement prepareStatement = this.getConnection().prepareStatement(nomalized);
        SQLUtil.setParams(prepareStatement, out);
        LOG.ok("prepareStatement: normalizzed statement {0} prepared", new Object[]{nomalized});
        return prepareStatement;
    }

    public PreparedStatement prepareStatement(DatabaseQueryBuilder query) throws SQLException {
        String sql = query.getSQL();
        LOG.ok("prepareStatement {0}", new Object[]{sql});
        return this.prepareStatement(sql, query.getParams());
    }

    public CallableStatement prepareCall(String sql, List<SQLParam> params) throws SQLException {
        LOG.ok("normalize call statement {0}", new Object[]{sql});
        ArrayList<SQLParam> out = new ArrayList<SQLParam>();
        String nomalized = SQLUtil.normalizeNullValues(sql, params, out);
        CallableStatement prepareCall = this.getConnection().prepareCall(nomalized);
        SQLUtil.setParams(prepareCall, out);
        LOG.ok("call statement {0} normalizead and prepared", new Object[]{nomalized});
        return prepareCall;
    }

    public void commit() {
        try {
            this.getConnection().commit();
        }
        catch (SQLException e) {
            SQLUtil.rollbackQuietly(this.getConnection());
            LOG.error((Throwable)e, "error in commit", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }
}

