/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.commons.db;

import java.util.ArrayList;
import java.util.List;
import net.tirasa.connid.commons.db.SQLParam;
import org.identityconnectors.common.CollectionUtil;

public class FilterWhereBuilder {
    private boolean in;
    private final List<SQLParam> params = new ArrayList<SQLParam>();
    private final StringBuilder where = new StringBuilder();

    public void join(String operator, FilterWhereBuilder l, FilterWhereBuilder r) {
        this.in = true;
        if (l.isIn()) {
            this.where.append("( ");
        }
        this.where.append((CharSequence)l.getWhere());
        if (l.isIn()) {
            this.where.append(" )");
        }
        this.where.append(" ");
        this.where.append(operator);
        this.where.append(" ");
        if (r.isIn()) {
            this.where.append("( ");
        }
        this.where.append((CharSequence)r.getWhere());
        if (r.isIn()) {
            this.where.append(" )");
        }
        this.params.addAll(l.getParams());
        this.params.addAll(r.getParams());
    }

    public List<SQLParam> getParams() {
        return CollectionUtil.asReadOnlyList(this.params);
    }

    public StringBuilder getWhere() {
        return this.where;
    }

    public void addBind(SQLParam param, String operator, boolean lowercase) {
        if (param == null) {
            throw new IllegalArgumentException("null.param.not.suported");
        }
        this.where.append(lowercase ? "LOWER(" : "").append(param.getQuotedName()).append(lowercase ? ")" : "");
        this.where.append(" ").append(operator).append(lowercase ? " LOWER(" : "").append(" ?").append(lowercase ? " )" : "");
        this.params.add(param);
    }

    public void addNull(String name) {
        this.where.append(name);
        this.where.append(" IS NULL");
    }

    public boolean isIn() {
        return this.in;
    }

    public String getWhereClause() {
        return this.getWhere().toString();
    }
}

