/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.commons.db;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import net.tirasa.connid.commons.db.DatabaseConnection;
import net.tirasa.connid.commons.db.SQLParam;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.IOUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.ConnectorException;

public final class SQLUtil {
    private static final Log LOG = Log.getLog(SQLUtil.class);

    private SQLUtil() {
        throw new AssertionError();
    }

    public static Connection getDatasourceConnection(String datasourceName, Properties env) {
        try {
            LOG.ok("Datasource: {0}", new Object[]{datasourceName});
            LOG.ok("Properties", new Object[0]);
            for (String propertyName : env.stringPropertyNames()) {
                LOG.ok(propertyName + ": {0}", new Object[]{env.getProperty(propertyName)});
            }
            InitialContext ic = SQLUtil.getInitialContext(env);
            LOG.ok("Initial context: {0}", new Object[]{ic});
            DataSource ds = (DataSource)ic.lookup("java:/comp/env/" + datasourceName);
            return ds.getConnection();
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Connection getDatasourceConnection(String datasourceName, final String user, GuardedString password, Properties env) {
        try {
            LOG.ok("Datasource: {0}", new Object[]{datasourceName});
            LOG.ok("User: {0}", new Object[]{user});
            for (String propertyName : env.stringPropertyNames()) {
                LOG.ok("Properties", new Object[0]);
                LOG.ok(propertyName + ": {0}", new Object[]{env.getProperty(propertyName)});
            }
            InitialContext ic = SQLUtil.getInitialContext(env);
            LOG.ok("Initial context created", new Object[0]);
            final DataSource ds = (DataSource)ic.lookup("java:/comp/env/" + datasourceName);
            LOG.ok("Datasource context created", new Object[0]);
            final Connection[] ret = new Connection[1];
            password.access(new GuardedString.Accessor(){

                public void access(char[] clearChars) {
                    try {
                        ret[0] = ds.getConnection(user, new String(clearChars));
                    }
                    catch (UnsupportedOperationException | SQLFeatureNotSupportedException nse) {
                        try {
                            ret[0] = ds.getConnection();
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            return ret[0];
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Connection getDatasourceConnection(String datasourceName, String user, GuardedString password) {
        return SQLUtil.getDatasourceConnection(datasourceName, user, password, null);
    }

    private static InitialContext getInitialContext(Properties env) throws NamingException {
        return env == null || env.isEmpty() ? new InitialContext() : new InitialContext(env);
    }

    public static Connection getDatasourceConnection(String datasourceName) {
        return SQLUtil.getDatasourceConnection(datasourceName, null);
    }

    public static Connection getDriverMangerConnection(String driver, final String url, final String login, GuardedString password) {
        final Connection[] ret = new Connection[1];
        try {
            Class.forName(driver);
            if (StringUtil.isNotBlank((String)login)) {
                password.access(new GuardedString.Accessor(){

                    public void access(char[] clearChars) {
                        try {
                            ret[0] = DriverManager.getConnection(url, login, new String(clearChars));
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            } else {
                ret[0] = DriverManager.getConnection(url);
            }
            try {
                ret[0].setAutoCommit(false);
            }
            catch (SQLException expected) {
                LOG.error((Throwable)expected, "setAutoCommit() exception", new Object[0]);
            }
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
        return ret[0];
    }

    public static void rollbackQuietly(Connection conn) {
        try {
            if (conn != null && !conn.isClosed()) {
                conn.rollback();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void rollbackQuietly(DatabaseConnection conn) {
        if (conn != null) {
            SQLUtil.rollbackQuietly(conn.getConnection());
        }
    }

    public static void closeQuietly(Connection conn) {
        try {
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeQuietly(DatabaseConnection conn) {
        if (conn != null) {
            SQLUtil.closeQuietly(conn.getConnection());
        }
    }

    public static void closeQuietly(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeQuietly(ResultSet rset) {
        try {
            if (rset != null) {
                rset.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static String date2String(Date value) {
        return value.toString();
    }

    public static String time2String(Time value) {
        return value.toString();
    }

    public static String timestamp2String(Timestamp value) {
        return value.toString();
    }

    public static Time string2Time(String param) {
        Time parsedTime;
        DateFormat dfmt = DateFormat.getTimeInstance();
        try {
            parsedTime = Time.valueOf(param);
        }
        catch (IllegalArgumentException e) {
            try {
                parsedTime = new Time(dfmt.parse(param).getTime());
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException(pe);
            }
        }
        return new Time(parsedTime.getTime());
    }

    public static Date string2Date(String param) {
        Date parsedDate;
        DateFormat dfmt = DateFormat.getDateInstance();
        try {
            parsedDate = Date.valueOf(param);
        }
        catch (IllegalArgumentException e) {
            try {
                parsedDate = new Date(Long.valueOf(param));
            }
            catch (NumberFormatException expected) {
                try {
                    parsedDate = new Date(dfmt.parse(param).getTime());
                }
                catch (ParseException pe) {
                    throw new IllegalArgumentException(pe);
                }
            }
        }
        return parsedDate;
    }

    public static Timestamp string2Timestamp(String param) {
        Timestamp parsedTms;
        DateFormat dfmt = DateFormat.getDateTimeInstance();
        try {
            parsedTms = Timestamp.valueOf(param);
        }
        catch (IllegalArgumentException e) {
            try {
                parsedTms = new Timestamp(Long.valueOf(param));
            }
            catch (NumberFormatException expected) {
                try {
                    parsedTms = new Timestamp(dfmt.parse(param).getTime());
                }
                catch (ParseException pe) {
                    throw new IllegalArgumentException(pe);
                }
            }
        }
        return parsedTms;
    }

    public static Boolean string2Boolean(String val) {
        if (val == null) {
            return Boolean.FALSE;
        }
        return Boolean.valueOf(val);
    }

    public static String normalizeNullValues(String sql, List<SQLParam> params, List<SQLParam> out) {
        StringBuilder ret = new StringBuilder();
        int size = params == null ? 0 : params.size();
        String sqlext = sql + " ";
        String[] values = sqlext.split("\\?");
        if (values.length != size + 1) {
            throw new IllegalStateException("bind.params.count.not.same");
        }
        for (int i = 0; i < values.length; ++i) {
            String string = values[i];
            ret.append(string);
            if (params == null || i >= params.size()) continue;
            SQLParam param = params.get(i);
            if (param == null || param.getValue() == null && param.getSqlType() == 0) {
                ret.append("null");
                continue;
            }
            ret.append("?");
            out.add(param);
        }
        return ret.substring(0, ret.length() - 1);
    }

    public static byte[] blob2ByteArray(Blob blobValue) throws SQLException {
        byte[] newValue = null;
        InputStream is = blobValue.getBinaryStream();
        try {
            newValue = IOUtil.readInputStreamBytes((InputStream)is, (boolean)true);
        }
        catch (IOException e) {
            throw ConnectorException.wrap((Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return newValue;
    }

    public static void setParams(PreparedStatement statement, List<SQLParam> params) throws SQLException {
        if (statement == null || params == null) {
            return;
        }
        for (int i = 0; i < params.size(); ++i) {
            int idx = i + 1;
            SQLParam parm = params.get(i);
            int sqlType = parm.getSqlType();
            SQLParam val = new SQLParam(parm.getName(), SQLUtil.attribute2jdbcValue(parm.getValue(), sqlType), sqlType);
            SQLUtil.setParam(statement, idx, val);
        }
    }

    public static void setParams(CallableStatement statement, List<SQLParam> params) throws SQLException {
        SQLUtil.setParams((PreparedStatement)statement, params);
    }

    static void setParam(PreparedStatement stmt, int idx, SQLParam parm) throws SQLException {
        if (parm.getValue() instanceof GuardedString) {
            SQLUtil.setGuardedStringParam(stmt, idx, (GuardedString)parm.getValue());
        } else {
            SQLUtil.setSQLParam(stmt, idx, parm);
        }
    }

    public static Map<String, SQLParam> getColumnValues(ResultSet resultSet) throws SQLException {
        Assertions.nullCheck((Object)resultSet, (String)"resultSet");
        SortedMap ret = CollectionUtil.newCaseInsensitiveMap();
        ResultSetMetaData meta = resultSet.getMetaData();
        int count = meta.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            String name = meta.getColumnName(i);
            int sqlType = meta.getColumnType(i);
            SQLParam param = SQLUtil.getSQLParam(resultSet, i, name, sqlType);
            ret.put(name, param);
        }
        return ret;
    }

    public static SQLParam getSQLParam(ResultSet resultSet, int i, String name, int sqlType) throws SQLException {
        Object object;
        Assertions.nullCheck((Object)resultSet, (String)"resultSet");
        switch (sqlType) {
            case 0: {
                object = resultSet.getObject(i);
                break;
            }
            case 2: 
            case 3: {
                object = resultSet.getBigDecimal(i);
                break;
            }
            case -5: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                object = resultSet.getObject(i);
                break;
            }
            case -6: {
                object = resultSet.getByte(i);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                object = resultSet.getObject(i);
                break;
            }
            case 93: {
                object = resultSet.getTimestamp(i);
                break;
            }
            case 91: {
                object = resultSet.getDate(i);
                break;
            }
            case 92: {
                object = resultSet.getTime(i);
                break;
            }
            case -7: 
            case 16: {
                object = resultSet.getBoolean(i);
                break;
            }
            default: {
                object = resultSet.getString(i);
            }
        }
        return new SQLParam(name, object, sqlType);
    }

    public static Class<?> getSQLAttributeType(int sqlType) {
        Class ret;
        switch (sqlType) {
            case 2: 
            case 3: {
                ret = BigDecimal.class;
                break;
            }
            case 8: {
                ret = Double.class;
                break;
            }
            case 6: 
            case 7: {
                ret = Float.class;
                break;
            }
            case 4: {
                ret = Integer.class;
                break;
            }
            case -5: {
                ret = Long.class;
                break;
            }
            case -6: {
                ret = Byte.class;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                ret = byte[].class;
                break;
            }
            case -7: 
            case 16: {
                ret = Boolean.class;
                break;
            }
            default: {
                ret = String.class;
            }
        }
        return ret;
    }

    public static void setSQLParam(PreparedStatement stmt, int idx, SQLParam parm) throws SQLException {
        Assertions.nullCheck((Object)stmt, (String)"statement");
        Assertions.nullCheck((Object)parm, (String)"parm");
        int sqlType = parm.getSqlType();
        Object val = parm.getValue();
        if (val == null) {
            stmt.setNull(idx, sqlType);
            return;
        }
        if (sqlType == 0) {
            stmt.setObject(idx, val);
            return;
        }
        if (val instanceof BigDecimal) {
            stmt.setBigDecimal(idx, (BigDecimal)val);
        } else if (val instanceof Double) {
            stmt.setDouble(idx, (Double)val);
        } else if (val instanceof Float) {
            stmt.setFloat(idx, ((Float)val).floatValue());
        } else if (val instanceof Integer) {
            stmt.setInt(idx, (Integer)val);
        } else if (val instanceof Long) {
            stmt.setLong(idx, (Long)val);
        } else if (val instanceof BigInteger) {
            stmt.setLong(idx, ((BigInteger)val).longValue());
        } else if (val instanceof Byte) {
            stmt.setByte(idx, (Byte)val);
        } else if (val instanceof Integer) {
            stmt.setInt(idx, (Integer)val);
        } else if (val instanceof InputStream) {
            stmt.setBinaryStream(idx, (InputStream)val, 10000);
        } else if (val instanceof Blob) {
            stmt.setBlob(idx, (Blob)val);
        } else if (val instanceof byte[]) {
            stmt.setBytes(idx, (byte[])val);
        } else if (val instanceof Timestamp) {
            stmt.setTimestamp(idx, (Timestamp)val);
        } else if (val instanceof Date) {
            stmt.setDate(idx, (Date)val);
        } else if (val instanceof Time) {
            stmt.setTime(idx, (Time)val);
        } else if (val instanceof Boolean) {
            stmt.setBoolean(idx, (Boolean)val);
        } else if (val instanceof String) {
            stmt.setString(idx, (String)val);
        } else {
            stmt.setObject(idx, val);
        }
    }

    public static Object jdbc2AttributeValue(Object value) throws SQLException {
        Object ret = null;
        if (value == null) {
            return ret;
        }
        ret = value instanceof Blob ? SQLUtil.blob2ByteArray((Blob)value) : (value instanceof Timestamp ? (Object)SQLUtil.timestamp2String((Timestamp)value) : (value instanceof Time ? (Object)SQLUtil.time2String((Time)value) : (value instanceof Date ? (Object)SQLUtil.date2String((Date)value) : (value instanceof java.util.Date ? (Object)((java.util.Date)value).toString() : (Object)value))));
        return ret;
    }

    public static Object attribute2jdbcValue(Object value, int sqlType) throws SQLException {
        if (value == null) {
            return null;
        }
        switch (sqlType) {
            case 2: 
            case 3: 
            case 8: {
                if (value instanceof BigDecimal) {
                    return value;
                }
                if (value instanceof Double) {
                    return value;
                }
                if (value instanceof Float) {
                    return value;
                }
                if (value instanceof String) {
                    return Double.valueOf((String)value);
                }
                return Double.valueOf(value.toString());
            }
            case 6: 
            case 7: {
                if (value instanceof BigDecimal) {
                    return value;
                }
                if (value instanceof Float) {
                    return value;
                }
                if (value instanceof Double) {
                    return value;
                }
                if (value instanceof String) {
                    return Float.valueOf((String)value);
                }
                return Float.valueOf(value.toString());
            }
            case -5: 
            case 4: {
                if (value instanceof BigInteger) {
                    return value;
                }
                if (value instanceof Long) {
                    return value;
                }
                if (value instanceof Integer) {
                    return value;
                }
                if (value instanceof String) {
                    return Long.valueOf((String)value);
                }
                return Long.valueOf(value.toString());
            }
            case 93: {
                if (!(value instanceof String)) break;
                return SQLUtil.string2Timestamp((String)value);
            }
            case 91: {
                if (!(value instanceof String)) break;
                return SQLUtil.string2Date((String)value);
            }
            case 92: {
                if (!(value instanceof String)) break;
                return SQLUtil.string2Time((String)value);
            }
            case -7: 
            case 16: {
                if (!(value instanceof String)) break;
                return SQLUtil.string2Boolean((String)value);
            }
            case -1: 
            case 1: 
            case 12: {
                if (value instanceof String) {
                    return value;
                }
                return value.toString();
            }
        }
        return value;
    }

    public static void setGuardedStringParam(final PreparedStatement stmt, final int idx, GuardedString guard) throws SQLException {
        try {
            guard.access(new GuardedString.Accessor(){

                public void access(char[] clearChars) {
                    try {
                        stmt.setObject(idx, new String(clearChars));
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object selectSingleValue(Connection conn, String sql, SQLParam ... params) throws SQLException {
        ResultSet rs;
        PreparedStatement st;
        block3: {
            Object object;
            st = null;
            rs = null;
            try {
                Object value;
                st = conn.prepareStatement(sql);
                SQLUtil.setParams(st, Arrays.asList(params));
                rs = st.executeQuery();
                if (!rs.next()) break block3;
                object = value = rs.getObject(1);
            }
            catch (Throwable throwable) {
                SQLUtil.closeQuietly(rs);
                SQLUtil.closeQuietly(st);
                throw throwable;
            }
            SQLUtil.closeQuietly(rs);
            SQLUtil.closeQuietly(st);
            return object;
        }
        Object var6_7 = null;
        SQLUtil.closeQuietly(rs);
        SQLUtil.closeQuietly(st);
        return var6_7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object[]> selectRows(Connection conn, String sql, SQLParam ... params) throws SQLException {
        ArrayList<Object[]> arrayList;
        PreparedStatement st = null;
        ResultSet rs = null;
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        try {
            st = conn.prepareStatement(sql);
            SQLUtil.setParams(st, Arrays.asList(params));
            rs = st.executeQuery();
            ResultSetMetaData metaData = rs.getMetaData();
            while (rs.next()) {
                Object[] row = new Object[metaData.getColumnCount()];
                for (int i = 0; i < row.length; ++i) {
                    SQLParam param = SQLUtil.getSQLParam(rs, i + 1, metaData.getColumnName(i + 1), metaData.getColumnType(i + 1));
                    row[i] = SQLUtil.jdbc2AttributeValue(param.getValue());
                }
                rows.add(row);
            }
            arrayList = rows;
        }
        catch (Throwable throwable) {
            SQLUtil.closeQuietly(rs);
            SQLUtil.closeQuietly(st);
            throw throwable;
        }
        SQLUtil.closeQuietly(rs);
        SQLUtil.closeQuietly(st);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdateStatement(Connection conn, String sql, SQLParam ... params) throws SQLException {
        PreparedStatement st = null;
        try {
            st = conn.prepareStatement(sql);
            SQLUtil.setParams(st, Arrays.asList(params));
            int n = st.executeUpdate();
            return n;
        }
        finally {
            SQLUtil.closeQuietly(st);
        }
    }
}

