/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.commons.scripted;

import java.nio.file.Files;
import java.nio.file.Path;
import net.tirasa.connid.commons.scripted.AbstractScriptedConnector;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.spi.AbstractConfiguration;
import org.identityconnectors.framework.spi.ConfigurationProperty;

public abstract class AbstractScriptedConfiguration
extends AbstractConfiguration {
    protected static final Log LOG = Log.getLog(AbstractScriptedConfiguration.class);
    private String scriptingLanguage = "GROOVY";
    private boolean clearTextPasswordToScript = true;
    private boolean reloadScriptOnExecution = false;
    private String createScript = "";
    private String updateScript = "";
    private String deleteScript = "";
    private String searchScript = "";
    private String authenticateScript = "";
    private String resolveUsernameScript = "";
    private String syncScript = "";
    private String schemaScript = "";
    private String testScript = "";
    private String createScriptFileName = null;
    private String updateScriptFileName = null;
    private String deleteScriptFileName = null;
    private String searchScriptFileName = null;
    private String authenticateScriptFileName = null;
    private String resolveUsernameScriptFileName = null;
    private String syncScriptFileName = null;
    private String schemaScriptFileName = null;
    private String testScriptFileName = null;

    public String getScriptingLanguage() {
        return this.scriptingLanguage;
    }

    public void setScriptingLanguage(String value) {
        this.scriptingLanguage = value;
    }

    @ConfigurationProperty(displayMessageKey="clearTextPasswordToScript.display", helpMessageKey="clearTextPasswordToScript.help", order=1)
    public boolean getClearTextPasswordToScript() {
        return this.clearTextPasswordToScript;
    }

    public void setClearTextPasswordToScript(boolean value) {
        this.clearTextPasswordToScript = value;
    }

    @ConfigurationProperty(displayMessageKey="reloadScriptOnExecution.display", helpMessageKey="reloadScriptOnExecution.help", order=2)
    public boolean isReloadScriptOnExecution() {
        return this.reloadScriptOnExecution;
    }

    public void setReloadScriptOnExecution(boolean reloadScriptOnExecution) {
        this.reloadScriptOnExecution = reloadScriptOnExecution;
    }

    @ConfigurationProperty(displayMessageKey="createScript.display", helpMessageKey="createScript.help", order=3)
    public String getCreateScript() {
        return this.createScript;
    }

    public void setCreateScript(String value) {
        this.createScript = value;
    }

    @ConfigurationProperty(displayMessageKey="updateScript.display", helpMessageKey="updateScript.help", order=4)
    public String getUpdateScript() {
        return this.updateScript;
    }

    public void setUpdateScript(String value) {
        this.updateScript = value;
    }

    @ConfigurationProperty(displayMessageKey="deleteScript.display", helpMessageKey="deleteScript.help", order=5)
    public String getDeleteScript() {
        return this.deleteScript;
    }

    public void setDeleteScript(String value) {
        this.deleteScript = value;
    }

    @ConfigurationProperty(displayMessageKey="searchScript.display", helpMessageKey="searchScript.help", order=6)
    public String getSearchScript() {
        return this.searchScript;
    }

    public void setSearchScript(String value) {
        this.searchScript = value;
    }

    @ConfigurationProperty(displayMessageKey="authenticateScript.display", helpMessageKey="authenticateScript.help", order=6)
    public String getAuthenticateScript() {
        return this.authenticateScript;
    }

    public void setAuthenticateScript(String value) {
        this.authenticateScript = value;
    }

    @ConfigurationProperty(displayMessageKey="resolveUsernameScript.display", helpMessageKey="resolveUsernameScript.help", order=6)
    public String getResolveUsernameScript() {
        return this.resolveUsernameScript;
    }

    public void setResolveUsernameScript(String value) {
        this.resolveUsernameScript = value;
    }

    @ConfigurationProperty(displayMessageKey="syncScript.display", helpMessageKey="syncScript.help", order=7)
    public String getSyncScript() {
        return this.syncScript;
    }

    public void setSyncScript(String value) {
        this.syncScript = value;
    }

    @ConfigurationProperty(displayMessageKey="schemaScript.display", helpMessageKey="schemaScript.help", order=8)
    public String getSchemaScript() {
        return this.schemaScript;
    }

    public void setSchemaScript(String value) {
        this.schemaScript = value;
    }

    @ConfigurationProperty(displayMessageKey="testScript.display", helpMessageKey="testScript.help", order=9)
    public String getTestScript() {
        return this.testScript;
    }

    public void setTestScript(String value) {
        this.testScript = value;
    }

    @ConfigurationProperty(displayMessageKey="createScriptFileName.display", helpMessageKey="createScriptFileName.help", order=10)
    public String getCreateScriptFileName() {
        return this.createScriptFileName;
    }

    public void setCreateScriptFileName(String value) {
        this.createScriptFileName = value;
    }

    @ConfigurationProperty(displayMessageKey="updateScriptFileName.display", helpMessageKey="updateScriptFileName.help", order=11)
    public String getUpdateScriptFileName() {
        return this.updateScriptFileName;
    }

    public void setUpdateScriptFileName(String value) {
        this.updateScriptFileName = value;
    }

    @ConfigurationProperty(displayMessageKey="deleteScriptFileName.display", helpMessageKey="deleteScriptFileName.help", order=12)
    public String getDeleteScriptFileName() {
        return this.deleteScriptFileName;
    }

    public void setDeleteScriptFileName(String value) {
        this.deleteScriptFileName = value;
    }

    @ConfigurationProperty(displayMessageKey="searchScriptFileName.display", helpMessageKey="searchScriptFileName.help", order=13)
    public String getSearchScriptFileName() {
        return this.searchScriptFileName;
    }

    public void setSearchScriptFileName(String value) {
        this.searchScriptFileName = value;
    }

    @ConfigurationProperty(displayMessageKey="authenticateScriptFileName.display", helpMessageKey="authenticateScriptFileName.help", order=14)
    public String getAuthenticateScriptFileName() {
        return this.authenticateScriptFileName;
    }

    public void setAuthenticateScriptFileName(String value) {
        this.authenticateScriptFileName = value;
    }

    @ConfigurationProperty(displayMessageKey="resolveUsernameScriptFileName.display", helpMessageKey="resolveUsernameScriptFileName.help", order=15)
    public String getResolveUsernameScriptFileName() {
        return this.resolveUsernameScriptFileName;
    }

    public void setResolveUsernameScriptFileName(String value) {
        this.resolveUsernameScriptFileName = value;
    }

    @ConfigurationProperty(displayMessageKey="syncScriptFileName.display", helpMessageKey="syncScriptFileName.help", order=16)
    public String getSyncScriptFileName() {
        return this.syncScriptFileName;
    }

    public void setSyncScriptFileName(String value) {
        this.syncScriptFileName = value;
    }

    @ConfigurationProperty(displayMessageKey="schemaScriptFileName.display", helpMessageKey="schemaScriptFileName.help", order=17)
    public String getSchemaScriptFileName() {
        return this.schemaScriptFileName;
    }

    public void setSchemaScriptFileName(String value) {
        this.schemaScriptFileName = value;
    }

    @ConfigurationProperty(displayMessageKey="testScriptFileName.display", helpMessageKey="testScriptFileName.help", order=18)
    public String getTestScriptFileName() {
        return this.testScriptFileName;
    }

    public void setTestScriptFileName(String value) {
        this.testScriptFileName = value;
    }

    public void validate() {
        LOG.info("Checking Create Script filename", new Object[0]);
        this.checkFileIsReadable("Create", this.getCreateScriptFileName());
        LOG.info("Checking Update Script filename", new Object[0]);
        this.checkFileIsReadable("Update", this.getUpdateScriptFileName());
        LOG.info("Checking Delete Script filename", new Object[0]);
        this.checkFileIsReadable("Delete", this.getDeleteScriptFileName());
        LOG.info("Checking Search Script filename", new Object[0]);
        this.checkFileIsReadable("Search", this.getSearchScriptFileName());
        LOG.info("Checking Sync Script filename", new Object[0]);
        this.checkFileIsReadable("Sync", this.getSyncScriptFileName());
        LOG.info("Checking Test Script filename", new Object[0]);
        this.checkFileIsReadable("Test", this.getTestScriptFileName());
    }

    public String getMessage(String key, Object ... objects) {
        String fmt = this.getConnectorMessages().format(key, key, objects);
        LOG.ok("Get for a key {0} connector message {1}", new Object[]{key, fmt});
        return fmt;
    }

    private void checkFileIsReadable(String type, String fileName) {
        if (fileName == null) {
            LOG.ok("{0} Script Filename is null", new Object[]{type});
        } else {
            Path file = Path.of(AbstractScriptedConnector.resolveVariables(fileName), new String[0]);
            try {
                if (!Files.isReadable(file)) {
                    throw new IllegalArgumentException("Can't read " + fileName);
                }
                LOG.ok("{0} is readable", new Object[]{fileName});
            }
            catch (SecurityException e) {
                throw new IllegalArgumentException("Can't read " + fileName, e);
            }
        }
    }
}

