/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.commons.scripted;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.tirasa.connid.commons.scripted.AbstractScriptedConfiguration;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.IOUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.script.ScriptExecutor;
import org.identityconnectors.common.script.ScriptExecutorFactory;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.api.operations.ResolveUsernameApiOp;
import org.identityconnectors.framework.common.FrameworkUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeDelta;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SchemaBuilder;
import org.identityconnectors.framework.common.objects.ScriptContext;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.SearchResultsHandler;
import org.identityconnectors.framework.spi.operations.AuthenticateOp;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.identityconnectors.framework.spi.operations.DeleteOp;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.ScriptOnConnectorOp;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.SyncOp;
import org.identityconnectors.framework.spi.operations.TestOp;
import org.identityconnectors.framework.spi.operations.UpdateAttributeValuesOp;
import org.identityconnectors.framework.spi.operations.UpdateDeltaOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;

public abstract class AbstractScriptedConnector<C extends AbstractScriptedConfiguration>
implements Connector,
CreateOp,
UpdateOp,
UpdateDeltaOp,
UpdateAttributeValuesOp,
DeleteOp,
AuthenticateOp,
ResolveUsernameApiOp,
SchemaOp,
SyncOp,
TestOp,
SearchOp<Map<String, Object>>,
ScriptOnConnectorOp {
    protected static final Log LOG = Log.getLog(AbstractScriptedConnector.class);
    private static final Pattern VARIABLE = Pattern.compile("\\$\\{[a-zA-Z]+\\w*\\}");
    protected C config;
    private Schema schema;
    private ScriptExecutorFactory factory;
    private ScriptExecutor createExecutor;
    private ScriptExecutor updateExecutor;
    private ScriptExecutor deleteExecutor;
    private ScriptExecutor searchExecutor;
    private ScriptExecutor authenticateExecutor;
    private ScriptExecutor resolveUsernameExecutor;
    private ScriptExecutor syncExecutor;
    private ScriptExecutor schemaExecutor;
    private ScriptExecutor testExecutor;
    private ScriptExecutor runOnConnectorExecutor;

    public static final String resolveVariables(String input) {
        HashSet<String> vars = new HashSet<String>();
        Matcher matcher = VARIABLE.matcher(input);
        while (matcher.find()) {
            int n = 0;
            for (int i = matcher.start() - 1; i >= 0 && input.charAt(i) == '\\'; --i) {
                ++n;
            }
            if (n % 2 != 0) continue;
            vars.add(input.substring(matcher.start() + 2, matcher.end() - 1));
        }
        String resolved = input;
        for (String var : vars) {
            String replacement = System.getProperty(var);
            if (replacement == null) continue;
            resolved = resolved.replace("${" + var + "}", replacement);
        }
        return resolved;
    }

    public C getConfiguration() {
        return this.config;
    }

    public void dispose() {
    }

    private ScriptExecutor getScriptExecutor(String script, String scriptFileName) {
        String scriptCode = script;
        ScriptExecutor scriptExec = null;
        try {
            if (scriptFileName != null) {
                scriptCode = IOUtil.readFileUTF8((Path)Path.of(AbstractScriptedConnector.resolveVariables(scriptFileName), new String[0]));
            }
            if (scriptCode.length() > 0) {
                scriptExec = this.factory.newScriptExecutor(this.getClass().getClassLoader(), scriptCode, true);
            }
        }
        catch (IOException e) {
            throw new ConnectorException("Script error", (Throwable)e);
        }
        return scriptExec;
    }

    public void init(Configuration cfg) {
        this.config = (AbstractScriptedConfiguration)cfg;
        this.factory = ScriptExecutorFactory.newInstance((String)((AbstractScriptedConfiguration)((Object)this.config)).getScriptingLanguage());
        if (this.checkReloadScript(this.createExecutor, ((AbstractScriptedConfiguration)((Object)this.config)).getCreateScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getCreateScriptFileName())) {
            this.createExecutor = this.getScriptExecutor(((AbstractScriptedConfiguration)((Object)this.config)).getCreateScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getCreateScriptFileName());
            LOG.ok("Create script loaded", new Object[0]);
        }
        if (this.checkReloadScript(this.updateExecutor, ((AbstractScriptedConfiguration)((Object)this.config)).getUpdateScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getUpdateScriptFileName())) {
            this.updateExecutor = this.getScriptExecutor(((AbstractScriptedConfiguration)((Object)this.config)).getUpdateScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getUpdateScriptFileName());
            LOG.ok("Update script loaded", new Object[0]);
        }
        if (this.checkReloadScript(this.deleteExecutor, ((AbstractScriptedConfiguration)((Object)this.config)).getDeleteScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getDeleteScriptFileName())) {
            this.deleteExecutor = this.getScriptExecutor(((AbstractScriptedConfiguration)((Object)this.config)).getDeleteScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getDeleteScriptFileName());
            LOG.ok("Delete script loaded", new Object[0]);
        }
        if (this.checkReloadScript(this.searchExecutor, ((AbstractScriptedConfiguration)((Object)this.config)).getSearchScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getSearchScriptFileName())) {
            this.searchExecutor = this.getScriptExecutor(((AbstractScriptedConfiguration)((Object)this.config)).getSearchScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getSearchScriptFileName());
            LOG.ok("Search script loaded", new Object[0]);
        }
        if (this.checkReloadScript(this.authenticateExecutor, ((AbstractScriptedConfiguration)((Object)this.config)).getAuthenticateScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getAuthenticateScriptFileName())) {
            this.authenticateExecutor = this.getScriptExecutor(((AbstractScriptedConfiguration)((Object)this.config)).getAuthenticateScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getAuthenticateScriptFileName());
            LOG.ok("Authenticate script loaded", new Object[0]);
        }
        if (this.checkReloadScript(this.resolveUsernameExecutor, ((AbstractScriptedConfiguration)((Object)this.config)).getResolveUsernameScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getResolveUsernameScriptFileName())) {
            this.resolveUsernameExecutor = this.getScriptExecutor(((AbstractScriptedConfiguration)((Object)this.config)).getResolveUsernameScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getResolveUsernameScriptFileName());
            LOG.ok("ResolveUsername script loaded", new Object[0]);
        }
        if (this.checkReloadScript(this.syncExecutor, ((AbstractScriptedConfiguration)((Object)this.config)).getSyncScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getSyncScriptFileName())) {
            this.syncExecutor = this.getScriptExecutor(((AbstractScriptedConfiguration)((Object)this.config)).getSyncScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getSyncScriptFileName());
            LOG.ok("Sync script loaded", new Object[0]);
        }
        if (this.checkReloadScript(this.schemaExecutor, ((AbstractScriptedConfiguration)((Object)this.config)).getSchemaScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getSchemaScriptFileName())) {
            this.schemaExecutor = this.getScriptExecutor(((AbstractScriptedConfiguration)((Object)this.config)).getSchemaScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getSchemaScriptFileName());
            LOG.ok("Schema script loaded", new Object[0]);
        }
        if (this.checkReloadScript(this.testExecutor, ((AbstractScriptedConfiguration)((Object)this.config)).getTestScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getTestScriptFileName())) {
            this.testExecutor = this.getScriptExecutor(((AbstractScriptedConfiguration)((Object)this.config)).getTestScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getTestScriptFileName());
            LOG.ok("Test script loaded", new Object[0]);
        }
        LOG.ok("Connector {0} successfully inited", new Object[]{this.getClass().getName()});
    }

    protected abstract Map<String, Object> buildArguments();

    public Uid create(ObjectClass objectClass, Set<Attribute> createAttributes, OperationOptions options) {
        if (((AbstractScriptedConfiguration)((Object)this.config)).isReloadScriptOnExecution()) {
            this.createExecutor = this.getScriptExecutor(((AbstractScriptedConfiguration)((Object)this.config)).getCreateScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getCreateScriptFileName());
            LOG.ok("Create script loaded", new Object[0]);
        }
        if (this.createExecutor != null) {
            if (objectClass == null) {
                throw new IllegalArgumentException(((AbstractScriptedConfiguration)((Object)this.config)).getMessage("objectClass.required", new Object[0]));
            }
            LOG.ok("Object class: {0}", new Object[]{objectClass.getObjectClassValue()});
            if (createAttributes == null || createAttributes.isEmpty()) {
                throw new IllegalArgumentException(((AbstractScriptedConfiguration)((Object)this.config)).getMessage("invalid.attribute.set", new Object[0]));
            }
            Map<String, Object> arguments = this.buildArguments();
            arguments.put("action", "CREATE");
            arguments.put("log", LOG);
            arguments.put("objectClass", objectClass.getObjectClassValue());
            arguments.put("options", options.getOptions());
            String id = null;
            Name name = AttributeUtil.getNameFromAttributes(createAttributes);
            if (name == null) {
                Uid uid = AttributeUtil.getUidAttribute(createAttributes);
                if (uid != null) {
                    id = uid.getUidValue();
                }
            } else {
                id = name.getNameValue();
            }
            arguments.put("id", id);
            HashMap<String, List> attrMap = new HashMap<String, List>();
            for (Attribute attr : createAttributes) {
                attrMap.put(attr.getName(), attr.getValue());
            }
            attrMap.remove(Name.NAME);
            arguments.put("attributes", attrMap);
            if (((AbstractScriptedConfiguration)((Object)this.config)).getClearTextPasswordToScript()) {
                GuardedString gpasswd = AttributeUtil.getPasswordValue(createAttributes);
                arguments.put("password", gpasswd == null ? null : SecurityUtil.decrypt((GuardedString)gpasswd));
            }
            try {
                Object uidAfter = this.createExecutor.execute(arguments);
                if (uidAfter instanceof String) {
                    LOG.ok("{0} created", new Object[]{uidAfter});
                    return new Uid((String)uidAfter);
                }
                throw new ConnectorException("Create script didn't return with the __UID__ value");
            }
            catch (Exception e) {
                throw new ConnectorException("Create script error", (Throwable)e);
            }
        }
        throw new UnsupportedOperationException(((AbstractScriptedConfiguration)((Object)this.config)).getMessage("script.invalid", new Object[0]));
    }

    private Map<String, Object> attributes2Arguments(boolean plainUpdate, Set<Attribute> attrs) {
        if (CollectionUtil.isEmpty(attrs)) {
            throw new IllegalArgumentException(((AbstractScriptedConfiguration)((Object)this.config)).getMessage("invalid.attribute.set", new Object[0]));
        }
        HashMap<String, List> attrMap = new HashMap<String, List>();
        for (Attribute attr : attrs) {
            if (OperationalAttributes.isOperationalAttribute((Attribute)attr)) {
                if (!plainUpdate) continue;
                attrMap.put(attr.getName(), attr.getValue());
                continue;
            }
            attrMap.put(attr.getName(), attr.getValue());
        }
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put("attributes", attrMap);
        if (((AbstractScriptedConfiguration)((Object)this.config)).getClearTextPasswordToScript() && plainUpdate) {
            GuardedString gpasswd = AttributeUtil.getPasswordValue(attrs);
            arguments.put("password", gpasswd == null ? null : SecurityUtil.decrypt((GuardedString)gpasswd));
        }
        return arguments;
    }

    private Uid genericUpdate(String method, ObjectClass objectClass, Uid uid, Map<String, Object> additionalArguments, OperationOptions options) {
        if (((AbstractScriptedConfiguration)((Object)this.config)).isReloadScriptOnExecution()) {
            this.updateExecutor = this.getScriptExecutor(((AbstractScriptedConfiguration)((Object)this.config)).getUpdateScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getUpdateScriptFileName());
            LOG.ok("Update ({0}) script loaded", new Object[]{method});
        }
        if (this.updateExecutor != null) {
            if (objectClass == null) {
                throw new IllegalArgumentException(((AbstractScriptedConfiguration)((Object)this.config)).getMessage("objectClass.required", new Object[0]));
            }
            LOG.ok("Object class: {0}", new Object[]{objectClass.getObjectClassValue()});
            if (uid == null || uid.getUidValue() == null) {
                throw new IllegalArgumentException(((AbstractScriptedConfiguration)((Object)this.config)).getMessage("blank.uid", new Object[0]));
            }
            String id = uid.getUidValue();
            Map<String, Object> arguments = this.buildArguments();
            arguments.putAll(additionalArguments);
            arguments.put("action", method);
            arguments.put("log", LOG);
            arguments.put("objectClass", objectClass.getObjectClassValue());
            arguments.put("uid", id);
            arguments.put("options", options.getOptions());
            try {
                Object uidAfter = this.updateExecutor.execute(arguments);
                if (uidAfter instanceof String) {
                    LOG.ok("{0} updated ({1})", new Object[]{uidAfter, method});
                    return new Uid((String)uidAfter);
                }
            }
            catch (Exception e) {
                throw new ConnectorException("Update(" + method + ") script error", (Throwable)e);
            }
            throw new ConnectorException("Update script didn't return with the __UID__ value");
        }
        throw new UnsupportedOperationException(((AbstractScriptedConfiguration)((Object)this.config)).getMessage("script.invalid", new Object[0]));
    }

    public Uid update(ObjectClass objectClass, Uid uid, Set<Attribute> replaceAttributes, OperationOptions options) {
        return this.genericUpdate("UPDATE", objectClass, uid, this.attributes2Arguments(true, replaceAttributes), options);
    }

    public Set<AttributeDelta> updateDelta(ObjectClass objectClass, Uid uid, Set<AttributeDelta> modifications, OperationOptions options) {
        if (CollectionUtil.isEmpty(modifications)) {
            throw new IllegalArgumentException(((AbstractScriptedConfiguration)((Object)this.config)).getMessage("invalid.attribute.set", new Object[0]));
        }
        HashMap<String, List> valuesToAdd = new HashMap<String, List>();
        HashMap<String, List> valuesToRemove = new HashMap<String, List>();
        HashMap<String, List> valuesToReplace = new HashMap<String, List>();
        for (AttributeDelta attr : modifications) {
            valuesToAdd.put(attr.getName(), attr.getValuesToAdd());
            valuesToRemove.put(attr.getName(), attr.getValuesToRemove());
            valuesToReplace.put(attr.getName(), attr.getValuesToReplace());
        }
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put("valuesToAdd", valuesToAdd);
        arguments.put("valuesToRemove", valuesToRemove);
        arguments.put("valuesToReplace", valuesToReplace);
        this.genericUpdate("UPDATE_DELTA", objectClass, uid, arguments, options);
        return modifications;
    }

    public Uid addAttributeValues(ObjectClass objectClass, Uid uid, Set<Attribute> valuesToAdd, OperationOptions options) {
        return this.genericUpdate("ADD_ATTRIBUTE_VALUES", objectClass, uid, this.attributes2Arguments(false, valuesToAdd), options);
    }

    public Uid removeAttributeValues(ObjectClass objectClass, Uid uid, Set<Attribute> valuesToRemove, OperationOptions options) {
        return this.genericUpdate("REMOVE_ATTRIBUTE_VALUES", objectClass, uid, this.attributes2Arguments(false, valuesToRemove), options);
    }

    public void delete(ObjectClass objectClass, Uid uid, OperationOptions options) {
        if (((AbstractScriptedConfiguration)((Object)this.config)).isReloadScriptOnExecution()) {
            this.deleteExecutor = this.getScriptExecutor(((AbstractScriptedConfiguration)((Object)this.config)).getDeleteScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getDeleteScriptFileName());
            LOG.ok("Delete script loaded", new Object[0]);
        }
        if (this.deleteExecutor != null) {
            if (objectClass == null) {
                throw new IllegalArgumentException(((AbstractScriptedConfiguration)((Object)this.config)).getMessage("objectClass.required", new Object[0]));
            }
            LOG.ok("Object class: {0}", new Object[]{objectClass.getObjectClassValue()});
            if (uid == null || uid.getUidValue() == null) {
                throw new IllegalArgumentException(((AbstractScriptedConfiguration)((Object)this.config)).getMessage("blank.uid", new Object[0]));
            }
            String id = uid.getUidValue();
            Map<String, Object> arguments = this.buildArguments();
            arguments.put("action", "DELETE");
            arguments.put("log", LOG);
            arguments.put("objectClass", objectClass.getObjectClassValue());
            arguments.put("uid", id);
            arguments.put("options", options.getOptions());
            try {
                this.deleteExecutor.execute(arguments);
                LOG.ok("{0} deleted", new Object[]{id});
            }
            catch (Exception e) {
                throw new ConnectorException("Delete script error", (Throwable)e);
            }
        } else {
            throw new UnsupportedOperationException(((AbstractScriptedConfiguration)((Object)this.config)).getMessage("script.invalid", new Object[0]));
        }
    }

    public Uid authenticate(ObjectClass objectClass, String username, GuardedString password, OperationOptions options) {
        if (((AbstractScriptedConfiguration)((Object)this.config)).isReloadScriptOnExecution()) {
            this.authenticateExecutor = this.getScriptExecutor(((AbstractScriptedConfiguration)((Object)this.config)).getAuthenticateScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getAuthenticateScriptFileName());
            LOG.ok("Authenticate script loaded", new Object[0]);
        }
        if (this.authenticateExecutor != null) {
            if (objectClass == null) {
                throw new IllegalArgumentException(((AbstractScriptedConfiguration)((Object)this.config)).getMessage("objectClass.required", new Object[0]));
            }
            LOG.ok("Object class: {0}", new Object[]{objectClass.getObjectClassValue()});
            Map<String, Object> arguments = this.buildArguments();
            arguments.put("action", "AUTHENTICATE");
            arguments.put("log", LOG);
            arguments.put("objectClass", objectClass.getObjectClassValue());
            arguments.put("username", username);
            arguments.put("password", ((AbstractScriptedConfiguration)((Object)this.config)).getClearTextPasswordToScript() ? SecurityUtil.decrypt((GuardedString)password) : password);
            arguments.put("options", options.getOptions());
            try {
                Object uid = this.authenticateExecutor.execute(arguments);
                if (uid instanceof String) {
                    LOG.ok("{0} authenticated", new Object[]{uid});
                    return new Uid((String)uid);
                }
            }
            catch (Exception e) {
                throw new ConnectorException("Authenticate script error", (Throwable)e);
            }
            throw new ConnectorException("Authenticate script didn't return with the __UID__ value");
        }
        throw new UnsupportedOperationException(((AbstractScriptedConfiguration)((Object)this.config)).getMessage("script.invalid", new Object[0]));
    }

    public Uid resolveUsername(ObjectClass objectClass, String username, OperationOptions options) {
        if (((AbstractScriptedConfiguration)((Object)this.config)).isReloadScriptOnExecution()) {
            this.resolveUsernameExecutor = this.getScriptExecutor(((AbstractScriptedConfiguration)((Object)this.config)).getResolveUsernameScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getResolveUsernameScriptFileName());
            LOG.ok("ResolveUsername script loaded", new Object[0]);
        }
        if (this.resolveUsernameExecutor != null) {
            if (objectClass == null) {
                throw new IllegalArgumentException(((AbstractScriptedConfiguration)((Object)this.config)).getMessage("objectClass.required", new Object[0]));
            }
            LOG.ok("Object class: {0}", new Object[]{objectClass.getObjectClassValue()});
            Map<String, Object> arguments = this.buildArguments();
            arguments.put("action", "RESOLVE USERNAME");
            arguments.put("log", LOG);
            arguments.put("objectClass", objectClass.getObjectClassValue());
            arguments.put("username", username);
            arguments.put("options", options.getOptions());
            try {
                Object uid = this.resolveUsernameExecutor.execute(arguments);
                if (uid instanceof String) {
                    LOG.ok("{0} resolved", new Object[]{uid});
                    return new Uid((String)uid);
                }
            }
            catch (Exception e) {
                throw new ConnectorException("ResolveUsername script error", (Throwable)e);
            }
            throw new ConnectorException("ResolveUsername script didn't return with the __UID__ value");
        }
        throw new UnsupportedOperationException(((AbstractScriptedConfiguration)((Object)this.config)).getMessage("script.invalid", new Object[0]));
    }

    public Schema schema() {
        SchemaBuilder scmb = new SchemaBuilder(this.getClass());
        if (((AbstractScriptedConfiguration)((Object)this.config)).isReloadScriptOnExecution()) {
            this.schemaExecutor = this.getScriptExecutor("", ((AbstractScriptedConfiguration)((Object)this.config)).getSchemaScriptFileName());
        }
        if (this.schemaExecutor != null) {
            Map<String, Object> arguments = this.buildArguments();
            arguments.put("action", "SCHEMA");
            arguments.put("log", LOG);
            arguments.put("builder", scmb);
            try {
                this.schemaExecutor.execute(arguments);
            }
            catch (Exception e) {
                throw new ConnectorException("Schema script error", (Throwable)e);
            }
        } else {
            throw new UnsupportedOperationException("SCHEMA script executor is null. Problem loading Schema script");
        }
        this.schema = scmb.build();
        return this.schema;
    }

    public void executeQuery(ObjectClass objectClass, Map<String, Object> query, ResultsHandler handler, OperationOptions options) {
        if (((AbstractScriptedConfiguration)((Object)this.config)).isReloadScriptOnExecution()) {
            this.searchExecutor = this.getScriptExecutor(((AbstractScriptedConfiguration)((Object)this.config)).getSearchScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getSearchScriptFileName());
            LOG.ok("Search script loaded", new Object[0]);
        }
        if (this.searchExecutor != null) {
            if (objectClass == null) {
                throw new IllegalArgumentException(((AbstractScriptedConfiguration)((Object)this.config)).getMessage("objectClass.required", new Object[0]));
            }
            LOG.ok("ObjectClass: {0}", new Object[]{objectClass.getObjectClassValue()});
            if (handler == null) {
                throw new IllegalArgumentException(((AbstractScriptedConfiguration)((Object)this.config)).getMessage("blank.result.hanlder", new Object[0]));
            }
            Map<String, Object> arguments = this.buildArguments();
            arguments.put("objectClass", objectClass.getObjectClassValue());
            arguments.put("action", "SEARCH");
            arguments.put("log", LOG);
            arguments.put("options", options.getOptions());
            arguments.put("query", query);
            try {
                List results = (List)this.searchExecutor.execute(arguments);
                LOG.ok("Search ok", new Object[0]);
                this.processResults(objectClass, results, handler);
            }
            catch (Exception e) {
                throw new ConnectorException("Search script error", (Throwable)e);
            }
        } else {
            throw new UnsupportedOperationException(((AbstractScriptedConfiguration)((Object)this.config)).getMessage("script.invalid", new Object[0]));
        }
    }

    public void sync(ObjectClass objectClass, SyncToken token, SyncResultsHandler handler, OperationOptions options) {
        if (((AbstractScriptedConfiguration)((Object)this.config)).isReloadScriptOnExecution()) {
            this.syncExecutor = this.getScriptExecutor(((AbstractScriptedConfiguration)((Object)this.config)).getSyncScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getSyncScriptFileName());
            LOG.ok("Sync script loaded", new Object[0]);
        }
        if (this.syncExecutor != null) {
            if (objectClass == null) {
                throw new IllegalArgumentException(((AbstractScriptedConfiguration)((Object)this.config)).getMessage("objectClass.required", new Object[0]));
            }
            LOG.ok("ObjectClass: {0}", new Object[]{objectClass.getObjectClassValue()});
            if (handler == null) {
                throw new IllegalArgumentException(((AbstractScriptedConfiguration)((Object)this.config)).getMessage("blank.result.hanlder", new Object[0]));
            }
            Map<String, Object> arguments = this.buildArguments();
            arguments.put("objectClass", objectClass.getObjectClassValue());
            arguments.put("action", "SYNC");
            arguments.put("log", LOG);
            arguments.put("options", options.getOptions());
            arguments.put("token", token == null ? null : token.getValue());
            try {
                List results = (List)this.syncExecutor.execute(arguments);
                LOG.ok("Sync ok", new Object[0]);
                this.processDeltas(objectClass, results, handler);
            }
            catch (Exception e) {
                throw new ConnectorException("Sync script error", (Throwable)e);
            }
        } else {
            throw new UnsupportedOperationException(((AbstractScriptedConfiguration)((Object)this.config)).getMessage("script.invalid", new Object[0]));
        }
    }

    public SyncToken getLatestSyncToken(ObjectClass objectClass) {
        if (((AbstractScriptedConfiguration)((Object)this.config)).isReloadScriptOnExecution()) {
            this.syncExecutor = this.getScriptExecutor(((AbstractScriptedConfiguration)((Object)this.config)).getSyncScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getSyncScriptFileName());
            LOG.ok("Sync script loaded", new Object[0]);
        }
        if (this.syncExecutor != null) {
            SyncToken st = null;
            if (objectClass == null) {
                throw new IllegalArgumentException(((AbstractScriptedConfiguration)((Object)this.config)).getMessage("objectClass.required", new Object[0]));
            }
            LOG.ok("ObjectClass: {0}", new Object[]{objectClass.getObjectClassValue()});
            Map<String, Object> arguments = this.buildArguments();
            arguments.put("objectClass", objectClass.getObjectClassValue());
            arguments.put("action", "GET_LATEST_SYNC_TOKEN");
            arguments.put("log", LOG);
            try {
                Object result = this.syncExecutor.execute(arguments);
                LOG.ok("GetLatestSyncToken ok", new Object[0]);
                FrameworkUtil.checkAttributeType(result.getClass());
                st = new SyncToken(result);
            }
            catch (IllegalArgumentException ae) {
                throw new ConnectorException("Unknown Token type", (Throwable)ae);
            }
            catch (Exception e) {
                throw new ConnectorException("Sync (GetLatestSyncToken) script error", (Throwable)e);
            }
            return st;
        }
        throw new UnsupportedOperationException(((AbstractScriptedConfiguration)((Object)this.config)).getMessage("script.invalid", new Object[0]));
    }

    public Object runScriptOnConnector(ScriptContext request, OperationOptions options) {
        Object result = null;
        try {
            if (request.getScriptText() != null && request.getScriptText().length() > 0) {
                assert (request.getScriptLanguage().equalsIgnoreCase(((AbstractScriptedConfiguration)((Object)this.config)).getScriptingLanguage()));
                this.runOnConnectorExecutor = this.factory.newScriptExecutor(this.getClass().getClassLoader(), request.getScriptText(), true);
            }
        }
        catch (Exception e) {
            throw new ConnectorException("RunOnConnector script parse error", (Throwable)e);
        }
        if (this.runOnConnectorExecutor != null) {
            Map<String, Object> arguments = this.buildArguments();
            arguments.put("action", "RUNSCRIPTONCONNECTOR");
            arguments.put("log", LOG);
            arguments.put("options", options.getOptions());
            arguments.put("scriptsArguments", request.getScriptArguments());
            try {
                result = this.runOnConnectorExecutor.execute(arguments);
                LOG.ok("runOnConnector script ok", new Object[0]);
            }
            catch (Exception e) {
                throw new ConnectorException("runOnConnector script error", (Throwable)e);
            }
            return result;
        }
        throw new UnsupportedOperationException(((AbstractScriptedConfiguration)((Object)this.config)).getMessage("script.invalid", new Object[0]));
    }

    public void test() {
        ((AbstractScriptedConfiguration)((Object)this.config)).validate();
        if (((AbstractScriptedConfiguration)((Object)this.config)).isReloadScriptOnExecution()) {
            this.testExecutor = this.getScriptExecutor(((AbstractScriptedConfiguration)((Object)this.config)).getTestScript(), ((AbstractScriptedConfiguration)((Object)this.config)).getTestScriptFileName());
            LOG.ok("Test script loaded", new Object[0]);
        }
        if (this.testExecutor != null) {
            Map<String, Object> arguments = this.buildArguments();
            arguments.put("action", "TEST");
            arguments.put("log", LOG);
            try {
                this.testExecutor.execute(arguments);
                LOG.ok("Test ok", new Object[0]);
            }
            catch (Exception e) {
                throw new ConnectorException("Test script error", (Throwable)e);
            }
        }
    }

    private void processResults(ObjectClass objectClass, List<Map<String, Object>> results, ResultsHandler handler) {
        String pagedResultCookie = null;
        for (Map<String, Object> result : results) {
            if (result.size() == 1) {
                Map.Entry<String, Object> entry = result.entrySet().iterator().next();
                if (!"PAGED_RESULTS_COOKIE".equalsIgnoreCase(entry.getKey()) || entry.getValue() == null) continue;
                pagedResultCookie = entry.getValue().toString();
                continue;
            }
            ConnectorObjectBuilder cobld = new ConnectorObjectBuilder();
            for (Map.Entry<String, Object> entry : result.entrySet()) {
                String attrName = entry.getKey();
                Object attrValue = entry.getValue();
                if (Uid.NAME.equalsIgnoreCase(attrName)) {
                    if (attrValue == null) {
                        throw new IllegalArgumentException("Uid cannot be null");
                    }
                    cobld.setUid(attrValue.toString());
                    continue;
                }
                if (Name.NAME.equalsIgnoreCase(attrName)) {
                    if (attrValue == null) {
                        throw new IllegalArgumentException("Name cannot be null");
                    }
                    cobld.setName(attrValue.toString());
                    continue;
                }
                if (attrName.equalsIgnoreCase("password")) continue;
                if (attrValue instanceof Collection) {
                    cobld.addAttribute(new Attribute[]{AttributeBuilder.build((String)attrName, (Collection)((Collection)attrValue))});
                    continue;
                }
                if (attrValue != null) {
                    cobld.addAttribute(new Attribute[]{AttributeBuilder.build((String)attrName, (Object[])new Object[]{attrValue})});
                    continue;
                }
                cobld.addAttribute(new Attribute[]{AttributeBuilder.build((String)attrName)});
            }
            cobld.setObjectClass(objectClass);
            handler.handle(cobld.build());
            LOG.ok("ConnectorObject is built", new Object[0]);
        }
        if (handler instanceof SearchResultsHandler) {
            ((SearchResultsHandler)SearchResultsHandler.class.cast(handler)).handleResult(new SearchResult(pagedResultCookie, -1));
        } else {
            LOG.warn("Not expected, but found {0}: {1}", new Object[]{"PAGED_RESULTS_COOKIE", pagedResultCookie});
        }
    }

    private void processDeltas(ObjectClass objectClass, List<Map<String, Object>> results, SyncResultsHandler handler) {
        for (Map<String, Object> result : results) {
            Object attributes;
            SyncDeltaBuilder syncbld = new SyncDeltaBuilder();
            String uid = (String)result.get("uid");
            if (uid == null || uid.isEmpty()) continue;
            syncbld.setUid(new Uid(uid));
            Object token = result.get("token");
            if (token == null) {
                LOG.ok("token value is null, replacing to 0L", new Object[0]);
                token = 0L;
            }
            syncbld.setToken(new SyncToken(token));
            ConnectorObjectBuilder cobld = new ConnectorObjectBuilder();
            cobld.setName(uid);
            cobld.setUid(uid);
            cobld.setObjectClass(objectClass);
            String op = (String)result.get("operation");
            syncbld.setDeltaType(op != null && SyncDeltaType.DELETE.name().equalsIgnoreCase(op) ? SyncDeltaType.DELETE : SyncDeltaType.CREATE_OR_UPDATE);
            String prevUid = (String)result.get("previousUid");
            if (prevUid != null && !prevUid.isEmpty()) {
                syncbld.setPreviousUid(new Uid(prevUid));
            }
            if (result.get("password") != null) {
                cobld.addAttribute(new Attribute[]{AttributeBuilder.buildCurrentPassword((char[])((String)result.get("password")).toCharArray())});
            }
            if ((attributes = result.get("attributes")) != null) {
                for (Map.Entry attr : ((Map)attributes).entrySet()) {
                    String attrName = (String)attr.getKey();
                    Object attrValue = attr.getValue();
                    if (attrValue instanceof Collection) {
                        cobld.addAttribute(new Attribute[]{AttributeBuilder.build((String)attrName, (Collection)((Collection)attrValue))});
                        continue;
                    }
                    if (attrValue != null) {
                        cobld.addAttribute(new Attribute[]{AttributeBuilder.build((String)attrName, (Object[])new Object[]{attrValue})});
                        continue;
                    }
                    cobld.addAttribute(new Attribute[]{AttributeBuilder.build((String)attrName)});
                }
            }
            syncbld.setObject(cobld.build());
            if (handler.handle(syncbld.build())) continue;
            LOG.ok("Stop processing of the sync result set", new Object[0]);
            break;
        }
    }

    private boolean checkReloadScript(ScriptExecutor scriptExecutor, String scriptString, String scriptFileName) {
        return !(!StringUtil.isNotBlank((String)scriptFileName) && !StringUtil.isNotBlank((String)scriptString) || scriptExecutor != null && !((AbstractScriptedConfiguration)((Object)this.config)).isReloadScriptOnExecution());
    }
}

