/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.test.common;

import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class PropertyBag {
    private final Map<String, Object> bag;

    PropertyBag(Map<String, Object> bag) {
        this.bag = new HashMap<String, Object>(bag);
    }

    public <T> T getProperty(String name, Class<T> type) {
        if (!this.bag.containsKey(name)) {
            throw new IllegalArgumentException(MessageFormat.format("Property named \"{0}\" not found in bag", name));
        }
        return this.castValue(name, type);
    }

    private <T> T castValue(String name, Class<T> type) {
        Object value = this.bag.get(name);
        if (value == null) {
            return null;
        }
        return this.castValue(name, value, type);
    }

    private <T> T castValue(String name, Object value, Class<T> type) {
        if (value == null) {
            return null;
        }
        if (!type.isInstance(value)) {
            if (type.isArray() && value instanceof Collection) {
                Collection collection = (Collection)value;
                Object array = Array.newInstance(type.getComponentType(), collection.size());
                int i = 0;
                for (Object itemValue : collection) {
                    Array.set(array, i++, this.castValue(name, itemValue, type.getComponentType()));
                }
                return (T)array;
            }
            if (type.isArray()) {
                Object array = Array.newInstance(type.getComponentType(), 1);
                Array.set(array, 0, this.castValue(name, value, type.getComponentType()));
                return (T)array;
            }
            if (Byte.TYPE.equals(type) && value instanceof Byte) {
                return (T)value;
            }
            if (Byte.class.equals(type) && Byte.TYPE.isInstance(value)) {
                return (T)value;
            }
            if (Short.TYPE.equals(type) && value instanceof Short) {
                return (T)value;
            }
            if (Short.class.equals(type) && Short.TYPE.isInstance(value)) {
                return (T)value;
            }
            if (Integer.TYPE.equals(type) && value instanceof Integer) {
                return (T)value;
            }
            if (Integer.class.equals(type) && Integer.TYPE.isInstance(value)) {
                return (T)value;
            }
            if (Long.TYPE.equals(type) && value instanceof Long) {
                return (T)value;
            }
            if (Long.class.equals(type) && Long.TYPE.isInstance(value)) {
                return (T)value;
            }
            if (Float.TYPE.equals(type) && value instanceof Float) {
                return (T)value;
            }
            if (Float.class.equals(type) && Float.TYPE.isInstance(value)) {
                return (T)value;
            }
            if (Double.TYPE.equals(type) && value instanceof Double) {
                return (T)value;
            }
            if (Double.class.equals(type) && Double.TYPE.isInstance(value)) {
                return (T)value;
            }
            if (Boolean.TYPE.equals(type) && value instanceof Boolean) {
                return (T)value;
            }
            if (Boolean.class.equals(type) && Boolean.TYPE.isInstance(value)) {
                return (T)value;
            }
            if (Character.TYPE.equals(type) && value instanceof Character) {
                return (T)value;
            }
            if (Character.class.equals(type) && Character.TYPE.isInstance(value)) {
                return (T)value;
            }
            throw new ClassCastException(MessageFormat.format("Property named \"{0}\" is of type \"{1}\" but expected type was \"{2}\"", name, value.getClass(), type));
        }
        return type.cast(value);
    }

    public <T> T getProperty(String name, Class<T> type, T def) {
        if (!this.bag.containsKey(name)) {
            return def;
        }
        return this.castValue(name, type);
    }

    public String getStringProperty(String name) {
        return this.getProperty(name, String.class);
    }

    public String toString() {
        return this.bag.toString();
    }

    Map<String, Object> toMap() {
        return this.bag;
    }
}

