/*
 * Decompiled with CFR 0.152.
 */
package net.tlabs.tablesaw.parquet;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.JulianFields;
import java.util.List;
import java.util.Optional;
import net.tlabs.tablesaw.parquet.TableProxy;
import net.tlabs.tablesaw.parquet.TablesawParquetReadOptions;
import org.apache.parquet.Preconditions;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.tools.read.SimpleRecordConverter;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Row;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;

public class TablesawRecordConverter
extends GroupConverter {
    private static final int BINARY_INSTANT_LENGTH_VALUE = 12;
    private static final String BINARY_INSTANT_LENGTH_MESSAGE = "Must be 12 bytes";
    private static final int BINARY_INTERVAL_LENGTH_VALUE = 12;
    private static final String BINARY_INTERVAL_LENGTH_MESSAGE = "Must be 12 bytes";
    private static final long SECOND_TO_MILLIS = 1000L;
    private static final long SECOND_TO_MICROS = 1000000L;
    private static final long SECOND_TO_NANOS = 1000000000L;
    private static final long MICROS_TO_NANOS = 1000L;
    private static final long MILLIS_TO_MICRO = 1000L;
    private static final long MILLIS_TO_NANOS = 1000000L;
    private final Converter[] converters;
    private final TableProxy proxy;

    public TablesawRecordConverter(Table table, MessageType fileSchema, TablesawParquetReadOptions options) {
        this.proxy = new TableProxy(table);
        this.converters = new Converter[fileSchema.getFieldCount()];
        List columns = table.columns();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            Column column = (Column)columns.get(i);
            ColumnType columnType = column.type();
            int fieldIndex = fileSchema.getFieldIndex(column.name());
            Type type = fileSchema.getType(fieldIndex);
            this.converters[fieldIndex] = type.isPrimitive() ? this.createConverter(i, columnType, type, options) : new GroupAsTextConverter(type.asGroupType(), i);
        }
    }

    private Converter createConverter(final int colIndex, ColumnType columnType, Type schemaType, TablesawParquetReadOptions options) {
        if (ColumnType.INTEGER.equals((Object)columnType)) {
            return new PrimitiveConverter(){

                public void addInt(int value) {
                    TablesawRecordConverter.this.proxy.appendInt(colIndex, value);
                }
            };
        }
        if (ColumnType.LONG.equals((Object)columnType)) {
            return new PrimitiveConverter(){

                public void addInt(int value) {
                    TablesawRecordConverter.this.proxy.appendLong(colIndex, value);
                }

                public void addLong(long value) {
                    TablesawRecordConverter.this.proxy.appendLong(colIndex, value);
                }
            };
        }
        if (ColumnType.DOUBLE.equals((Object)columnType)) {
            return Optional.ofNullable(schemaType.getLogicalTypeAnnotation()).flatMap(a -> this.doubleFromBinaryConverter(colIndex, (LogicalTypeAnnotation)a)).orElseGet(() -> new DefaultDoublePrimitiveConverter(colIndex));
        }
        if (ColumnType.BOOLEAN.equals((Object)columnType)) {
            return new PrimitiveConverter(){

                public void addBoolean(boolean value) {
                    TablesawRecordConverter.this.proxy.appendBoolean(colIndex, value);
                }
            };
        }
        if (ColumnType.STRING.equals((Object)columnType)) {
            return Optional.ofNullable(schemaType.getLogicalTypeAnnotation()).flatMap(a -> this.annotatedStringConverter(colIndex, (LogicalTypeAnnotation)a)).orElseGet(() -> this.createUnannotatedStringConverter(colIndex, schemaType, options));
        }
        if (ColumnType.FLOAT.equals((Object)columnType)) {
            return new PrimitiveConverter(){

                public void addFloat(float value) {
                    TablesawRecordConverter.this.proxy.appendFloat(colIndex, value);
                }
            };
        }
        if (ColumnType.INSTANT.equals((Object)columnType)) {
            return Optional.ofNullable(schemaType.getLogicalTypeAnnotation()).flatMap(a -> this.annotatedInstantConverter(colIndex, (LogicalTypeAnnotation)a)).orElseGet(() -> new MillisInstantPrimitiveConverter(colIndex));
        }
        if (ColumnType.LOCAL_DATE_TIME.equals((Object)columnType)) {
            return Optional.ofNullable(schemaType.getLogicalTypeAnnotation()).flatMap(a -> this.annotatedDateTimeConverter(colIndex, (LogicalTypeAnnotation)a)).orElseGet(() -> new DateTimePrimitiveConverter(colIndex, 1000L, 1000000L));
        }
        if (ColumnType.LOCAL_DATE.equals((Object)columnType)) {
            return new PrimitiveConverter(){

                public void addInt(int value) {
                    TablesawRecordConverter.this.proxy.appendDate(colIndex, LocalDate.ofEpochDay(value));
                }
            };
        }
        if (ColumnType.LOCAL_TIME.equals((Object)columnType)) {
            return Optional.ofNullable(schemaType.getLogicalTypeAnnotation()).flatMap(a -> this.annotatedTimeConverter(colIndex, (LogicalTypeAnnotation)a)).orElseGet(() -> new TimePrimitiveConverter(colIndex, 1L));
        }
        if (ColumnType.SHORT.equals((Object)columnType)) {
            return new PrimitiveConverter(){

                public void addInt(int value) {
                    TablesawRecordConverter.this.proxy.appendShort(colIndex, (short)value);
                }
            };
        }
        if (ColumnType.TEXT.equals((Object)columnType)) {
            return new PrimitiveConverter(){

                public void addBinary(Binary value) {
                    TablesawRecordConverter.this.proxy.appendText(colIndex, value.toStringUsingUTF8());
                }
            };
        }
        return null;
    }

    private Optional<Converter> annotatedDateTimeConverter(final int colIndex, LogicalTypeAnnotation annotation) {
        return annotation.accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Converter>(){

            public Optional<Converter> visit(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalType) {
                switch (timestampLogicalType.getUnit()) {
                    case MILLIS: {
                        return Optional.of(new DateTimePrimitiveConverter(colIndex, 1000L, 1000000L));
                    }
                    case MICROS: {
                        return Optional.of(new DateTimePrimitiveConverter(colIndex, 1000000L, 1000L));
                    }
                    case NANOS: {
                        return Optional.of(new DateTimePrimitiveConverter(colIndex, 1000000000L, 1L));
                    }
                }
                throw new UnsupportedOperationException("This should never happen: TimeUnit is neither MILLIS, MICROS or NANOS in DateTime");
            }
        });
    }

    private Optional<Converter> annotatedTimeConverter(final int colIndex, LogicalTypeAnnotation annotation) {
        return annotation.accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Converter>(){

            public Optional<Converter> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeLogicalType) {
                switch (timeLogicalType.getUnit()) {
                    case MILLIS: {
                        return Optional.of(new TimePrimitiveConverter(colIndex, 1000000L));
                    }
                    case MICROS: {
                        return Optional.of(new TimePrimitiveConverter(colIndex, 1000L));
                    }
                    case NANOS: {
                        return Optional.of(new TimePrimitiveConverter(colIndex, 1L));
                    }
                }
                throw new UnsupportedOperationException("This should never happen: TimeUnit is neither MICROS or NANOS in Int64 Time");
            }
        });
    }

    private Optional<Converter> annotatedInstantConverter(final int colIndex, LogicalTypeAnnotation annotation) {
        return annotation.accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Converter>(){

            public Optional<Converter> visit(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalType) {
                switch (timestampLogicalType.getUnit()) {
                    case MILLIS: {
                        return Optional.of(new MillisInstantPrimitiveConverter(colIndex));
                    }
                    case MICROS: {
                        return Optional.of(new SubMillisInstantPrimitiveConverter(colIndex, 1000L, ChronoUnit.MICROS));
                    }
                    case NANOS: {
                        return Optional.of(new SubMillisInstantPrimitiveConverter(colIndex, 1000000L, ChronoUnit.NANOS));
                    }
                }
                throw new UnsupportedOperationException("This should never happen: TimeUnit is neither MILLIS, MICROS or NANOS in Timestamp");
            }
        });
    }

    private Optional<Converter> annotatedStringConverter(final int colIndex, LogicalTypeAnnotation annotation) {
        return annotation.accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Converter>(){

            public Optional<Converter> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation stringLogicalType) {
                return Optional.of(new StringPrimitiveConverter(colIndex));
            }

            public Optional<Converter> visit(LogicalTypeAnnotation.EnumLogicalTypeAnnotation enumLogicalType) {
                return Optional.of(new StringPrimitiveConverter(colIndex));
            }

            public Optional<Converter> visit(LogicalTypeAnnotation.IntervalLogicalTypeAnnotation intervalLogicalType) {
                return Optional.of(new PrimitiveConverter(){

                    public void addBinary(Binary value) {
                        Preconditions.checkArgument((value.length() == 12 ? 1 : 0) != 0, (String)"Must be 12 bytes");
                        ByteBuffer buf = value.toByteBuffer();
                        buf.order(ByteOrder.LITTLE_ENDIAN);
                        TablesawRecordConverter.this.proxy.appendString(colIndex, Period.ofMonths(buf.getInt()).plusDays(buf.getInt()).toString() + Duration.ofMillis(buf.getInt()).toString().substring(1));
                    }
                });
            }
        });
    }

    private Optional<Converter> doubleFromBinaryConverter(final int colIndex, LogicalTypeAnnotation annotation) {
        return annotation.accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Converter>(){

            public Optional<Converter> visit(final LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType) {
                return Optional.of(new PrimitiveConverter(){

                    public void addBinary(Binary value) {
                        BigDecimal bigd = new BigDecimal(new BigInteger(value.getBytes()), decimalLogicalType.getScale());
                        TablesawRecordConverter.this.proxy.appendDouble(colIndex, bigd.doubleValue());
                    }
                });
            }
        });
    }

    private Converter createUnannotatedStringConverter(int colIndex, Type schemaType, TablesawParquetReadOptions options) {
        if (schemaType.asPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT96) {
            return new HexStringPrimitiveConverter(colIndex);
        }
        return options.getUnnanotatedBinaryAs() == TablesawParquetReadOptions.UnnanotatedBinaryAs.STRING ? new StringPrimitiveConverter(colIndex) : new HexStringPrimitiveConverter(colIndex);
    }

    private static String rawBytesToHexString(byte[] bytes) {
        CharSequence[] hexBytes = new String[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            hexBytes[i] = String.format("%02X", bytes[i]);
        }
        return String.join((CharSequence)" ", hexBytes);
    }

    public Converter getConverter(int fieldIndex) {
        return this.converters[fieldIndex];
    }

    public void start() {
        this.proxy.startRow();
    }

    public void end() {
        this.proxy.endRow();
    }

    public Row getCurrentRow() {
        return this.proxy.getCurrentRow();
    }

    private final class GroupAsTextConverter
    extends SimpleRecordConverter {
        private final int col;

        private GroupAsTextConverter(GroupType schema, int col) {
            super(schema);
            this.col = col;
        }

        @Override
        public void end() {
            TablesawRecordConverter.this.proxy.appendText(this.col, this.record.toString());
        }
    }

    private final class HexStringPrimitiveConverter
    extends PrimitiveConverter {
        private final int colIndex;

        private HexStringPrimitiveConverter(int colIndex) {
            this.colIndex = colIndex;
        }

        public void addBinary(Binary value) {
            TablesawRecordConverter.this.proxy.appendString(this.colIndex, TablesawRecordConverter.rawBytesToHexString(value.getBytes()));
        }
    }

    private final class StringPrimitiveConverter
    extends PrimitiveConverter {
        private final int colIndex;

        private StringPrimitiveConverter(int colIndex) {
            this.colIndex = colIndex;
        }

        public void addBinary(Binary value) {
            TablesawRecordConverter.this.proxy.appendString(this.colIndex, value.toStringUsingUTF8());
        }
    }

    private final class TimePrimitiveConverter
    extends PrimitiveConverter {
        private final int colIndex;
        private final long longValueFactor;

        private TimePrimitiveConverter(int colIndex, long longValueFactor) {
            this.colIndex = colIndex;
            this.longValueFactor = longValueFactor;
        }

        public void addInt(int value) {
            TablesawRecordConverter.this.proxy.appendTime(this.colIndex, LocalTime.ofNanoOfDay(1000000L * (long)value));
        }

        public void addLong(long value) {
            TablesawRecordConverter.this.proxy.appendTime(this.colIndex, LocalTime.ofNanoOfDay(value * this.longValueFactor));
        }
    }

    private final class DefaultDoublePrimitiveConverter
    extends PrimitiveConverter {
        private final int colIndex;

        private DefaultDoublePrimitiveConverter(int colIndex) {
            this.colIndex = colIndex;
        }

        public void addFloat(float value) {
            TablesawRecordConverter.this.proxy.appendDouble(this.colIndex, value);
        }

        public void addDouble(double value) {
            TablesawRecordConverter.this.proxy.appendDouble(this.colIndex, value);
        }
    }

    private final class SubMillisInstantPrimitiveConverter
    extends InstantPrimitiveConverter {
        private final long factor;
        private final ChronoUnit chronoUnit;

        private SubMillisInstantPrimitiveConverter(int colIndex, long factor, ChronoUnit unit) {
            super(colIndex);
            this.factor = factor;
            this.chronoUnit = unit;
        }

        public void addLong(long value) {
            long millisFromValue = value / this.factor;
            TablesawRecordConverter.this.proxy.appendInstant(this.colIndex, Instant.ofEpochMilli(millisFromValue).plus(value - millisFromValue * this.factor, this.chronoUnit));
        }
    }

    private final class MillisInstantPrimitiveConverter
    extends InstantPrimitiveConverter {
        private MillisInstantPrimitiveConverter(int colIndex) {
            super(colIndex);
        }

        public void addLong(long value) {
            TablesawRecordConverter.this.proxy.appendInstant(this.colIndex, Instant.ofEpochMilli(value));
        }
    }

    private abstract class InstantPrimitiveConverter
    extends PrimitiveConverter {
        protected final int colIndex;

        private InstantPrimitiveConverter(int colIndex) {
            this.colIndex = colIndex;
        }

        public void addBinary(Binary value) {
            Preconditions.checkArgument((value.length() == 12 ? 1 : 0) != 0, (String)"Must be 12 bytes");
            ByteBuffer buf = value.toByteBuffer();
            buf.order(ByteOrder.LITTLE_ENDIAN);
            long nanotime = buf.getLong();
            int julianday = buf.getInt();
            LocalDate date = LocalDate.ofEpochDay(0L).with(JulianFields.JULIAN_DAY, julianday);
            TablesawRecordConverter.this.proxy.appendInstant(this.colIndex, ZonedDateTime.of(date.atStartOfDay(), ZoneOffset.UTC).toInstant().plus(nanotime, ChronoUnit.NANOS));
        }
    }

    private final class DateTimePrimitiveConverter
    extends PrimitiveConverter {
        private final int colIndex;
        private final long secondFactor;
        private final long nanoFactor;

        private DateTimePrimitiveConverter(int colIndex, long secondFactor, long nanoFactor) {
            this.colIndex = colIndex;
            this.secondFactor = secondFactor;
            this.nanoFactor = nanoFactor;
        }

        public void addLong(long value) {
            long epochSecond = value / this.secondFactor;
            TablesawRecordConverter.this.proxy.appendDateTime(this.colIndex, LocalDateTime.ofEpochSecond(epochSecond, (int)((value - epochSecond * this.secondFactor) * this.nanoFactor), ZoneOffset.UTC));
        }
    }
}

