/*
 * Decompiled with CFR 0.152.
 */
package net.tlabs.tablesaw.parquet;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.tlabs.tablesaw.parquet.TableProxy;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Row;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;

public class TablesawWriteSupport
extends WriteSupport<Row> {
    private static final String WRITE_SUPPORT_NAME = "net.tlabs.tablesaw.parquet";
    private static final Map<ColumnType, PrimitiveType.PrimitiveTypeName> PRIMITIVE_MAPPING = new HashMap<ColumnType, PrimitiveType.PrimitiveTypeName>();
    private static final Map<ColumnType, LogicalTypeAnnotation> ANNOTATION_MAPPING;
    private static final Map<ColumnType, FieldRecorder> RECORDER_MAPPING;
    private final TableProxy proxy;
    private final MessageType schema;
    private final int nbfields;
    private RecordConsumer recordConsumer;
    private FieldRecorder[] fieldRecorders;

    public TablesawWriteSupport(Table table) {
        this.proxy = new TableProxy(table);
        this.schema = TablesawWriteSupport.internalCreateSchema(table);
        this.nbfields = this.schema.getFieldCount();
        this.fieldRecorders = TablesawWriteSupport.internalCreateRecorders(table);
    }

    private static FieldRecorder[] internalCreateRecorders(Table table) {
        return table.columns().stream().map(Column::type).map(RECORDER_MAPPING::get).collect(Collectors.toList()).toArray(new FieldRecorder[0]);
    }

    public static MessageType createSchema(Table table) {
        return TablesawWriteSupport.internalCreateSchema(table);
    }

    private static MessageType internalCreateSchema(Table table) {
        String tableName = table.name();
        return new MessageType(tableName == null ? "message" : tableName, table.columns().stream().map(TablesawWriteSupport::createType).collect(Collectors.toList()));
    }

    private static Type createType(Column<?> column) {
        ColumnType type = column.type();
        return (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PRIMITIVE_MAPPING.get(type)).as(ANNOTATION_MAPPING.get(type))).named(column.name());
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        return new WriteSupport.WriteContext(this.schema, new HashMap());
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer = recordConsumer;
    }

    public void write(Row row) {
        this.recordConsumer.startMessage();
        this.recordRow(row);
        this.recordConsumer.endMessage();
    }

    private void recordRow(Row row) {
        int rowNumber = row.getRowNumber();
        for (int colIndex = 0; colIndex < this.nbfields; ++colIndex) {
            Column<?> column = this.proxy.column(colIndex);
            if (column.isMissing(rowNumber)) continue;
            String fieldName = column.name();
            this.recordConsumer.startField(fieldName, colIndex);
            this.fieldRecorders[colIndex].recordValue(this.recordConsumer, this.proxy, colIndex, rowNumber);
            this.recordConsumer.endField(fieldName, colIndex);
        }
    }

    public String getName() {
        return WRITE_SUPPORT_NAME;
    }

    static {
        PRIMITIVE_MAPPING.put((ColumnType)ColumnType.BOOLEAN, PrimitiveType.PrimitiveTypeName.BOOLEAN);
        PRIMITIVE_MAPPING.put((ColumnType)ColumnType.DOUBLE, PrimitiveType.PrimitiveTypeName.DOUBLE);
        PRIMITIVE_MAPPING.put((ColumnType)ColumnType.FLOAT, PrimitiveType.PrimitiveTypeName.FLOAT);
        PRIMITIVE_MAPPING.put((ColumnType)ColumnType.SHORT, PrimitiveType.PrimitiveTypeName.INT32);
        PRIMITIVE_MAPPING.put((ColumnType)ColumnType.INTEGER, PrimitiveType.PrimitiveTypeName.INT32);
        PRIMITIVE_MAPPING.put((ColumnType)ColumnType.LONG, PrimitiveType.PrimitiveTypeName.INT64);
        PRIMITIVE_MAPPING.put((ColumnType)ColumnType.INSTANT, PrimitiveType.PrimitiveTypeName.INT64);
        PRIMITIVE_MAPPING.put((ColumnType)ColumnType.LOCAL_DATE, PrimitiveType.PrimitiveTypeName.INT32);
        PRIMITIVE_MAPPING.put((ColumnType)ColumnType.LOCAL_TIME, PrimitiveType.PrimitiveTypeName.INT32);
        PRIMITIVE_MAPPING.put((ColumnType)ColumnType.LOCAL_DATE_TIME, PrimitiveType.PrimitiveTypeName.INT64);
        PRIMITIVE_MAPPING.put((ColumnType)ColumnType.STRING, PrimitiveType.PrimitiveTypeName.BINARY);
        PRIMITIVE_MAPPING.put((ColumnType)ColumnType.TEXT, PrimitiveType.PrimitiveTypeName.BINARY);
        ANNOTATION_MAPPING = new HashMap<ColumnType, LogicalTypeAnnotation>();
        ANNOTATION_MAPPING.put((ColumnType)ColumnType.SHORT, (LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)true));
        ANNOTATION_MAPPING.put((ColumnType)ColumnType.LOCAL_DATE, (LogicalTypeAnnotation)LogicalTypeAnnotation.dateType());
        ANNOTATION_MAPPING.put((ColumnType)ColumnType.LOCAL_TIME, (LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS));
        ANNOTATION_MAPPING.put((ColumnType)ColumnType.INSTANT, (LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS));
        ANNOTATION_MAPPING.put((ColumnType)ColumnType.LOCAL_DATE_TIME, (LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS));
        ANNOTATION_MAPPING.put((ColumnType)ColumnType.STRING, (LogicalTypeAnnotation)LogicalTypeAnnotation.stringType());
        ANNOTATION_MAPPING.put((ColumnType)ColumnType.TEXT, (LogicalTypeAnnotation)LogicalTypeAnnotation.stringType());
        RECORDER_MAPPING = new HashMap<ColumnType, FieldRecorder>();
        RECORDER_MAPPING.put((ColumnType)ColumnType.BOOLEAN, FieldRecorder.BOOLEAN);
        RECORDER_MAPPING.put((ColumnType)ColumnType.SHORT, FieldRecorder.SHORT);
        RECORDER_MAPPING.put((ColumnType)ColumnType.INTEGER, FieldRecorder.INTEGER);
        RECORDER_MAPPING.put((ColumnType)ColumnType.LONG, FieldRecorder.LONG);
        RECORDER_MAPPING.put((ColumnType)ColumnType.FLOAT, FieldRecorder.FLOAT);
        RECORDER_MAPPING.put((ColumnType)ColumnType.DOUBLE, FieldRecorder.DOUBLE);
        RECORDER_MAPPING.put((ColumnType)ColumnType.LOCAL_DATE, FieldRecorder.LOCAL_DATE);
        RECORDER_MAPPING.put((ColumnType)ColumnType.LOCAL_TIME, FieldRecorder.LOCAL_TIME);
        RECORDER_MAPPING.put((ColumnType)ColumnType.LOCAL_DATE_TIME, FieldRecorder.LOCAL_DATE_TIME);
        RECORDER_MAPPING.put((ColumnType)ColumnType.INSTANT, FieldRecorder.INSTANT);
        RECORDER_MAPPING.put((ColumnType)ColumnType.STRING, FieldRecorder.STRING);
        RECORDER_MAPPING.put((ColumnType)ColumnType.TEXT, FieldRecorder.TEXT);
    }

    private static enum FieldRecorder {
        BOOLEAN((ColumnType)ColumnType.BOOLEAN){

            @Override
            void recordValue(RecordConsumer recordConsumer, TableProxy tableProxy, int colIndex, int rowNumber) {
                recordConsumer.addBoolean(tableProxy.getBoolean(colIndex, rowNumber));
            }
        }
        ,
        SHORT((ColumnType)ColumnType.SHORT){

            @Override
            void recordValue(RecordConsumer recordConsumer, TableProxy tableProxy, int colIndex, int rowNumber) {
                recordConsumer.addInteger(tableProxy.getShort(colIndex, rowNumber));
            }
        }
        ,
        INTEGER((ColumnType)ColumnType.INTEGER){

            @Override
            void recordValue(RecordConsumer recordConsumer, TableProxy tableProxy, int colIndex, int rowNumber) {
                recordConsumer.addInteger(tableProxy.getInt(colIndex, rowNumber));
            }
        }
        ,
        LONG((ColumnType)ColumnType.LONG){

            @Override
            void recordValue(RecordConsumer recordConsumer, TableProxy tableProxy, int colIndex, int rowNumber) {
                recordConsumer.addLong(tableProxy.getLong(colIndex, rowNumber));
            }
        }
        ,
        FLOAT((ColumnType)ColumnType.FLOAT){

            @Override
            void recordValue(RecordConsumer recordConsumer, TableProxy tableProxy, int colIndex, int rowNumber) {
                recordConsumer.addFloat(tableProxy.getFloat(colIndex, rowNumber));
            }
        }
        ,
        DOUBLE((ColumnType)ColumnType.DOUBLE){

            @Override
            void recordValue(RecordConsumer recordConsumer, TableProxy tableProxy, int colIndex, int rowNumber) {
                recordConsumer.addDouble(tableProxy.getDouble(colIndex, rowNumber));
            }
        }
        ,
        STRING((ColumnType)ColumnType.STRING){

            @Override
            void recordValue(RecordConsumer recordConsumer, TableProxy tableProxy, int colIndex, int rowNumber) {
                recordConsumer.addBinary(Binary.fromString((String)tableProxy.getString(colIndex, rowNumber)));
            }
        }
        ,
        TEXT((ColumnType)ColumnType.TEXT){

            @Override
            void recordValue(RecordConsumer recordConsumer, TableProxy tableProxy, int colIndex, int rowNumber) {
                recordConsumer.addBinary(Binary.fromString((String)tableProxy.getText(colIndex, rowNumber)));
            }
        }
        ,
        LOCAL_DATE((ColumnType)ColumnType.LOCAL_DATE){

            @Override
            void recordValue(RecordConsumer recordConsumer, TableProxy tableProxy, int colIndex, int rowNumber) {
                recordConsumer.addInteger(tableProxy.getDateAsEpochDay(colIndex, rowNumber));
            }
        }
        ,
        LOCAL_TIME((ColumnType)ColumnType.LOCAL_TIME){

            @Override
            void recordValue(RecordConsumer recordConsumer, TableProxy tableProxy, int colIndex, int rowNumber) {
                recordConsumer.addInteger(tableProxy.getTimeAsMilliOfDay(colIndex, rowNumber));
            }
        }
        ,
        LOCAL_DATE_TIME((ColumnType)ColumnType.LOCAL_DATE_TIME){

            @Override
            void recordValue(RecordConsumer recordConsumer, TableProxy tableProxy, int colIndex, int rowNumber) {
                recordConsumer.addLong(tableProxy.getDateTimeAsEpochMilli(colIndex, rowNumber));
            }
        }
        ,
        INSTANT((ColumnType)ColumnType.INSTANT){

            @Override
            void recordValue(RecordConsumer recordConsumer, TableProxy tableProxy, int colIndex, int rowNumber) {
                recordConsumer.addLong(tableProxy.getInstantAsEpochMilli(colIndex, rowNumber));
            }
        };

        final ColumnType columnType;

        private FieldRecorder(ColumnType columnType) {
            this.columnType = columnType;
        }

        abstract void recordValue(RecordConsumer var1, TableProxy var2, int var3, int var4);
    }
}

