/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.tools.read;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.apache.parquet.tools.read.SimpleRecord;
import shaded.parquet.com.fasterxml.jackson.databind.node.BinaryNode;

public class SimpleMapRecord
extends SimpleRecord {
    @Override
    protected Object toJsonObject() {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (SimpleRecord.NameValue value : this.values) {
            String key = null;
            Object val = null;
            for (SimpleRecord.NameValue kv : ((SimpleRecord)value.getValue()).values) {
                String kvName = kv.getName();
                Object kvValue = kv.getValue();
                if (kvName.equals("key")) {
                    key = this.keyToString(kvValue);
                    continue;
                }
                if (!kvName.equals("value")) continue;
                val = SimpleMapRecord.toJsonValue(kvValue);
            }
            result.put(key, val);
        }
        return result;
    }

    String keyToString(Object kvValue) {
        if (kvValue == null) {
            return "null";
        }
        Class<?> type = kvValue.getClass();
        if (type.isArray()) {
            if (type.getComponentType() == Boolean.TYPE) {
                return Arrays.toString((boolean[])kvValue);
            }
            if (type.getComponentType() == Byte.TYPE) {
                return new BinaryNode((byte[])kvValue).asText();
            }
            if (type.getComponentType() == Character.TYPE) {
                return Arrays.toString((char[])kvValue);
            }
            if (type.getComponentType() == Double.TYPE) {
                return Arrays.toString((double[])kvValue);
            }
            if (type.getComponentType() == Float.TYPE) {
                return Arrays.toString((float[])kvValue);
            }
            if (type.getComponentType() == Integer.TYPE) {
                return Arrays.toString((int[])kvValue);
            }
            if (type.getComponentType() == Long.TYPE) {
                return Arrays.toString((long[])kvValue);
            }
            if (type.getComponentType() == Short.TYPE) {
                return Arrays.toString((short[])kvValue);
            }
            return Arrays.toString((Object[])kvValue);
        }
        return String.valueOf(kvValue);
    }
}

