/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.tools.read;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import shaded.parquet.com.fasterxml.jackson.databind.ObjectMapper;
import shaded.parquet.com.fasterxml.jackson.databind.node.BinaryNode;

public class SimpleRecord {
    protected final List<NameValue> values = new ArrayList<NameValue>();

    public void add(String name, Object value) {
        this.values.add(new NameValue(name, value));
    }

    public List<NameValue> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public String toString() {
        return this.values.toString();
    }

    public void prettyPrint() {
        this.prettyPrint(new PrintWriter(System.out, true));
    }

    public void prettyPrint(PrintWriter out) {
        this.prettyPrint(out, 0);
    }

    public void prettyPrint(PrintWriter out, int depth) {
        for (NameValue value : this.values) {
            out.print(Strings.repeat((String)".", (int)depth));
            out.print(value.getName());
            Object val = value.getValue();
            if (val == null) {
                out.print(" = ");
                out.print("<null>");
            } else if (byte[].class == val.getClass()) {
                out.print(" = ");
                out.print(new BinaryNode((byte[])val).asText());
            } else if (short[].class == val.getClass()) {
                out.print(" = ");
                out.print(Arrays.toString((short[])val));
            } else if (int[].class == val.getClass()) {
                out.print(" = ");
                out.print(Arrays.toString((int[])val));
            } else if (long[].class == val.getClass()) {
                out.print(" = ");
                out.print(Arrays.toString((long[])val));
            } else if (float[].class == val.getClass()) {
                out.print(" = ");
                out.print(Arrays.toString((float[])val));
            } else if (double[].class == val.getClass()) {
                out.print(" = ");
                out.print(Arrays.toString((double[])val));
            } else if (boolean[].class == val.getClass()) {
                out.print(" = ");
                out.print(Arrays.toString((boolean[])val));
            } else if (val.getClass().isArray()) {
                out.print(" = ");
                out.print(Arrays.deepToString((Object[])val));
            } else {
                if (SimpleRecord.class.isAssignableFrom(val.getClass())) {
                    out.println(":");
                    ((SimpleRecord)val).prettyPrint(out, depth + 1);
                    continue;
                }
                out.print(" = ");
                out.print(String.valueOf(val));
            }
            out.println();
        }
    }

    public void prettyPrintJson(PrintWriter out) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        out.write(mapper.writeValueAsString(this.toJsonObject()));
    }

    protected Object toJsonObject() {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (NameValue value : this.values) {
            result.put(value.getName(), SimpleRecord.toJsonValue(value.getValue()));
        }
        return result;
    }

    protected static Object toJsonValue(Object val) {
        if (SimpleRecord.class.isAssignableFrom(val.getClass())) {
            return ((SimpleRecord)val).toJsonObject();
        }
        if (byte[].class == val.getClass()) {
            return new BinaryNode((byte[])val);
        }
        return val;
    }

    public static final class NameValue {
        private final String name;
        private final Object value;

        public NameValue(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return this.name + ": " + this.value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

