/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi;

import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.auth.OAuth;
import okhttp3.OkHttpClient;

public class ApiClientBuilder {
    private String clientID;
    private String refreshToken;
    private String accessToken;
    private String userAgent;
    private OkHttpClient okHttpClient;
    private ApiClient client;

    public ApiClient build() {
        if (this.client == null) {
            this.client = new ApiClient();
        }
        String systemUserAgent = System.getProperty("http.agent");
        if (this.userAgent != null && !this.userAgent.isEmpty()) {
            this.client.setUserAgent(this.userAgent);
        } else if (systemUserAgent != null && !systemUserAgent.isEmpty()) {
            this.client.setUserAgent(systemUserAgent);
        } else {
            this.client.setUserAgent("eve-esi/slack:@goldengnu");
        }
        OAuth auth = (OAuth)this.client.getAuthentication("evesso");
        if (this.clientID != null) {
            if (this.refreshToken != null) {
                auth.setAuth(this.clientID, this.refreshToken);
            } else {
                auth.setClientId(this.clientID);
            }
        }
        if (this.accessToken != null) {
            auth.setAccessToken(this.accessToken);
        }
        if (this.okHttpClient != null) {
            this.client.setHttpClient(this.okHttpClient);
        }
        return this.client;
    }

    public ApiClientBuilder clientID(String clientID) {
        this.clientID = clientID;
        return this;
    }

    public ApiClientBuilder refreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    public ApiClientBuilder accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public ApiClientBuilder userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public ApiClientBuilder okHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
        return this;
    }

    public ApiClientBuilder client(ApiClient client) {
        this.client = client;
        return this;
    }
}

