/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi;

import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class HeaderUtil {
    public static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("[EEE, ]dd MMM yyyy HH:mm[:ss][ zzz][ xxxx]", Locale.ENGLISH);
    private static final String X_PAGES = "X-Pages";
    private static final String EXPIRES = "Expires";

    private HeaderUtil() {
    }

    public static Integer getXPages(Map<String, List<String>> responseHeaders) {
        Integer xPages;
        String header = HeaderUtil.getHeader(responseHeaders, X_PAGES);
        if (header == null) {
            return null;
        }
        try {
            xPages = Integer.valueOf(header);
        }
        catch (NumberFormatException ex) {
            xPages = null;
        }
        return xPages;
    }

    public static OffsetDateTime getExpires(Map<String, List<String>> responseHeaders) {
        String header = HeaderUtil.getHeader(responseHeaders, EXPIRES);
        if (header == null) {
            return null;
        }
        try {
            return ZonedDateTime.parse(header, DATE_FORMAT).toOffsetDateTime();
        }
        catch (DateTimeParseException ex) {
            return null;
        }
    }

    public static String getHeader(Map<String, List<String>> responseHeaders, String header) {
        if (responseHeaders == null) {
            return null;
        }
        for (Map.Entry<String, List<String>> entry : responseHeaders.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(header)) continue;
            List<String> headersList = entry.getValue();
            if (headersList == null || headersList.isEmpty()) break;
            return headersList.get(0);
        }
        return null;
    }
}

