/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.model.AllianceIconsResponse;
import net.troja.eve.esi.model.AllianceResponse;
import okhttp3.Call;

public class AllianceApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AllianceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AllianceApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getAlliancesCall(String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/alliances/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAlliancesValidateBeforeCall(String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        return this.getAlliancesCall(datasource, ifNoneMatch, _callback);
    }

    public List<Integer> getAlliances(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Integer>> localVarResp = this.getAlliancesWithHttpInfo(datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<List<Integer>> getAlliancesWithHttpInfo(String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getAlliancesValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAlliancesAsync(String datasource, String ifNoneMatch, ApiCallback<List<Integer>> _callback) throws ApiException {
        Call localVarCall = this.getAlliancesValidateBeforeCall(datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAlliancesAllianceIdCall(Integer allianceId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alliances/{alliance_id}/".replace("{alliance_id}", this.localVarApiClient.escapeString(allianceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAlliancesAllianceIdValidateBeforeCall(Integer allianceId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (allianceId == null) {
            throw new ApiException("Missing the required parameter 'allianceId' when calling getAlliancesAllianceId(Async)");
        }
        return this.getAlliancesAllianceIdCall(allianceId, datasource, ifNoneMatch, _callback);
    }

    public AllianceResponse getAlliancesAllianceId(Integer allianceId, String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<AllianceResponse> localVarResp = this.getAlliancesAllianceIdWithHttpInfo(allianceId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<AllianceResponse> getAlliancesAllianceIdWithHttpInfo(Integer allianceId, String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getAlliancesAllianceIdValidateBeforeCall(allianceId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<AllianceResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAlliancesAllianceIdAsync(Integer allianceId, String datasource, String ifNoneMatch, ApiCallback<AllianceResponse> _callback) throws ApiException {
        Call localVarCall = this.getAlliancesAllianceIdValidateBeforeCall(allianceId, datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<AllianceResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAlliancesAllianceIdCorporationsCall(Integer allianceId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/alliances/{alliance_id}/corporations/".replace("{alliance_id}", this.localVarApiClient.escapeString(allianceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAlliancesAllianceIdCorporationsValidateBeforeCall(Integer allianceId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (allianceId == null) {
            throw new ApiException("Missing the required parameter 'allianceId' when calling getAlliancesAllianceIdCorporations(Async)");
        }
        return this.getAlliancesAllianceIdCorporationsCall(allianceId, datasource, ifNoneMatch, _callback);
    }

    public List<Integer> getAlliancesAllianceIdCorporations(Integer allianceId, String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Integer>> localVarResp = this.getAlliancesAllianceIdCorporationsWithHttpInfo(allianceId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<List<Integer>> getAlliancesAllianceIdCorporationsWithHttpInfo(Integer allianceId, String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getAlliancesAllianceIdCorporationsValidateBeforeCall(allianceId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAlliancesAllianceIdCorporationsAsync(Integer allianceId, String datasource, String ifNoneMatch, ApiCallback<List<Integer>> _callback) throws ApiException {
        Call localVarCall = this.getAlliancesAllianceIdCorporationsValidateBeforeCall(allianceId, datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAlliancesAllianceIdIconsCall(Integer allianceId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/alliances/{alliance_id}/icons/".replace("{alliance_id}", this.localVarApiClient.escapeString(allianceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAlliancesAllianceIdIconsValidateBeforeCall(Integer allianceId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (allianceId == null) {
            throw new ApiException("Missing the required parameter 'allianceId' when calling getAlliancesAllianceIdIcons(Async)");
        }
        return this.getAlliancesAllianceIdIconsCall(allianceId, datasource, ifNoneMatch, _callback);
    }

    public AllianceIconsResponse getAlliancesAllianceIdIcons(Integer allianceId, String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<AllianceIconsResponse> localVarResp = this.getAlliancesAllianceIdIconsWithHttpInfo(allianceId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<AllianceIconsResponse> getAlliancesAllianceIdIconsWithHttpInfo(Integer allianceId, String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getAlliancesAllianceIdIconsValidateBeforeCall(allianceId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<AllianceIconsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAlliancesAllianceIdIconsAsync(Integer allianceId, String datasource, String ifNoneMatch, ApiCallback<AllianceIconsResponse> _callback) throws ApiException {
        Call localVarCall = this.getAlliancesAllianceIdIconsValidateBeforeCall(allianceId, datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<AllianceIconsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

