/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.model.CharacterFleetResponse;
import net.troja.eve.esi.model.FleetInvitation;
import net.troja.eve.esi.model.FleetMemberMovement;
import net.troja.eve.esi.model.FleetMembersResponse;
import net.troja.eve.esi.model.FleetNewSettings;
import net.troja.eve.esi.model.FleetResponse;
import net.troja.eve.esi.model.FleetSquadCreatedResponse;
import net.troja.eve.esi.model.FleetSquadNaming;
import net.troja.eve.esi.model.FleetWingCreatedResponse;
import net.troja.eve.esi.model.FleetWingNaming;
import net.troja.eve.esi.model.FleetWingsResponse;
import okhttp3.Call;

public class FleetsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public FleetsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FleetsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call deleteFleetsFleetIdMembersMemberIdCall(Long fleetId, Integer memberId, String datasource, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/fleets/{fleet_id}/members/{member_id}/".replace("{fleet_id}", this.localVarApiClient.escapeString(fleetId.toString())).replace("{member_id}", this.localVarApiClient.escapeString(memberId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[0])) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteFleetsFleetIdMembersMemberIdValidateBeforeCall(Long fleetId, Integer memberId, String datasource, String token, ApiCallback _callback) throws ApiException {
        if (fleetId == null) {
            throw new ApiException("Missing the required parameter 'fleetId' when calling deleteFleetsFleetIdMembersMemberId(Async)");
        }
        if (memberId == null) {
            throw new ApiException("Missing the required parameter 'memberId' when calling deleteFleetsFleetIdMembersMemberId(Async)");
        }
        return this.deleteFleetsFleetIdMembersMemberIdCall(fleetId, memberId, datasource, token, _callback);
    }

    public void deleteFleetsFleetIdMembersMemberId(Long fleetId, Integer memberId, String datasource, String token) throws ApiException {
        this.deleteFleetsFleetIdMembersMemberIdWithHttpInfo(fleetId, memberId, datasource, token);
    }

    public ApiResponse<Void> deleteFleetsFleetIdMembersMemberIdWithHttpInfo(Long fleetId, Integer memberId, String datasource, String token) throws ApiException {
        Call localVarCall = this.deleteFleetsFleetIdMembersMemberIdValidateBeforeCall(fleetId, memberId, datasource, token, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteFleetsFleetIdMembersMemberIdAsync(Long fleetId, Integer memberId, String datasource, String token, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteFleetsFleetIdMembersMemberIdValidateBeforeCall(fleetId, memberId, datasource, token, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteFleetsFleetIdSquadsSquadIdCall(Long fleetId, Long squadId, String datasource, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/fleets/{fleet_id}/squads/{squad_id}/".replace("{fleet_id}", this.localVarApiClient.escapeString(fleetId.toString())).replace("{squad_id}", this.localVarApiClient.escapeString(squadId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[0])) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteFleetsFleetIdSquadsSquadIdValidateBeforeCall(Long fleetId, Long squadId, String datasource, String token, ApiCallback _callback) throws ApiException {
        if (fleetId == null) {
            throw new ApiException("Missing the required parameter 'fleetId' when calling deleteFleetsFleetIdSquadsSquadId(Async)");
        }
        if (squadId == null) {
            throw new ApiException("Missing the required parameter 'squadId' when calling deleteFleetsFleetIdSquadsSquadId(Async)");
        }
        return this.deleteFleetsFleetIdSquadsSquadIdCall(fleetId, squadId, datasource, token, _callback);
    }

    public void deleteFleetsFleetIdSquadsSquadId(Long fleetId, Long squadId, String datasource, String token) throws ApiException {
        this.deleteFleetsFleetIdSquadsSquadIdWithHttpInfo(fleetId, squadId, datasource, token);
    }

    public ApiResponse<Void> deleteFleetsFleetIdSquadsSquadIdWithHttpInfo(Long fleetId, Long squadId, String datasource, String token) throws ApiException {
        Call localVarCall = this.deleteFleetsFleetIdSquadsSquadIdValidateBeforeCall(fleetId, squadId, datasource, token, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteFleetsFleetIdSquadsSquadIdAsync(Long fleetId, Long squadId, String datasource, String token, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteFleetsFleetIdSquadsSquadIdValidateBeforeCall(fleetId, squadId, datasource, token, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteFleetsFleetIdWingsWingIdCall(Long fleetId, Long wingId, String datasource, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/fleets/{fleet_id}/wings/{wing_id}/".replace("{fleet_id}", this.localVarApiClient.escapeString(fleetId.toString())).replace("{wing_id}", this.localVarApiClient.escapeString(wingId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[0])) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteFleetsFleetIdWingsWingIdValidateBeforeCall(Long fleetId, Long wingId, String datasource, String token, ApiCallback _callback) throws ApiException {
        if (fleetId == null) {
            throw new ApiException("Missing the required parameter 'fleetId' when calling deleteFleetsFleetIdWingsWingId(Async)");
        }
        if (wingId == null) {
            throw new ApiException("Missing the required parameter 'wingId' when calling deleteFleetsFleetIdWingsWingId(Async)");
        }
        return this.deleteFleetsFleetIdWingsWingIdCall(fleetId, wingId, datasource, token, _callback);
    }

    public void deleteFleetsFleetIdWingsWingId(Long fleetId, Long wingId, String datasource, String token) throws ApiException {
        this.deleteFleetsFleetIdWingsWingIdWithHttpInfo(fleetId, wingId, datasource, token);
    }

    public ApiResponse<Void> deleteFleetsFleetIdWingsWingIdWithHttpInfo(Long fleetId, Long wingId, String datasource, String token) throws ApiException {
        Call localVarCall = this.deleteFleetsFleetIdWingsWingIdValidateBeforeCall(fleetId, wingId, datasource, token, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteFleetsFleetIdWingsWingIdAsync(Long fleetId, Long wingId, String datasource, String token, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteFleetsFleetIdWingsWingIdValidateBeforeCall(fleetId, wingId, datasource, token, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getCharactersCharacterIdFleetCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/characters/{character_id}/fleet/".replace("{character_id}", this.localVarApiClient.escapeString(characterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCharactersCharacterIdFleetValidateBeforeCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (characterId == null) {
            throw new ApiException("Missing the required parameter 'characterId' when calling getCharactersCharacterIdFleet(Async)");
        }
        return this.getCharactersCharacterIdFleetCall(characterId, datasource, ifNoneMatch, token, _callback);
    }

    public CharacterFleetResponse getCharactersCharacterIdFleet(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<CharacterFleetResponse> localVarResp = this.getCharactersCharacterIdFleetWithHttpInfo(characterId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<CharacterFleetResponse> getCharactersCharacterIdFleetWithHttpInfo(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdFleetValidateBeforeCall(characterId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<CharacterFleetResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCharactersCharacterIdFleetAsync(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback<CharacterFleetResponse> _callback) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdFleetValidateBeforeCall(characterId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<CharacterFleetResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getFleetsFleetIdCall(Long fleetId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/fleets/{fleet_id}/".replace("{fleet_id}", this.localVarApiClient.escapeString(fleetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFleetsFleetIdValidateBeforeCall(Long fleetId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (fleetId == null) {
            throw new ApiException("Missing the required parameter 'fleetId' when calling getFleetsFleetId(Async)");
        }
        return this.getFleetsFleetIdCall(fleetId, datasource, ifNoneMatch, token, _callback);
    }

    public FleetResponse getFleetsFleetId(Long fleetId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<FleetResponse> localVarResp = this.getFleetsFleetIdWithHttpInfo(fleetId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<FleetResponse> getFleetsFleetIdWithHttpInfo(Long fleetId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getFleetsFleetIdValidateBeforeCall(fleetId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<FleetResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getFleetsFleetIdAsync(Long fleetId, String datasource, String ifNoneMatch, String token, ApiCallback<FleetResponse> _callback) throws ApiException {
        Call localVarCall = this.getFleetsFleetIdValidateBeforeCall(fleetId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<FleetResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getFleetsFleetIdMembersCall(Long fleetId, String acceptLanguage, String datasource, String ifNoneMatch, String language, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/fleets/{fleet_id}/members/".replace("{fleet_id}", this.localVarApiClient.escapeString(fleetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (language != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("language", language));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", this.localVarApiClient.parameterToString(acceptLanguage));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFleetsFleetIdMembersValidateBeforeCall(Long fleetId, String acceptLanguage, String datasource, String ifNoneMatch, String language, String token, ApiCallback _callback) throws ApiException {
        if (fleetId == null) {
            throw new ApiException("Missing the required parameter 'fleetId' when calling getFleetsFleetIdMembers(Async)");
        }
        return this.getFleetsFleetIdMembersCall(fleetId, acceptLanguage, datasource, ifNoneMatch, language, token, _callback);
    }

    public List<FleetMembersResponse> getFleetsFleetIdMembers(Long fleetId, String acceptLanguage, String datasource, String ifNoneMatch, String language, String token) throws ApiException {
        ApiResponse<List<FleetMembersResponse>> localVarResp = this.getFleetsFleetIdMembersWithHttpInfo(fleetId, acceptLanguage, datasource, ifNoneMatch, language, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<FleetMembersResponse>> getFleetsFleetIdMembersWithHttpInfo(Long fleetId, String acceptLanguage, String datasource, String ifNoneMatch, String language, String token) throws ApiException {
        Call localVarCall = this.getFleetsFleetIdMembersValidateBeforeCall(fleetId, acceptLanguage, datasource, ifNoneMatch, language, token, null);
        Type localVarReturnType = new TypeToken<List<FleetMembersResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getFleetsFleetIdMembersAsync(Long fleetId, String acceptLanguage, String datasource, String ifNoneMatch, String language, String token, ApiCallback<List<FleetMembersResponse>> _callback) throws ApiException {
        Call localVarCall = this.getFleetsFleetIdMembersValidateBeforeCall(fleetId, acceptLanguage, datasource, ifNoneMatch, language, token, _callback);
        Type localVarReturnType = new TypeToken<List<FleetMembersResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getFleetsFleetIdWingsCall(Long fleetId, String acceptLanguage, String datasource, String ifNoneMatch, String language, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/fleets/{fleet_id}/wings/".replace("{fleet_id}", this.localVarApiClient.escapeString(fleetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (language != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("language", language));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", this.localVarApiClient.parameterToString(acceptLanguage));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFleetsFleetIdWingsValidateBeforeCall(Long fleetId, String acceptLanguage, String datasource, String ifNoneMatch, String language, String token, ApiCallback _callback) throws ApiException {
        if (fleetId == null) {
            throw new ApiException("Missing the required parameter 'fleetId' when calling getFleetsFleetIdWings(Async)");
        }
        return this.getFleetsFleetIdWingsCall(fleetId, acceptLanguage, datasource, ifNoneMatch, language, token, _callback);
    }

    public List<FleetWingsResponse> getFleetsFleetIdWings(Long fleetId, String acceptLanguage, String datasource, String ifNoneMatch, String language, String token) throws ApiException {
        ApiResponse<List<FleetWingsResponse>> localVarResp = this.getFleetsFleetIdWingsWithHttpInfo(fleetId, acceptLanguage, datasource, ifNoneMatch, language, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<FleetWingsResponse>> getFleetsFleetIdWingsWithHttpInfo(Long fleetId, String acceptLanguage, String datasource, String ifNoneMatch, String language, String token) throws ApiException {
        Call localVarCall = this.getFleetsFleetIdWingsValidateBeforeCall(fleetId, acceptLanguage, datasource, ifNoneMatch, language, token, null);
        Type localVarReturnType = new TypeToken<List<FleetWingsResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getFleetsFleetIdWingsAsync(Long fleetId, String acceptLanguage, String datasource, String ifNoneMatch, String language, String token, ApiCallback<List<FleetWingsResponse>> _callback) throws ApiException {
        Call localVarCall = this.getFleetsFleetIdWingsValidateBeforeCall(fleetId, acceptLanguage, datasource, ifNoneMatch, language, token, _callback);
        Type localVarReturnType = new TypeToken<List<FleetWingsResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postFleetsFleetIdMembersCall(Long fleetId, FleetInvitation invitation, String datasource, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FleetInvitation localVarPostBody = invitation;
        String localVarPath = "/v1/fleets/{fleet_id}/members/".replace("{fleet_id}", this.localVarApiClient.escapeString(fleetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[0])) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postFleetsFleetIdMembersValidateBeforeCall(Long fleetId, FleetInvitation invitation, String datasource, String token, ApiCallback _callback) throws ApiException {
        if (fleetId == null) {
            throw new ApiException("Missing the required parameter 'fleetId' when calling postFleetsFleetIdMembers(Async)");
        }
        if (invitation == null) {
            throw new ApiException("Missing the required parameter 'invitation' when calling postFleetsFleetIdMembers(Async)");
        }
        return this.postFleetsFleetIdMembersCall(fleetId, invitation, datasource, token, _callback);
    }

    public void postFleetsFleetIdMembers(Long fleetId, FleetInvitation invitation, String datasource, String token) throws ApiException {
        this.postFleetsFleetIdMembersWithHttpInfo(fleetId, invitation, datasource, token);
    }

    public ApiResponse<Void> postFleetsFleetIdMembersWithHttpInfo(Long fleetId, FleetInvitation invitation, String datasource, String token) throws ApiException {
        Call localVarCall = this.postFleetsFleetIdMembersValidateBeforeCall(fleetId, invitation, datasource, token, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call postFleetsFleetIdMembersAsync(Long fleetId, FleetInvitation invitation, String datasource, String token, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.postFleetsFleetIdMembersValidateBeforeCall(fleetId, invitation, datasource, token, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call postFleetsFleetIdWingsCall(Long fleetId, String datasource, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/fleets/{fleet_id}/wings/".replace("{fleet_id}", this.localVarApiClient.escapeString(fleetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postFleetsFleetIdWingsValidateBeforeCall(Long fleetId, String datasource, String token, ApiCallback _callback) throws ApiException {
        if (fleetId == null) {
            throw new ApiException("Missing the required parameter 'fleetId' when calling postFleetsFleetIdWings(Async)");
        }
        return this.postFleetsFleetIdWingsCall(fleetId, datasource, token, _callback);
    }

    public FleetWingCreatedResponse postFleetsFleetIdWings(Long fleetId, String datasource, String token) throws ApiException {
        ApiResponse<FleetWingCreatedResponse> localVarResp = this.postFleetsFleetIdWingsWithHttpInfo(fleetId, datasource, token);
        return localVarResp.getData();
    }

    public ApiResponse<FleetWingCreatedResponse> postFleetsFleetIdWingsWithHttpInfo(Long fleetId, String datasource, String token) throws ApiException {
        Call localVarCall = this.postFleetsFleetIdWingsValidateBeforeCall(fleetId, datasource, token, null);
        Type localVarReturnType = new TypeToken<FleetWingCreatedResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postFleetsFleetIdWingsAsync(Long fleetId, String datasource, String token, ApiCallback<FleetWingCreatedResponse> _callback) throws ApiException {
        Call localVarCall = this.postFleetsFleetIdWingsValidateBeforeCall(fleetId, datasource, token, _callback);
        Type localVarReturnType = new TypeToken<FleetWingCreatedResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postFleetsFleetIdWingsWingIdSquadsCall(Long fleetId, Long wingId, String datasource, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/fleets/{fleet_id}/wings/{wing_id}/squads/".replace("{fleet_id}", this.localVarApiClient.escapeString(fleetId.toString())).replace("{wing_id}", this.localVarApiClient.escapeString(wingId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postFleetsFleetIdWingsWingIdSquadsValidateBeforeCall(Long fleetId, Long wingId, String datasource, String token, ApiCallback _callback) throws ApiException {
        if (fleetId == null) {
            throw new ApiException("Missing the required parameter 'fleetId' when calling postFleetsFleetIdWingsWingIdSquads(Async)");
        }
        if (wingId == null) {
            throw new ApiException("Missing the required parameter 'wingId' when calling postFleetsFleetIdWingsWingIdSquads(Async)");
        }
        return this.postFleetsFleetIdWingsWingIdSquadsCall(fleetId, wingId, datasource, token, _callback);
    }

    public FleetSquadCreatedResponse postFleetsFleetIdWingsWingIdSquads(Long fleetId, Long wingId, String datasource, String token) throws ApiException {
        ApiResponse<FleetSquadCreatedResponse> localVarResp = this.postFleetsFleetIdWingsWingIdSquadsWithHttpInfo(fleetId, wingId, datasource, token);
        return localVarResp.getData();
    }

    public ApiResponse<FleetSquadCreatedResponse> postFleetsFleetIdWingsWingIdSquadsWithHttpInfo(Long fleetId, Long wingId, String datasource, String token) throws ApiException {
        Call localVarCall = this.postFleetsFleetIdWingsWingIdSquadsValidateBeforeCall(fleetId, wingId, datasource, token, null);
        Type localVarReturnType = new TypeToken<FleetSquadCreatedResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postFleetsFleetIdWingsWingIdSquadsAsync(Long fleetId, Long wingId, String datasource, String token, ApiCallback<FleetSquadCreatedResponse> _callback) throws ApiException {
        Call localVarCall = this.postFleetsFleetIdWingsWingIdSquadsValidateBeforeCall(fleetId, wingId, datasource, token, _callback);
        Type localVarReturnType = new TypeToken<FleetSquadCreatedResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call putFleetsFleetIdCall(Long fleetId, FleetNewSettings newSettings, String datasource, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FleetNewSettings localVarPostBody = newSettings;
        String localVarPath = "/v1/fleets/{fleet_id}/".replace("{fleet_id}", this.localVarApiClient.escapeString(fleetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[0])) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call putFleetsFleetIdValidateBeforeCall(Long fleetId, FleetNewSettings newSettings, String datasource, String token, ApiCallback _callback) throws ApiException {
        if (fleetId == null) {
            throw new ApiException("Missing the required parameter 'fleetId' when calling putFleetsFleetId(Async)");
        }
        if (newSettings == null) {
            throw new ApiException("Missing the required parameter 'newSettings' when calling putFleetsFleetId(Async)");
        }
        return this.putFleetsFleetIdCall(fleetId, newSettings, datasource, token, _callback);
    }

    public void putFleetsFleetId(Long fleetId, FleetNewSettings newSettings, String datasource, String token) throws ApiException {
        this.putFleetsFleetIdWithHttpInfo(fleetId, newSettings, datasource, token);
    }

    public ApiResponse<Void> putFleetsFleetIdWithHttpInfo(Long fleetId, FleetNewSettings newSettings, String datasource, String token) throws ApiException {
        Call localVarCall = this.putFleetsFleetIdValidateBeforeCall(fleetId, newSettings, datasource, token, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call putFleetsFleetIdAsync(Long fleetId, FleetNewSettings newSettings, String datasource, String token, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.putFleetsFleetIdValidateBeforeCall(fleetId, newSettings, datasource, token, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call putFleetsFleetIdMembersMemberIdCall(Long fleetId, Integer memberId, FleetMemberMovement movement, String datasource, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FleetMemberMovement localVarPostBody = movement;
        String localVarPath = "/v1/fleets/{fleet_id}/members/{member_id}/".replace("{fleet_id}", this.localVarApiClient.escapeString(fleetId.toString())).replace("{member_id}", this.localVarApiClient.escapeString(memberId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[0])) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call putFleetsFleetIdMembersMemberIdValidateBeforeCall(Long fleetId, Integer memberId, FleetMemberMovement movement, String datasource, String token, ApiCallback _callback) throws ApiException {
        if (fleetId == null) {
            throw new ApiException("Missing the required parameter 'fleetId' when calling putFleetsFleetIdMembersMemberId(Async)");
        }
        if (memberId == null) {
            throw new ApiException("Missing the required parameter 'memberId' when calling putFleetsFleetIdMembersMemberId(Async)");
        }
        if (movement == null) {
            throw new ApiException("Missing the required parameter 'movement' when calling putFleetsFleetIdMembersMemberId(Async)");
        }
        return this.putFleetsFleetIdMembersMemberIdCall(fleetId, memberId, movement, datasource, token, _callback);
    }

    public void putFleetsFleetIdMembersMemberId(Long fleetId, Integer memberId, FleetMemberMovement movement, String datasource, String token) throws ApiException {
        this.putFleetsFleetIdMembersMemberIdWithHttpInfo(fleetId, memberId, movement, datasource, token);
    }

    public ApiResponse<Void> putFleetsFleetIdMembersMemberIdWithHttpInfo(Long fleetId, Integer memberId, FleetMemberMovement movement, String datasource, String token) throws ApiException {
        Call localVarCall = this.putFleetsFleetIdMembersMemberIdValidateBeforeCall(fleetId, memberId, movement, datasource, token, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call putFleetsFleetIdMembersMemberIdAsync(Long fleetId, Integer memberId, FleetMemberMovement movement, String datasource, String token, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.putFleetsFleetIdMembersMemberIdValidateBeforeCall(fleetId, memberId, movement, datasource, token, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call putFleetsFleetIdSquadsSquadIdCall(Long fleetId, Long squadId, FleetSquadNaming naming, String datasource, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FleetSquadNaming localVarPostBody = naming;
        String localVarPath = "/v1/fleets/{fleet_id}/squads/{squad_id}/".replace("{fleet_id}", this.localVarApiClient.escapeString(fleetId.toString())).replace("{squad_id}", this.localVarApiClient.escapeString(squadId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[0])) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call putFleetsFleetIdSquadsSquadIdValidateBeforeCall(Long fleetId, Long squadId, FleetSquadNaming naming, String datasource, String token, ApiCallback _callback) throws ApiException {
        if (fleetId == null) {
            throw new ApiException("Missing the required parameter 'fleetId' when calling putFleetsFleetIdSquadsSquadId(Async)");
        }
        if (squadId == null) {
            throw new ApiException("Missing the required parameter 'squadId' when calling putFleetsFleetIdSquadsSquadId(Async)");
        }
        if (naming == null) {
            throw new ApiException("Missing the required parameter 'naming' when calling putFleetsFleetIdSquadsSquadId(Async)");
        }
        return this.putFleetsFleetIdSquadsSquadIdCall(fleetId, squadId, naming, datasource, token, _callback);
    }

    public void putFleetsFleetIdSquadsSquadId(Long fleetId, Long squadId, FleetSquadNaming naming, String datasource, String token) throws ApiException {
        this.putFleetsFleetIdSquadsSquadIdWithHttpInfo(fleetId, squadId, naming, datasource, token);
    }

    public ApiResponse<Void> putFleetsFleetIdSquadsSquadIdWithHttpInfo(Long fleetId, Long squadId, FleetSquadNaming naming, String datasource, String token) throws ApiException {
        Call localVarCall = this.putFleetsFleetIdSquadsSquadIdValidateBeforeCall(fleetId, squadId, naming, datasource, token, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call putFleetsFleetIdSquadsSquadIdAsync(Long fleetId, Long squadId, FleetSquadNaming naming, String datasource, String token, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.putFleetsFleetIdSquadsSquadIdValidateBeforeCall(fleetId, squadId, naming, datasource, token, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call putFleetsFleetIdWingsWingIdCall(Long fleetId, Long wingId, FleetWingNaming naming, String datasource, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FleetWingNaming localVarPostBody = naming;
        String localVarPath = "/v1/fleets/{fleet_id}/wings/{wing_id}/".replace("{fleet_id}", this.localVarApiClient.escapeString(fleetId.toString())).replace("{wing_id}", this.localVarApiClient.escapeString(wingId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[0])) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call putFleetsFleetIdWingsWingIdValidateBeforeCall(Long fleetId, Long wingId, FleetWingNaming naming, String datasource, String token, ApiCallback _callback) throws ApiException {
        if (fleetId == null) {
            throw new ApiException("Missing the required parameter 'fleetId' when calling putFleetsFleetIdWingsWingId(Async)");
        }
        if (wingId == null) {
            throw new ApiException("Missing the required parameter 'wingId' when calling putFleetsFleetIdWingsWingId(Async)");
        }
        if (naming == null) {
            throw new ApiException("Missing the required parameter 'naming' when calling putFleetsFleetIdWingsWingId(Async)");
        }
        return this.putFleetsFleetIdWingsWingIdCall(fleetId, wingId, naming, datasource, token, _callback);
    }

    public void putFleetsFleetIdWingsWingId(Long fleetId, Long wingId, FleetWingNaming naming, String datasource, String token) throws ApiException {
        this.putFleetsFleetIdWingsWingIdWithHttpInfo(fleetId, wingId, naming, datasource, token);
    }

    public ApiResponse<Void> putFleetsFleetIdWingsWingIdWithHttpInfo(Long fleetId, Long wingId, FleetWingNaming naming, String datasource, String token) throws ApiException {
        Call localVarCall = this.putFleetsFleetIdWingsWingIdValidateBeforeCall(fleetId, wingId, naming, datasource, token, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call putFleetsFleetIdWingsWingIdAsync(Long fleetId, Long wingId, FleetWingNaming naming, String datasource, String token, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.putFleetsFleetIdWingsWingIdValidateBeforeCall(fleetId, wingId, naming, datasource, token, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

