/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.model.CharacterOrdersHistoryResponse;
import net.troja.eve.esi.model.CharacterOrdersResponse;
import net.troja.eve.esi.model.CorporationOrdersHistoryResponse;
import net.troja.eve.esi.model.CorporationOrdersResponse;
import net.troja.eve.esi.model.MarketGroupResponse;
import net.troja.eve.esi.model.MarketHistoryResponse;
import net.troja.eve.esi.model.MarketOrdersResponse;
import net.troja.eve.esi.model.MarketPricesResponse;
import net.troja.eve.esi.model.MarketStructuresResponse;
import okhttp3.Call;

public class MarketApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public MarketApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MarketApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getCharactersCharacterIdOrdersCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/characters/{character_id}/orders/".replace("{character_id}", this.localVarApiClient.escapeString(characterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCharactersCharacterIdOrdersValidateBeforeCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (characterId == null) {
            throw new ApiException("Missing the required parameter 'characterId' when calling getCharactersCharacterIdOrders(Async)");
        }
        return this.getCharactersCharacterIdOrdersCall(characterId, datasource, ifNoneMatch, token, _callback);
    }

    public List<CharacterOrdersResponse> getCharactersCharacterIdOrders(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CharacterOrdersResponse>> localVarResp = this.getCharactersCharacterIdOrdersWithHttpInfo(characterId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CharacterOrdersResponse>> getCharactersCharacterIdOrdersWithHttpInfo(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdOrdersValidateBeforeCall(characterId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterOrdersResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCharactersCharacterIdOrdersAsync(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback<List<CharacterOrdersResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdOrdersValidateBeforeCall(characterId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<List<CharacterOrdersResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCharactersCharacterIdOrdersHistoryCall(Integer characterId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/characters/{character_id}/orders/history/".replace("{character_id}", this.localVarApiClient.escapeString(characterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCharactersCharacterIdOrdersHistoryValidateBeforeCall(Integer characterId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        if (characterId == null) {
            throw new ApiException("Missing the required parameter 'characterId' when calling getCharactersCharacterIdOrdersHistory(Async)");
        }
        return this.getCharactersCharacterIdOrdersHistoryCall(characterId, datasource, ifNoneMatch, page, token, _callback);
    }

    public List<CharacterOrdersHistoryResponse> getCharactersCharacterIdOrdersHistory(Integer characterId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CharacterOrdersHistoryResponse>> localVarResp = this.getCharactersCharacterIdOrdersHistoryWithHttpInfo(characterId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CharacterOrdersHistoryResponse>> getCharactersCharacterIdOrdersHistoryWithHttpInfo(Integer characterId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdOrdersHistoryValidateBeforeCall(characterId, datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterOrdersHistoryResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCharactersCharacterIdOrdersHistoryAsync(Integer characterId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback<List<CharacterOrdersHistoryResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdOrdersHistoryValidateBeforeCall(characterId, datasource, ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CharacterOrdersHistoryResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdOrdersCall(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/corporations/{corporation_id}/orders/".replace("{corporation_id}", this.localVarApiClient.escapeString(corporationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdOrdersValidateBeforeCall(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdOrders(Async)");
        }
        return this.getCorporationsCorporationIdOrdersCall(corporationId, datasource, ifNoneMatch, page, token, _callback);
    }

    public List<CorporationOrdersResponse> getCorporationsCorporationIdOrders(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationOrdersResponse>> localVarResp = this.getCorporationsCorporationIdOrdersWithHttpInfo(corporationId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CorporationOrdersResponse>> getCorporationsCorporationIdOrdersWithHttpInfo(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdOrdersValidateBeforeCall(corporationId, datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationOrdersResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdOrdersAsync(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback<List<CorporationOrdersResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdOrdersValidateBeforeCall(corporationId, datasource, ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationOrdersResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdOrdersHistoryCall(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/corporations/{corporation_id}/orders/history/".replace("{corporation_id}", this.localVarApiClient.escapeString(corporationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdOrdersHistoryValidateBeforeCall(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdOrdersHistory(Async)");
        }
        return this.getCorporationsCorporationIdOrdersHistoryCall(corporationId, datasource, ifNoneMatch, page, token, _callback);
    }

    public List<CorporationOrdersHistoryResponse> getCorporationsCorporationIdOrdersHistory(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationOrdersHistoryResponse>> localVarResp = this.getCorporationsCorporationIdOrdersHistoryWithHttpInfo(corporationId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CorporationOrdersHistoryResponse>> getCorporationsCorporationIdOrdersHistoryWithHttpInfo(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdOrdersHistoryValidateBeforeCall(corporationId, datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationOrdersHistoryResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdOrdersHistoryAsync(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback<List<CorporationOrdersHistoryResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdOrdersHistoryValidateBeforeCall(corporationId, datasource, ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationOrdersHistoryResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMarketsGroupsCall(String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/markets/groups/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMarketsGroupsValidateBeforeCall(String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        return this.getMarketsGroupsCall(datasource, ifNoneMatch, _callback);
    }

    public List<Integer> getMarketsGroups(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Integer>> localVarResp = this.getMarketsGroupsWithHttpInfo(datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<List<Integer>> getMarketsGroupsWithHttpInfo(String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getMarketsGroupsValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMarketsGroupsAsync(String datasource, String ifNoneMatch, ApiCallback<List<Integer>> _callback) throws ApiException {
        Call localVarCall = this.getMarketsGroupsValidateBeforeCall(datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMarketsGroupsMarketGroupIdCall(Integer marketGroupId, String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/markets/groups/{market_group_id}/".replace("{market_group_id}", this.localVarApiClient.escapeString(marketGroupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (language != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("language", language));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", this.localVarApiClient.parameterToString(acceptLanguage));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMarketsGroupsMarketGroupIdValidateBeforeCall(Integer marketGroupId, String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback _callback) throws ApiException {
        if (marketGroupId == null) {
            throw new ApiException("Missing the required parameter 'marketGroupId' when calling getMarketsGroupsMarketGroupId(Async)");
        }
        return this.getMarketsGroupsMarketGroupIdCall(marketGroupId, acceptLanguage, datasource, ifNoneMatch, language, _callback);
    }

    public MarketGroupResponse getMarketsGroupsMarketGroupId(Integer marketGroupId, String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        ApiResponse<MarketGroupResponse> localVarResp = this.getMarketsGroupsMarketGroupIdWithHttpInfo(marketGroupId, acceptLanguage, datasource, ifNoneMatch, language);
        return localVarResp.getData();
    }

    public ApiResponse<MarketGroupResponse> getMarketsGroupsMarketGroupIdWithHttpInfo(Integer marketGroupId, String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        Call localVarCall = this.getMarketsGroupsMarketGroupIdValidateBeforeCall(marketGroupId, acceptLanguage, datasource, ifNoneMatch, language, null);
        Type localVarReturnType = new TypeToken<MarketGroupResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMarketsGroupsMarketGroupIdAsync(Integer marketGroupId, String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback<MarketGroupResponse> _callback) throws ApiException {
        Call localVarCall = this.getMarketsGroupsMarketGroupIdValidateBeforeCall(marketGroupId, acceptLanguage, datasource, ifNoneMatch, language, _callback);
        Type localVarReturnType = new TypeToken<MarketGroupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMarketsPricesCall(String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/markets/prices/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMarketsPricesValidateBeforeCall(String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        return this.getMarketsPricesCall(datasource, ifNoneMatch, _callback);
    }

    public List<MarketPricesResponse> getMarketsPrices(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<MarketPricesResponse>> localVarResp = this.getMarketsPricesWithHttpInfo(datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<List<MarketPricesResponse>> getMarketsPricesWithHttpInfo(String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getMarketsPricesValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<MarketPricesResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMarketsPricesAsync(String datasource, String ifNoneMatch, ApiCallback<List<MarketPricesResponse>> _callback) throws ApiException {
        Call localVarCall = this.getMarketsPricesValidateBeforeCall(datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<MarketPricesResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMarketsRegionIdHistoryCall(Integer regionId, Integer typeId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/markets/{region_id}/history/".replace("{region_id}", this.localVarApiClient.escapeString(regionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (typeId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type_id", typeId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMarketsRegionIdHistoryValidateBeforeCall(Integer regionId, Integer typeId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (regionId == null) {
            throw new ApiException("Missing the required parameter 'regionId' when calling getMarketsRegionIdHistory(Async)");
        }
        if (typeId == null) {
            throw new ApiException("Missing the required parameter 'typeId' when calling getMarketsRegionIdHistory(Async)");
        }
        return this.getMarketsRegionIdHistoryCall(regionId, typeId, datasource, ifNoneMatch, _callback);
    }

    public List<MarketHistoryResponse> getMarketsRegionIdHistory(Integer regionId, Integer typeId, String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<MarketHistoryResponse>> localVarResp = this.getMarketsRegionIdHistoryWithHttpInfo(regionId, typeId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<List<MarketHistoryResponse>> getMarketsRegionIdHistoryWithHttpInfo(Integer regionId, Integer typeId, String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getMarketsRegionIdHistoryValidateBeforeCall(regionId, typeId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<MarketHistoryResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMarketsRegionIdHistoryAsync(Integer regionId, Integer typeId, String datasource, String ifNoneMatch, ApiCallback<List<MarketHistoryResponse>> _callback) throws ApiException {
        Call localVarCall = this.getMarketsRegionIdHistoryValidateBeforeCall(regionId, typeId, datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<MarketHistoryResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMarketsRegionIdOrdersCall(String orderType, Integer regionId, String datasource, String ifNoneMatch, Integer page, Integer typeId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/markets/{region_id}/orders/".replace("{region_id}", this.localVarApiClient.escapeString(regionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (orderType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("order_type", orderType));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (typeId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type_id", typeId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMarketsRegionIdOrdersValidateBeforeCall(String orderType, Integer regionId, String datasource, String ifNoneMatch, Integer page, Integer typeId, ApiCallback _callback) throws ApiException {
        if (orderType == null) {
            throw new ApiException("Missing the required parameter 'orderType' when calling getMarketsRegionIdOrders(Async)");
        }
        if (regionId == null) {
            throw new ApiException("Missing the required parameter 'regionId' when calling getMarketsRegionIdOrders(Async)");
        }
        return this.getMarketsRegionIdOrdersCall(orderType, regionId, datasource, ifNoneMatch, page, typeId, _callback);
    }

    public List<MarketOrdersResponse> getMarketsRegionIdOrders(String orderType, Integer regionId, String datasource, String ifNoneMatch, Integer page, Integer typeId) throws ApiException {
        ApiResponse<List<MarketOrdersResponse>> localVarResp = this.getMarketsRegionIdOrdersWithHttpInfo(orderType, regionId, datasource, ifNoneMatch, page, typeId);
        return localVarResp.getData();
    }

    public ApiResponse<List<MarketOrdersResponse>> getMarketsRegionIdOrdersWithHttpInfo(String orderType, Integer regionId, String datasource, String ifNoneMatch, Integer page, Integer typeId) throws ApiException {
        Call localVarCall = this.getMarketsRegionIdOrdersValidateBeforeCall(orderType, regionId, datasource, ifNoneMatch, page, typeId, null);
        Type localVarReturnType = new TypeToken<List<MarketOrdersResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMarketsRegionIdOrdersAsync(String orderType, Integer regionId, String datasource, String ifNoneMatch, Integer page, Integer typeId, ApiCallback<List<MarketOrdersResponse>> _callback) throws ApiException {
        Call localVarCall = this.getMarketsRegionIdOrdersValidateBeforeCall(orderType, regionId, datasource, ifNoneMatch, page, typeId, _callback);
        Type localVarReturnType = new TypeToken<List<MarketOrdersResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMarketsRegionIdTypesCall(Integer regionId, String datasource, String ifNoneMatch, Integer page, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/markets/{region_id}/types/".replace("{region_id}", this.localVarApiClient.escapeString(regionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMarketsRegionIdTypesValidateBeforeCall(Integer regionId, String datasource, String ifNoneMatch, Integer page, ApiCallback _callback) throws ApiException {
        if (regionId == null) {
            throw new ApiException("Missing the required parameter 'regionId' when calling getMarketsRegionIdTypes(Async)");
        }
        return this.getMarketsRegionIdTypesCall(regionId, datasource, ifNoneMatch, page, _callback);
    }

    public List<Integer> getMarketsRegionIdTypes(Integer regionId, String datasource, String ifNoneMatch, Integer page) throws ApiException {
        ApiResponse<List<Integer>> localVarResp = this.getMarketsRegionIdTypesWithHttpInfo(regionId, datasource, ifNoneMatch, page);
        return localVarResp.getData();
    }

    public ApiResponse<List<Integer>> getMarketsRegionIdTypesWithHttpInfo(Integer regionId, String datasource, String ifNoneMatch, Integer page) throws ApiException {
        Call localVarCall = this.getMarketsRegionIdTypesValidateBeforeCall(regionId, datasource, ifNoneMatch, page, null);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMarketsRegionIdTypesAsync(Integer regionId, String datasource, String ifNoneMatch, Integer page, ApiCallback<List<Integer>> _callback) throws ApiException {
        Call localVarCall = this.getMarketsRegionIdTypesValidateBeforeCall(regionId, datasource, ifNoneMatch, page, _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMarketsStructuresStructureIdCall(Long structureId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/markets/structures/{structure_id}/".replace("{structure_id}", this.localVarApiClient.escapeString(structureId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMarketsStructuresStructureIdValidateBeforeCall(Long structureId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        if (structureId == null) {
            throw new ApiException("Missing the required parameter 'structureId' when calling getMarketsStructuresStructureId(Async)");
        }
        return this.getMarketsStructuresStructureIdCall(structureId, datasource, ifNoneMatch, page, token, _callback);
    }

    public List<MarketStructuresResponse> getMarketsStructuresStructureId(Long structureId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<MarketStructuresResponse>> localVarResp = this.getMarketsStructuresStructureIdWithHttpInfo(structureId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<MarketStructuresResponse>> getMarketsStructuresStructureIdWithHttpInfo(Long structureId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        Call localVarCall = this.getMarketsStructuresStructureIdValidateBeforeCall(structureId, datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<MarketStructuresResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMarketsStructuresStructureIdAsync(Long structureId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback<List<MarketStructuresResponse>> _callback) throws ApiException {
        Call localVarCall = this.getMarketsStructuresStructureIdValidateBeforeCall(structureId, datasource, ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<MarketStructuresResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

