/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.model.CharacterPlanetResponse;
import net.troja.eve.esi.model.CharacterPlanetsResponse;
import net.troja.eve.esi.model.CorporationCustomsOfficesResponse;
import net.troja.eve.esi.model.PlanetFactorySchematicResponse;
import okhttp3.Call;

public class PlanetaryInteractionApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public PlanetaryInteractionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PlanetaryInteractionApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getCharactersCharacterIdPlanetsCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/characters/{character_id}/planets/".replace("{character_id}", this.localVarApiClient.escapeString(characterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCharactersCharacterIdPlanetsValidateBeforeCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (characterId == null) {
            throw new ApiException("Missing the required parameter 'characterId' when calling getCharactersCharacterIdPlanets(Async)");
        }
        return this.getCharactersCharacterIdPlanetsCall(characterId, datasource, ifNoneMatch, token, _callback);
    }

    public List<CharacterPlanetsResponse> getCharactersCharacterIdPlanets(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CharacterPlanetsResponse>> localVarResp = this.getCharactersCharacterIdPlanetsWithHttpInfo(characterId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CharacterPlanetsResponse>> getCharactersCharacterIdPlanetsWithHttpInfo(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdPlanetsValidateBeforeCall(characterId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterPlanetsResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCharactersCharacterIdPlanetsAsync(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback<List<CharacterPlanetsResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdPlanetsValidateBeforeCall(characterId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<List<CharacterPlanetsResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCharactersCharacterIdPlanetsPlanetIdCall(Integer characterId, Integer planetId, String datasource, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/characters/{character_id}/planets/{planet_id}/".replace("{character_id}", this.localVarApiClient.escapeString(characterId.toString())).replace("{planet_id}", this.localVarApiClient.escapeString(planetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCharactersCharacterIdPlanetsPlanetIdValidateBeforeCall(Integer characterId, Integer planetId, String datasource, String token, ApiCallback _callback) throws ApiException {
        if (characterId == null) {
            throw new ApiException("Missing the required parameter 'characterId' when calling getCharactersCharacterIdPlanetsPlanetId(Async)");
        }
        if (planetId == null) {
            throw new ApiException("Missing the required parameter 'planetId' when calling getCharactersCharacterIdPlanetsPlanetId(Async)");
        }
        return this.getCharactersCharacterIdPlanetsPlanetIdCall(characterId, planetId, datasource, token, _callback);
    }

    public CharacterPlanetResponse getCharactersCharacterIdPlanetsPlanetId(Integer characterId, Integer planetId, String datasource, String token) throws ApiException {
        ApiResponse<CharacterPlanetResponse> localVarResp = this.getCharactersCharacterIdPlanetsPlanetIdWithHttpInfo(characterId, planetId, datasource, token);
        return localVarResp.getData();
    }

    public ApiResponse<CharacterPlanetResponse> getCharactersCharacterIdPlanetsPlanetIdWithHttpInfo(Integer characterId, Integer planetId, String datasource, String token) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdPlanetsPlanetIdValidateBeforeCall(characterId, planetId, datasource, token, null);
        Type localVarReturnType = new TypeToken<CharacterPlanetResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCharactersCharacterIdPlanetsPlanetIdAsync(Integer characterId, Integer planetId, String datasource, String token, ApiCallback<CharacterPlanetResponse> _callback) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdPlanetsPlanetIdValidateBeforeCall(characterId, planetId, datasource, token, _callback);
        Type localVarReturnType = new TypeToken<CharacterPlanetResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdCustomsOfficesCall(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/corporations/{corporation_id}/customs_offices/".replace("{corporation_id}", this.localVarApiClient.escapeString(corporationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdCustomsOfficesValidateBeforeCall(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdCustomsOffices(Async)");
        }
        return this.getCorporationsCorporationIdCustomsOfficesCall(corporationId, datasource, ifNoneMatch, page, token, _callback);
    }

    public List<CorporationCustomsOfficesResponse> getCorporationsCorporationIdCustomsOffices(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationCustomsOfficesResponse>> localVarResp = this.getCorporationsCorporationIdCustomsOfficesWithHttpInfo(corporationId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CorporationCustomsOfficesResponse>> getCorporationsCorporationIdCustomsOfficesWithHttpInfo(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdCustomsOfficesValidateBeforeCall(corporationId, datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationCustomsOfficesResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdCustomsOfficesAsync(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback<List<CorporationCustomsOfficesResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdCustomsOfficesValidateBeforeCall(corporationId, datasource, ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationCustomsOfficesResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseSchematicsSchematicIdCall(Integer schematicId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/universe/schematics/{schematic_id}/".replace("{schematic_id}", this.localVarApiClient.escapeString(schematicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseSchematicsSchematicIdValidateBeforeCall(Integer schematicId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (schematicId == null) {
            throw new ApiException("Missing the required parameter 'schematicId' when calling getUniverseSchematicsSchematicId(Async)");
        }
        return this.getUniverseSchematicsSchematicIdCall(schematicId, datasource, ifNoneMatch, _callback);
    }

    public PlanetFactorySchematicResponse getUniverseSchematicsSchematicId(Integer schematicId, String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<PlanetFactorySchematicResponse> localVarResp = this.getUniverseSchematicsSchematicIdWithHttpInfo(schematicId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<PlanetFactorySchematicResponse> getUniverseSchematicsSchematicIdWithHttpInfo(Integer schematicId, String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getUniverseSchematicsSchematicIdValidateBeforeCall(schematicId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<PlanetFactorySchematicResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseSchematicsSchematicIdAsync(Integer schematicId, String datasource, String ifNoneMatch, ApiCallback<PlanetFactorySchematicResponse> _callback) throws ApiException {
        Call localVarCall = this.getUniverseSchematicsSchematicIdValidateBeforeCall(schematicId, datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<PlanetFactorySchematicResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

