/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.model.CharacterSearchResponse;
import okhttp3.Call;

public class SearchApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SearchApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SearchApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getCharactersCharacterIdSearchCall(Set<String> categories, Integer characterId, String search, String acceptLanguage, String datasource, String ifNoneMatch, String language, Boolean strict, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/characters/{character_id}/search/".replace("{character_id}", this.localVarApiClient.escapeString(characterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (categories != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "categories", categories));
        }
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (language != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("language", language));
        }
        if (search != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("search", search));
        }
        if (strict != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("strict", strict));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", this.localVarApiClient.parameterToString(acceptLanguage));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCharactersCharacterIdSearchValidateBeforeCall(Set<String> categories, Integer characterId, String search, String acceptLanguage, String datasource, String ifNoneMatch, String language, Boolean strict, String token, ApiCallback _callback) throws ApiException {
        if (categories == null) {
            throw new ApiException("Missing the required parameter 'categories' when calling getCharactersCharacterIdSearch(Async)");
        }
        if (characterId == null) {
            throw new ApiException("Missing the required parameter 'characterId' when calling getCharactersCharacterIdSearch(Async)");
        }
        if (search == null) {
            throw new ApiException("Missing the required parameter 'search' when calling getCharactersCharacterIdSearch(Async)");
        }
        return this.getCharactersCharacterIdSearchCall(categories, characterId, search, acceptLanguage, datasource, ifNoneMatch, language, strict, token, _callback);
    }

    public CharacterSearchResponse getCharactersCharacterIdSearch(Set<String> categories, Integer characterId, String search, String acceptLanguage, String datasource, String ifNoneMatch, String language, Boolean strict, String token) throws ApiException {
        ApiResponse<CharacterSearchResponse> localVarResp = this.getCharactersCharacterIdSearchWithHttpInfo(categories, characterId, search, acceptLanguage, datasource, ifNoneMatch, language, strict, token);
        return localVarResp.getData();
    }

    public ApiResponse<CharacterSearchResponse> getCharactersCharacterIdSearchWithHttpInfo(Set<String> categories, Integer characterId, String search, String acceptLanguage, String datasource, String ifNoneMatch, String language, Boolean strict, String token) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdSearchValidateBeforeCall(categories, characterId, search, acceptLanguage, datasource, ifNoneMatch, language, strict, token, null);
        Type localVarReturnType = new TypeToken<CharacterSearchResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCharactersCharacterIdSearchAsync(Set<String> categories, Integer characterId, String search, String acceptLanguage, String datasource, String ifNoneMatch, String language, Boolean strict, String token, ApiCallback<CharacterSearchResponse> _callback) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdSearchValidateBeforeCall(categories, characterId, search, acceptLanguage, datasource, ifNoneMatch, language, strict, token, _callback);
        Type localVarReturnType = new TypeToken<CharacterSearchResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

