/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiClientBuilder;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.api.MetaApi;
import net.troja.eve.esi.auth.OAuth;
import net.troja.eve.esi.model.CharacterInfo;
import okhttp3.Call;

public class SsoApi {
    private static final String URI_REVOKE = "https://login.eveonline.com";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String REFRESH_TOKEN = "refresh_token";
    private static final String DATASOURCE = "tranquility";
    protected static final String DATE_FORMAT = "yyyy-MM-dd'T'hh:mm:ss";
    private final ApiClient localVarApiClient = new ApiClientBuilder().build();
    private ApiClient apiClient;
    private MetaApi metaApi;

    public SsoApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SsoApi(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.metaApi = new MetaApi(apiClient);
        this.localVarApiClient.setBasePath(URI_REVOKE);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.metaApi.setApiClient(apiClient);
    }

    public CharacterInfo getCharacterInfo() throws ApiException {
        return new CharacterInfo(this.metaApi.getVerify(null, null, DATASOURCE, null, null));
    }

    public void revokeRefreshToken(String refreshToken) throws ApiException {
        this.postRevokeToken(refreshToken, REFRESH_TOKEN);
    }

    public void revokeAccessToken(String accessToken) throws ApiException {
        this.postRevokeToken(accessToken, ACCESS_TOKEN);
    }

    public Call postRevokeTokenCall(String token, String tokenTypeHint, ApiCallback _callback) throws ApiException {
        String basePath = null;
        Object localVarPostBody = new Object();
        OAuth auth = (OAuth)this.apiClient.getAuthentication("evesso");
        String localVarPath = "/v2/oauth/revoke";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Host", "login.eveonline.com");
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarFormParams.put("token_type_hint", tokenTypeHint);
        localVarFormParams.put("client_id", auth.getClientId());
        localVarFormParams.put("token", token);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        basePath = URI_REVOKE;
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    public void postRevokeToken(String token, String tokenTypeHint) throws ApiException {
        this.postRevokeTokenWithHttpInfo(token, tokenTypeHint);
    }

    public ApiResponse<Void> postRevokeTokenWithHttpInfo(String token, String tokenTypeHint) throws ApiException {
        Call localVarCall = this.postRevokeTokenCall(token, tokenTypeHint, null);
        Type localVarReturnType = new TypeToken<Void>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postRevokeTokenAsync(String token, String tokenTypeHint, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.postRevokeTokenCall(token, tokenTypeHint, _callback);
        Type localVarReturnType = new TypeToken<Void>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

