/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.model.WarKillmailsResponse;
import net.troja.eve.esi.model.WarResponse;
import okhttp3.Call;

public class WarsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public WarsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WarsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getWarsCall(String datasource, String ifNoneMatch, Integer maxWarId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/wars/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (maxWarId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_war_id", maxWarId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getWarsValidateBeforeCall(String datasource, String ifNoneMatch, Integer maxWarId, ApiCallback _callback) throws ApiException {
        return this.getWarsCall(datasource, ifNoneMatch, maxWarId, _callback);
    }

    public List<Integer> getWars(String datasource, String ifNoneMatch, Integer maxWarId) throws ApiException {
        ApiResponse<List<Integer>> localVarResp = this.getWarsWithHttpInfo(datasource, ifNoneMatch, maxWarId);
        return localVarResp.getData();
    }

    public ApiResponse<List<Integer>> getWarsWithHttpInfo(String datasource, String ifNoneMatch, Integer maxWarId) throws ApiException {
        Call localVarCall = this.getWarsValidateBeforeCall(datasource, ifNoneMatch, maxWarId, null);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getWarsAsync(String datasource, String ifNoneMatch, Integer maxWarId, ApiCallback<List<Integer>> _callback) throws ApiException {
        Call localVarCall = this.getWarsValidateBeforeCall(datasource, ifNoneMatch, maxWarId, _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getWarsWarIdCall(Integer warId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/wars/{war_id}/".replace("{war_id}", this.localVarApiClient.escapeString(warId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getWarsWarIdValidateBeforeCall(Integer warId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (warId == null) {
            throw new ApiException("Missing the required parameter 'warId' when calling getWarsWarId(Async)");
        }
        return this.getWarsWarIdCall(warId, datasource, ifNoneMatch, _callback);
    }

    public WarResponse getWarsWarId(Integer warId, String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<WarResponse> localVarResp = this.getWarsWarIdWithHttpInfo(warId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<WarResponse> getWarsWarIdWithHttpInfo(Integer warId, String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getWarsWarIdValidateBeforeCall(warId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<WarResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getWarsWarIdAsync(Integer warId, String datasource, String ifNoneMatch, ApiCallback<WarResponse> _callback) throws ApiException {
        Call localVarCall = this.getWarsWarIdValidateBeforeCall(warId, datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<WarResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getWarsWarIdKillmailsCall(Integer warId, String datasource, String ifNoneMatch, Integer page, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/wars/{war_id}/killmails/".replace("{war_id}", this.localVarApiClient.escapeString(warId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getWarsWarIdKillmailsValidateBeforeCall(Integer warId, String datasource, String ifNoneMatch, Integer page, ApiCallback _callback) throws ApiException {
        if (warId == null) {
            throw new ApiException("Missing the required parameter 'warId' when calling getWarsWarIdKillmails(Async)");
        }
        return this.getWarsWarIdKillmailsCall(warId, datasource, ifNoneMatch, page, _callback);
    }

    public List<WarKillmailsResponse> getWarsWarIdKillmails(Integer warId, String datasource, String ifNoneMatch, Integer page) throws ApiException {
        ApiResponse<List<WarKillmailsResponse>> localVarResp = this.getWarsWarIdKillmailsWithHttpInfo(warId, datasource, ifNoneMatch, page);
        return localVarResp.getData();
    }

    public ApiResponse<List<WarKillmailsResponse>> getWarsWarIdKillmailsWithHttpInfo(Integer warId, String datasource, String ifNoneMatch, Integer page) throws ApiException {
        Call localVarCall = this.getWarsWarIdKillmailsValidateBeforeCall(warId, datasource, ifNoneMatch, page, null);
        Type localVarReturnType = new TypeToken<List<WarKillmailsResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getWarsWarIdKillmailsAsync(Integer warId, String datasource, String ifNoneMatch, Integer page, ApiCallback<List<WarKillmailsResponse>> _callback) throws ApiException {
        Call localVarCall = this.getWarsWarIdKillmailsValidateBeforeCall(warId, datasource, ifNoneMatch, page, _callback);
        Type localVarReturnType = new TypeToken<List<WarKillmailsResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

