/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.auth;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;

public class JWT {
    private final Header header;
    private final Payload payload;
    private final String signature;

    public JWT(Header header, Payload payload, String signature) {
        this.header = header;
        this.payload = payload;
        this.signature = signature;
    }

    public Header getHeader() {
        return this.header;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public String getSignature() {
        return this.signature;
    }

    public static class PayloadDeserializer
    implements JsonDeserializer<Payload> {
        public Payload deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            Payload payload = new Payload();
            JsonElement element = jsonObject.get("scp");
            if (element != null) {
                if (element.isJsonArray()) {
                    for (JsonElement item : element.getAsJsonArray()) {
                        payload.scopes.add(item.getAsString());
                    }
                } else {
                    payload.scopes.add(element.getAsString());
                }
            }
            payload.jti = jsonObject.get("jti").getAsString();
            payload.kid = jsonObject.get("kid").getAsString();
            payload.sub = jsonObject.get("sub").getAsString();
            try {
                payload.characterID = Integer.valueOf(payload.sub.substring("CHARACTER:EVE:".length()));
            }
            catch (NumberFormatException ex) {
                payload.characterID = null;
            }
            payload.azp = jsonObject.get("azp").getAsString();
            payload.name = jsonObject.get("name").getAsString();
            payload.owner = jsonObject.get("owner").getAsString();
            payload.jti = jsonObject.get("jti").getAsString();
            payload.exp = jsonObject.get("exp").getAsString();
            payload.iss = jsonObject.get("iss").getAsString();
            return payload;
        }
    }

    public static class Payload {
        private Set<String> scopes = new HashSet<String>();
        private String jti;
        private String kid;
        private String sub;
        private String azp;
        private String name;
        private String owner;
        private String exp;
        private String iss;
        private Integer characterID;

        public Set<String> getScopes() {
            return this.scopes;
        }

        public void setScopes(Set<String> scopes) {
            this.scopes = scopes;
        }

        public String getJti() {
            return this.jti;
        }

        public String getKid() {
            return this.kid;
        }

        public String getSub() {
            return this.sub;
        }

        public void setSub(String sub) {
            this.sub = sub;
        }

        public Integer getCharacterID() {
            return this.characterID;
        }

        public String getAzp() {
            return this.azp;
        }

        public String getName() {
            return this.name;
        }

        public String getOwner() {
            return this.owner;
        }

        public String getExp() {
            return this.exp;
        }

        public String getIss() {
            return this.iss;
        }
    }

    public static class Header {
        private String alg;
        private String typ;

        public String getAlg() {
            return this.alg;
        }

        public void setAlg(String alg) {
            this.alg = alg;
        }

        public String getTyp() {
            return this.typ;
        }

        public void setTyp(String typ) {
            this.typ = typ;
        }
    }
}

