/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.troja.eve.esi.JSON;

public class AllianceContactsResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CONTACT_ID = "contact_id";
    @SerializedName(value="contact_id")
    @Nonnull
    private Integer contactId;
    public static final String SERIALIZED_NAME_CONTACT_TYPE = "contact_type";
    @SerializedName(value="contact_type")
    @Nonnull
    private String contactType;
    private ContactTypeEnum contactTypeEnum;
    public static final String SERIALIZED_NAME_LABEL_IDS = "label_ids";
    @SerializedName(value="label_ids")
    @Nullable
    private List<Long> labelIds;
    public static final String SERIALIZED_NAME_STANDING = "standing";
    @SerializedName(value="standing")
    @Nonnull
    private Float standing;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AllianceContactsResponse contactId(@Nonnull Integer contactId) {
        this.contactId = contactId;
        return this;
    }

    @Nonnull
    public Integer getContactId() {
        return this.contactId;
    }

    public void setContactId(@Nonnull Integer contactId) {
        this.contactId = contactId;
    }

    public AllianceContactsResponse contactType(@Nonnull ContactTypeEnum contactType) {
        this.contactTypeEnum = contactType;
        return this;
    }

    public AllianceContactsResponse contactTypeString(@Nonnull String contactType) {
        this.contactType = contactType;
        return this;
    }

    public ContactTypeEnum getContactType() {
        if (this.contactTypeEnum == null) {
            this.contactTypeEnum = ContactTypeEnum.fromValue(this.contactType);
        }
        return this.contactTypeEnum;
    }

    public String getContactTypeString() {
        return this.contactType;
    }

    public void setContactType(@Nonnull ContactTypeEnum contactType) {
        this.contactTypeEnum = contactType;
    }

    public void setContactTypeString(@Nonnull String contactType) {
        this.contactType = contactType;
    }

    public AllianceContactsResponse labelIds(@Nullable List<Long> labelIds) {
        this.labelIds = labelIds;
        return this;
    }

    public AllianceContactsResponse addLabelIdsItem(Long labelIdsItem) {
        if (this.labelIds == null) {
            this.labelIds = new ArrayList<Long>();
        }
        this.labelIds.add(labelIdsItem);
        return this;
    }

    @Nullable
    public List<Long> getLabelIds() {
        return this.labelIds;
    }

    public void setLabelIds(@Nullable List<Long> labelIds) {
        this.labelIds = labelIds;
    }

    public AllianceContactsResponse standing(@Nonnull Float standing) {
        this.standing = standing;
        return this;
    }

    @Nonnull
    public Float getStanding() {
        return this.standing;
    }

    public void setStanding(@Nonnull Float standing) {
        this.standing = standing;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AllianceContactsResponse allianceContactsResponse = (AllianceContactsResponse)o;
        return Objects.equals(this.contactId, allianceContactsResponse.contactId) && Objects.equals(this.contactType, allianceContactsResponse.contactType) && Objects.equals(this.labelIds, allianceContactsResponse.labelIds) && Objects.equals(this.standing, allianceContactsResponse.standing);
    }

    public int hashCode() {
        return Objects.hash(this.contactId, this.contactType, this.labelIds, this.standing);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AllianceContactsResponse {\n");
        sb.append("    contactId: ").append(this.toIndentedString(this.contactId)).append("\n");
        sb.append("    contactType: ").append(this.toIndentedString(this.contactType)).append("\n");
        sb.append("    labelIds: ").append(this.toIndentedString(this.labelIds)).append("\n");
        sb.append("    standing: ").append(this.toIndentedString(this.standing)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in AllianceContactsResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AllianceContactsResponse` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_CONTACT_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `contact_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTACT_TYPE).toString()));
        }
        ContactTypeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CONTACT_TYPE));
        if (jsonObj.get(SERIALIZED_NAME_LABEL_IDS) != null && !jsonObj.get(SERIALIZED_NAME_LABEL_IDS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LABEL_IDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `label_ids` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LABEL_IDS).toString()));
        }
    }

    public static AllianceContactsResponse fromJson(String jsonString) throws IOException {
        return (AllianceContactsResponse)JSON.getGson().fromJson(jsonString, AllianceContactsResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONTACT_ID);
        openapiFields.add(SERIALIZED_NAME_CONTACT_TYPE);
        openapiFields.add(SERIALIZED_NAME_LABEL_IDS);
        openapiFields.add(SERIALIZED_NAME_STANDING);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_CONTACT_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_CONTACT_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_STANDING);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AllianceContactsResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AllianceContactsResponse.class));
            return new TypeAdapter<AllianceContactsResponse>(){

                public void write(JsonWriter out, AllianceContactsResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AllianceContactsResponse read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    AllianceContactsResponse.validateJsonElement(jsonElement);
                    return (AllianceContactsResponse)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ContactTypeEnum {
        CHARACTER("character"),
        CORPORATION("corporation"),
        ALLIANCE("alliance"),
        FACTION("faction");

        private String value;

        private ContactTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ContactTypeEnum fromValue(String value) {
            for (ContactTypeEnum b : ContactTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            ContactTypeEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<ContactTypeEnum> {
            public void write(JsonWriter jsonWriter, ContactTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ContactTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ContactTypeEnum.fromValue(value);
            }
        }
    }
}

